"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Chatbot = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [chatbot](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awschatbot.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Chatbot extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [chatbot](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awschatbot.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'chatbot';
        this.accessLevelList = {
            Write: [
                'CreateChimeWebhookConfiguration',
                'CreateMicrosoftTeamsChannelConfiguration',
                'CreateSlackChannelConfiguration',
                'DeleteChimeWebhookConfiguration',
                'DeleteMicrosoftTeamsChannelConfiguration',
                'DeleteMicrosoftTeamsConfiguredTeam',
                'DeleteMicrosoftTeamsUserIdentity',
                'DeleteSlackChannelConfiguration',
                'DeleteSlackUserIdentity',
                'DeleteSlackWorkspaceAuthorization',
                'RedeemMicrosoftTeamsOauthCode',
                'RedeemSlackOauthCode',
                'UpdateAccountPreferences',
                'UpdateChimeWebhookConfiguration',
                'UpdateMicrosoftTeamsChannelConfiguration',
                'UpdateSlackChannelConfiguration'
            ],
            Read: [
                'DescribeChimeWebhookConfigurations',
                'DescribeSlackChannelConfigurations',
                'DescribeSlackChannels',
                'DescribeSlackUserIdentities',
                'DescribeSlackWorkspaces',
                'GetAccountPreferences',
                'GetMicrosoftTeamsChannelConfiguration',
                'GetMicrosoftTeamsOauthParameters',
                'GetSlackOauthParameters',
                'ListMicrosoftTeamsChannelConfigurations',
                'ListMicrosoftTeamsConfiguredTeams',
                'ListMicrosoftTeamsUserIdentities'
            ]
        };
    }
    /**
     * Grants permission to create an AWS Chatbot Chime Webhook Configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toCreateChimeWebhookConfiguration() {
        return this.to('CreateChimeWebhookConfiguration');
    }
    /**
     * Grants permission to create an AWS Chatbot Microsoft Teams Channel Configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toCreateMicrosoftTeamsChannelConfiguration() {
        return this.to('CreateMicrosoftTeamsChannelConfiguration');
    }
    /**
     * Grants permission to create an AWS Chatbot Slack Channel Configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toCreateSlackChannelConfiguration() {
        return this.to('CreateSlackChannelConfiguration');
    }
    /**
     * Grants permission to delete an AWS Chatbot Chime Webhook Configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toDeleteChimeWebhookConfiguration() {
        return this.to('DeleteChimeWebhookConfiguration');
    }
    /**
     * Grants permission to delete an AWS Chatbot Microsoft Teams Channel Configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toDeleteMicrosoftTeamsChannelConfiguration() {
        return this.to('DeleteMicrosoftTeamsChannelConfiguration');
    }
    /**
     * Grants permission to delete the Microsoft Teams configured with AWS Chatbot in an AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toDeleteMicrosoftTeamsConfiguredTeam() {
        return this.to('DeleteMicrosoftTeamsConfiguredTeam');
    }
    /**
     * Grants permission to delete an AWS Chatbot Microsoft Teams User Identity
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toDeleteMicrosoftTeamsUserIdentity() {
        return this.to('DeleteMicrosoftTeamsUserIdentity');
    }
    /**
     * Grants permission to delete an AWS Chatbot Slack Channel Configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toDeleteSlackChannelConfiguration() {
        return this.to('DeleteSlackChannelConfiguration');
    }
    /**
     * Grants permission to delete an AWS Chatbot Slack User Identity
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toDeleteSlackUserIdentity() {
        return this.to('DeleteSlackUserIdentity');
    }
    /**
     * Grants permission to delete the Slack workspace authorization with AWS Chatbot, associated with an AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toDeleteSlackWorkspaceAuthorization() {
        return this.to('DeleteSlackWorkspaceAuthorization');
    }
    /**
     * Grants permission to list all AWS Chatbot Chime Webhook Configurations in an AWS Account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toDescribeChimeWebhookConfigurations() {
        return this.to('DescribeChimeWebhookConfigurations');
    }
    /**
     * Grants permission to list all AWS Chatbot Slack Channel Configurations in an AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toDescribeSlackChannelConfigurations() {
        return this.to('DescribeSlackChannelConfigurations');
    }
    /**
     * Grants permission to list all public Slack channels in the Slack workspace connected to the AWS Account onboarded with AWS Chatbot service
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toDescribeSlackChannels() {
        return this.to('DescribeSlackChannels');
    }
    /**
     * Grants permission to describe AWS Chatbot Slack User Identities
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toDescribeSlackUserIdentities() {
        return this.to('DescribeSlackUserIdentities');
    }
    /**
     * Grants permission to list all authorized Slack workspaces connected to the AWS Account onboarded with AWS Chatbot service
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toDescribeSlackWorkspaces() {
        return this.to('DescribeSlackWorkspaces');
    }
    /**
     * Grants permission to retrieve AWS Chatbot account preferences
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toGetAccountPreferences() {
        return this.to('GetAccountPreferences');
    }
    /**
     * Grants permission to get a single AWS Chatbot Microsoft Teams Channel Configurations in an AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toGetMicrosoftTeamsChannelConfiguration() {
        return this.to('GetMicrosoftTeamsChannelConfiguration');
    }
    /**
     * Grants permission to generate OAuth parameters to request Microsoft Teams OAuth code to be used by the AWS Chatbot service
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toGetMicrosoftTeamsOauthParameters() {
        return this.to('GetMicrosoftTeamsOauthParameters');
    }
    /**
     * Grants permission to generate OAuth parameters to request Slack OAuth code to be used by the AWS Chatbot service
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toGetSlackOauthParameters() {
        return this.to('GetSlackOauthParameters');
    }
    /**
     * Grants permission to list all AWS Chatbot Microsoft Teams Channel Configurations in an AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toListMicrosoftTeamsChannelConfigurations() {
        return this.to('ListMicrosoftTeamsChannelConfigurations');
    }
    /**
     * Grants permission to list all Microsoft Teams connected to the AWS Account onboarded with AWS Chatbot service
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toListMicrosoftTeamsConfiguredTeams() {
        return this.to('ListMicrosoftTeamsConfiguredTeams');
    }
    /**
     * Grants permission to describe AWS Chatbot Microsoft Teams User Identities
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toListMicrosoftTeamsUserIdentities() {
        return this.to('ListMicrosoftTeamsUserIdentities');
    }
    /**
     * Grants permission to redeem previously generated parameters with Microsoft APIs, to acquire OAuth tokens to be used by the AWS Chatbot service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toRedeemMicrosoftTeamsOauthCode() {
        return this.to('RedeemMicrosoftTeamsOauthCode');
    }
    /**
     * Grants permission to redeem previously generated parameters with Slack API, to acquire OAuth tokens to be used by the AWS Chatbot service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toRedeemSlackOauthCode() {
        return this.to('RedeemSlackOauthCode');
    }
    /**
     * Grants permission to update AWS Chatbot account preferences
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toUpdateAccountPreferences() {
        return this.to('UpdateAccountPreferences');
    }
    /**
     * Grants permission to update an AWS Chatbot Chime Webhook Configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toUpdateChimeWebhookConfiguration() {
        return this.to('UpdateChimeWebhookConfiguration');
    }
    /**
     * Grants permission to update an AWS Chatbot Microsoft Teams Channel Configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toUpdateMicrosoftTeamsChannelConfiguration() {
        return this.to('UpdateMicrosoftTeamsChannelConfiguration');
    }
    /**
     * Grants permission to update an AWS Chatbot Slack Channel Configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     */
    toUpdateSlackChannelConfiguration() {
        return this.to('UpdateSlackChannelConfiguration');
    }
    /**
     * Adds a resource of type ChatbotConfiguration to the statement
     *
     * https://docs.aws.amazon.com/chatbot/latest/adminguide/what-is.html
     *
     * @param configurationType - Identifier for the configurationType.
     * @param chatbotConfigurationName - Identifier for the chatbotConfigurationName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onChatbotConfiguration(configurationType, chatbotConfigurationName, account, partition) {
        return this.on(`arn:${partition || Chatbot.defaultPartition}:chatbot::${account || '*'}:chat-configuration/${configurationType}/${chatbotConfigurationName}`);
    }
}
exports.Chatbot = Chatbot;
_a = JSII_RTTI_SYMBOL_1;
Chatbot[_a] = { fqn: "iam-floyd.Chatbot", version: "0.502.0" };
//# sourceMappingURL=data:application/json;base64,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