"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cleanrooms = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [cleanrooms](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscleanrooms.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Cleanrooms extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [cleanrooms](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscleanrooms.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'cleanrooms';
        this.accessLevelList = {
            Read: [
                'BatchGetSchema',
                'GetCollaboration',
                'GetConfiguredTable',
                'GetConfiguredTableAnalysisRule',
                'GetConfiguredTableAssociation',
                'GetMembership',
                'GetProtectedQuery',
                'GetSchema',
                'GetSchemaAnalysisRule'
            ],
            Write: [
                'CreateCollaboration',
                'CreateConfiguredTable',
                'CreateConfiguredTableAnalysisRule',
                'CreateConfiguredTableAssociation',
                'CreateMembership',
                'DeleteCollaboration',
                'DeleteConfiguredTable',
                'DeleteConfiguredTableAnalysisRule',
                'DeleteConfiguredTableAssociation',
                'DeleteMember',
                'DeleteMembership',
                'StartProtectedQuery',
                'UpdateCollaboration',
                'UpdateConfiguredTable',
                'UpdateConfiguredTableAnalysisRule',
                'UpdateConfiguredTableAssociation',
                'UpdateMembership',
                'UpdateProtectedQuery'
            ],
            List: [
                'ListCollaborations',
                'ListConfiguredTableAssociations',
                'ListConfiguredTables',
                'ListMembers',
                'ListMemberships',
                'ListProtectedQueries',
                'ListSchemas',
                'ListTagsForResource'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to view details for schemas
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - cleanrooms:GetSchema
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_BatchGetSchema.html
     */
    toBatchGetSchema() {
        return this.to('BatchGetSchema');
    }
    /**
     * Grants permission to create a new collaboration, a shared data collaboration environment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateCollaboration.html
     */
    toCreateCollaboration() {
        return this.to('CreateCollaboration');
    }
    /**
     * Grants permission to create a new configured table
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - glue:BatchGetPartition
     * - glue:GetDatabase
     * - glue:GetDatabases
     * - glue:GetPartition
     * - glue:GetPartitions
     * - glue:GetSchemaVersion
     * - glue:GetTable
     * - glue:GetTables
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateConfiguredTable.html
     */
    toCreateConfiguredTable() {
        return this.to('CreateConfiguredTable');
    }
    /**
     * Grants permission to create a analysis rule for a configured table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateConfiguredTableAnalysisRule.html
     */
    toCreateConfiguredTableAnalysisRule() {
        return this.to('CreateConfiguredTableAnalysisRule');
    }
    /**
     * Grants permission to link a configured table with a collaboration by creating a new association
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateConfiguredTableAssociation.html
     */
    toCreateConfiguredTableAssociation() {
        return this.to('CreateConfiguredTableAssociation');
    }
    /**
     * Grants permission to join collaborations by creating a membership
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - logs:CreateLogDelivery
     * - logs:CreateLogGroup
     * - logs:DeleteLogDelivery
     * - logs:DescribeLogGroups
     * - logs:DescribeResourcePolicies
     * - logs:GetLogDelivery
     * - logs:ListLogDeliveries
     * - logs:PutResourcePolicy
     * - logs:UpdateLogDelivery
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_CreateMembership.html
     */
    toCreateMembership() {
        return this.to('CreateMembership');
    }
    /**
     * Grants permission to delete an existing collaboration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_DeleteCollaboration.html
     */
    toDeleteCollaboration() {
        return this.to('DeleteCollaboration');
    }
    /**
     * Grants permission to delete a configured table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_DeleteConfiguredTable.html
     */
    toDeleteConfiguredTable() {
        return this.to('DeleteConfiguredTable');
    }
    /**
     * Grants permission to delete an existing analysis rule
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_DeleteConfiguredTableAnalysisRule.html
     */
    toDeleteConfiguredTableAnalysisRule() {
        return this.to('DeleteConfiguredTableAnalysisRule');
    }
    /**
     * Grants permission to remove a configured table association from a collaboration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_DeleteConfiguredTableAssociation.html
     */
    toDeleteConfiguredTableAssociation() {
        return this.to('DeleteConfiguredTableAssociation');
    }
    /**
     * Grants permission to delete members from a collaboration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_DeleteMember.html
     */
    toDeleteMember() {
        return this.to('DeleteMember');
    }
    /**
     * Grants permission to leave collaborations by deleting a membership
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_DeleteMembership.html
     */
    toDeleteMembership() {
        return this.to('DeleteMembership');
    }
    /**
     * Grants permission to view details for a collaboration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_GetCollaboration.html
     */
    toGetCollaboration() {
        return this.to('GetCollaboration');
    }
    /**
     * Grants permission to view details for a configured table
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_GetConfiguredTable.html
     */
    toGetConfiguredTable() {
        return this.to('GetConfiguredTable');
    }
    /**
     * Grants permission to view analysis rules for a configured table
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_GetConfiguredTableAnalysisRule.html
     */
    toGetConfiguredTableAnalysisRule() {
        return this.to('GetConfiguredTableAnalysisRule');
    }
    /**
     * Grants permission to view details for a configured table association
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_GetConfiguredTableAssociation.html
     */
    toGetConfiguredTableAssociation() {
        return this.to('GetConfiguredTableAssociation');
    }
    /**
     * Grants permission to view details about a membership
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_GetMembership.html
     */
    toGetMembership() {
        return this.to('GetMembership');
    }
    /**
     * Grants permission to view a protected query
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_GetProtectedQuery.html
     */
    toGetProtectedQuery() {
        return this.to('GetProtectedQuery');
    }
    /**
     * Grants permission to view details for a schema
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_GetSchema.html
     */
    toGetSchema() {
        return this.to('GetSchema');
    }
    /**
     * Grants permission to view analysis rules associated with a schema
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_GetSchemaAnalysisRule.html
     */
    toGetSchemaAnalysisRule() {
        return this.to('GetSchemaAnalysisRule');
    }
    /**
     * Grants permission to list available collaborations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_ListCollaborations.html
     */
    toListCollaborations() {
        return this.to('ListCollaborations');
    }
    /**
     * Grants permission to list available configured table associations for a membership
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_ListConfiguredTableAssociations.html
     */
    toListConfiguredTableAssociations() {
        return this.to('ListConfiguredTableAssociations');
    }
    /**
     * Grants permission to list available configured tables
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_ListConfiguredTables.html
     */
    toListConfiguredTables() {
        return this.to('ListConfiguredTables');
    }
    /**
     * Grants permission to list the members of a collaboration
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_ListMembers.html
     */
    toListMembers() {
        return this.to('ListMembers');
    }
    /**
     * Grants permission to list available memberships
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_ListMemberships.html
     */
    toListMemberships() {
        return this.to('ListMemberships');
    }
    /**
     * Grants permission to list protected queries
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_ListProtectedQueries.html
     */
    toListProtectedQueries() {
        return this.to('ListProtectedQueries');
    }
    /**
     * Grants permission to view available schemas for a collaboration
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_ListSchemas.html
     */
    toListSchemas() {
        return this.to('ListSchemas');
    }
    /**
     * Grants permission to list tags for a resource
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to start protected queries
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - cleanrooms:GetSchema
     * - s3:GetBucketLocation
     * - s3:ListBucket
     * - s3:PutObject
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_StartProtectedQuery.html
     */
    toStartProtectedQuery() {
        return this.to('StartProtectedQuery');
    }
    /**
     * Grants permission to tag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to untag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update details of the collaboration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_UpdateCollaboration.html
     */
    toUpdateCollaboration() {
        return this.to('UpdateCollaboration');
    }
    /**
     * Grants permission to update an existing configured table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_UpdateConfiguredTable.html
     */
    toUpdateConfiguredTable() {
        return this.to('UpdateConfiguredTable');
    }
    /**
     * Grants permission to update analysis rules for a configured table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_UpdateConfiguredTableAnalysisRule.html
     */
    toUpdateConfiguredTableAnalysisRule() {
        return this.to('UpdateConfiguredTableAnalysisRule');
    }
    /**
     * Grants permission to update a configured table association
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_UpdateConfiguredTableAssociation.html
     */
    toUpdateConfiguredTableAssociation() {
        return this.to('UpdateConfiguredTableAssociation');
    }
    /**
     * Grants permission to update details of a membership
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - logs:CreateLogDelivery
     * - logs:CreateLogGroup
     * - logs:DeleteLogDelivery
     * - logs:DescribeLogGroups
     * - logs:DescribeResourcePolicies
     * - logs:GetLogDelivery
     * - logs:ListLogDeliveries
     * - logs:PutResourcePolicy
     * - logs:UpdateLogDelivery
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_UpdateMembership.html
     */
    toUpdateMembership() {
        return this.to('UpdateMembership');
    }
    /**
     * Grants permission to update protected queries
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/apireference/API_UpdateProtectedQuery.html
     */
    toUpdateProtectedQuery() {
        return this.to('UpdateProtectedQuery');
    }
    /**
     * Adds a resource of type Collaboration to the statement
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/userguide/security-iam.html
     *
     * @param collaborationId - Identifier for the collaborationId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onCollaboration(collaborationId, account, region, partition) {
        return this.on(`arn:${partition || Cleanrooms.defaultPartition}:cleanrooms:${region || '*'}:${account || '*'}:collaboration/${collaborationId}`);
    }
    /**
     * Adds a resource of type ConfiguredTable to the statement
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/userguide/security-iam.html
     *
     * @param configuredTableId - Identifier for the configuredTableId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onConfiguredTable(configuredTableId, account, region, partition) {
        return this.on(`arn:${partition || Cleanrooms.defaultPartition}:cleanrooms:${region || '*'}:${account || '*'}:configuredtable/${configuredTableId}`);
    }
    /**
     * Adds a resource of type ConfiguredTableAssociation to the statement
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/userguide/security-iam.html
     *
     * @param membershipId - Identifier for the membershipId.
     * @param configuredTableAssociationId - Identifier for the configuredTableAssociationId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onConfiguredTableAssociation(membershipId, configuredTableAssociationId, account, region, partition) {
        return this.on(`arn:${partition || Cleanrooms.defaultPartition}:cleanrooms:${region || '*'}:${account || '*'}:membership/${membershipId}/configuredtableassociation/${configuredTableAssociationId}`);
    }
    /**
     * Adds a resource of type Membership to the statement
     *
     * https://docs.aws.amazon.com/clean-rooms/latest/userguide/security-iam.html
     *
     * @param membershipId - Identifier for the membershipId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onMembership(membershipId, account, region, partition) {
        return this.on(`arn:${partition || Cleanrooms.defaultPartition}:cleanrooms:${region || '*'}:${account || '*'}:membership/${membershipId}`);
    }
}
exports.Cleanrooms = Cleanrooms;
_a = JSII_RTTI_SYMBOL_1;
Cleanrooms[_a] = { fqn: "iam-floyd.Cleanrooms", version: "0.502.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2xlYW5yb29tcy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImNsZWFucm9vbXMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFDQSxzQ0FBNEM7QUFFNUM7Ozs7R0FJRztBQUNILE1BQWEsVUFBVyxTQUFRLHdCQUFlO0lBRzdDOzs7O09BSUc7SUFDSCxZQUFZLEdBQVk7UUFDdEIsS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDO1FBUk4sa0JBQWEsR0FBRyxZQUFZLENBQUM7UUF3ZDFCLG9CQUFlLEdBQW9CO1lBQzNDLElBQUksRUFBRTtnQkFDSixnQkFBZ0I7Z0JBQ2hCLGtCQUFrQjtnQkFDbEIsb0JBQW9CO2dCQUNwQixnQ0FBZ0M7Z0JBQ2hDLCtCQUErQjtnQkFDL0IsZUFBZTtnQkFDZixtQkFBbUI7Z0JBQ25CLFdBQVc7Z0JBQ1gsdUJBQXVCO2FBQ3hCO1lBQ0QsS0FBSyxFQUFFO2dCQUNMLHFCQUFxQjtnQkFDckIsdUJBQXVCO2dCQUN2QixtQ0FBbUM7Z0JBQ25DLGtDQUFrQztnQkFDbEMsa0JBQWtCO2dCQUNsQixxQkFBcUI7Z0JBQ3JCLHVCQUF1QjtnQkFDdkIsbUNBQW1DO2dCQUNuQyxrQ0FBa0M7Z0JBQ2xDLGNBQWM7Z0JBQ2Qsa0JBQWtCO2dCQUNsQixxQkFBcUI7Z0JBQ3JCLHFCQUFxQjtnQkFDckIsdUJBQXVCO2dCQUN2QixtQ0FBbUM7Z0JBQ25DLGtDQUFrQztnQkFDbEMsa0JBQWtCO2dCQUNsQixzQkFBc0I7YUFDdkI7WUFDRCxJQUFJLEVBQUU7Z0JBQ0osb0JBQW9CO2dCQUNwQixpQ0FBaUM7Z0JBQ2pDLHNCQUFzQjtnQkFDdEIsYUFBYTtnQkFDYixpQkFBaUI7Z0JBQ2pCLHNCQUFzQjtnQkFDdEIsYUFBYTtnQkFDYixxQkFBcUI7YUFDdEI7WUFDRCxPQUFPLEVBQUU7Z0JBQ1AsYUFBYTtnQkFDYixlQUFlO2FBQ2hCO1NBQ0YsQ0FBQztJQTdmRixDQUFDO0lBRUQ7Ozs7Ozs7OztPQVNHO0lBQ0ksZ0JBQWdCO1FBQ3JCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDO0lBQ25DLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxxQkFBcUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHFCQUFxQixDQUFDLENBQUM7SUFDeEMsQ0FBQztJQUVEOzs7Ozs7Ozs7Ozs7Ozs7O09BZ0JHO0lBQ0ksdUJBQXVCO1FBQzVCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyx1QkFBdUIsQ0FBQyxDQUFDO0lBQzFDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxtQ0FBbUM7UUFDeEMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLG1DQUFtQyxDQUFDLENBQUM7SUFDdEQsQ0FBQztJQUVEOzs7Ozs7Ozs7T0FTRztJQUNJLGtDQUFrQztRQUN2QyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsa0NBQWtDLENBQUMsQ0FBQztJQUNyRCxDQUFDO0lBRUQ7Ozs7Ozs7Ozs7Ozs7Ozs7O09BaUJHO0lBQ0ksa0JBQWtCO1FBQ3ZCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO0lBQ3JDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxxQkFBcUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHFCQUFxQixDQUFDLENBQUM7SUFDeEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHVCQUF1QjtRQUM1QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsdUJBQXVCLENBQUMsQ0FBQztJQUMxQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksbUNBQW1DO1FBQ3hDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxtQ0FBbUMsQ0FBQyxDQUFDO0lBQ3RELENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxrQ0FBa0M7UUFDdkMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGtDQUFrQyxDQUFDLENBQUM7SUFDckQsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGNBQWM7UUFDbkIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGNBQWMsQ0FBQyxDQUFDO0lBQ2pDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxrQkFBa0I7UUFDdkIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGtCQUFrQixDQUFDLENBQUM7SUFDckMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGtCQUFrQjtRQUN2QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsa0JBQWtCLENBQUMsQ0FBQztJQUNyQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksb0JBQW9CO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDO0lBQ3ZDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxnQ0FBZ0M7UUFDckMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGdDQUFnQyxDQUFDLENBQUM7SUFDbkQsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLCtCQUErQjtRQUNwQyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsK0JBQStCLENBQUMsQ0FBQztJQUNsRCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksZUFBZTtRQUNwQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsZUFBZSxDQUFDLENBQUM7SUFDbEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLG1CQUFtQjtRQUN4QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsbUJBQW1CLENBQUMsQ0FBQztJQUN0QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksV0FBVztRQUNoQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsV0FBVyxDQUFDLENBQUM7SUFDOUIsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHVCQUF1QjtRQUM1QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsdUJBQXVCLENBQUMsQ0FBQztJQUMxQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksb0JBQW9CO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDO0lBQ3ZDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxpQ0FBaUM7UUFDdEMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGlDQUFpQyxDQUFDLENBQUM7SUFDcEQsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHNCQUFzQjtRQUMzQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsc0JBQXNCLENBQUMsQ0FBQztJQUN6QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksYUFBYTtRQUNsQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsYUFBYSxDQUFDLENBQUM7SUFDaEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGlCQUFpQjtRQUN0QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsaUJBQWlCLENBQUMsQ0FBQztJQUNwQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksc0JBQXNCO1FBQzNCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO0lBQ3pDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxhQUFhO1FBQ2xCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxhQUFhLENBQUMsQ0FBQztJQUNoQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0kscUJBQXFCO1FBQzFCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO0lBQ3hDLENBQUM7SUFFRDs7Ozs7Ozs7Ozs7O09BWUc7SUFDSSxxQkFBcUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHFCQUFxQixDQUFDLENBQUM7SUFDeEMsQ0FBQztJQUVEOzs7Ozs7Ozs7O09BVUc7SUFDSSxhQUFhO1FBQ2xCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxhQUFhLENBQUMsQ0FBQztJQUNoQyxDQUFDO0lBRUQ7Ozs7Ozs7OztPQVNHO0lBQ0ksZUFBZTtRQUNwQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsZUFBZSxDQUFDLENBQUM7SUFDbEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHFCQUFxQjtRQUMxQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMscUJBQXFCLENBQUMsQ0FBQztJQUN4QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksdUJBQXVCO1FBQzVCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyx1QkFBdUIsQ0FBQyxDQUFDO0lBQzFDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxtQ0FBbUM7UUFDeEMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLG1DQUFtQyxDQUFDLENBQUM7SUFDdEQsQ0FBQztJQUVEOzs7Ozs7Ozs7T0FTRztJQUNJLGtDQUFrQztRQUN2QyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsa0NBQWtDLENBQUMsQ0FBQztJQUNyRCxDQUFDO0lBRUQ7Ozs7Ozs7Ozs7Ozs7Ozs7O09BaUJHO0lBQ0ksa0JBQWtCO1FBQ3ZCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO0lBQ3JDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxzQkFBc0I7UUFDM0IsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHNCQUFzQixDQUFDLENBQUM7SUFDekMsQ0FBQztJQWtERDs7Ozs7Ozs7Ozs7O09BWUc7SUFDSSxlQUFlLENBQUMsZUFBdUIsRUFBRSxPQUFnQixFQUFFLE1BQWUsRUFBRSxTQUFrQjtRQUNuRyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsT0FBUSxTQUFTLElBQUksVUFBVSxDQUFDLGdCQUFpQixlQUFnQixNQUFNLElBQUksR0FBSSxJQUFLLE9BQU8sSUFBSSxHQUFJLGtCQUFtQixlQUFnQixFQUFFLENBQUMsQ0FBQztJQUMzSixDQUFDO0lBRUQ7Ozs7Ozs7Ozs7OztPQVlHO0lBQ0ksaUJBQWlCLENBQUMsaUJBQXlCLEVBQUUsT0FBZ0IsRUFBRSxNQUFlLEVBQUUsU0FBa0I7UUFDdkcsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLE9BQVEsU0FBUyxJQUFJLFVBQVUsQ0FBQyxnQkFBaUIsZUFBZ0IsTUFBTSxJQUFJLEdBQUksSUFBSyxPQUFPLElBQUksR0FBSSxvQkFBcUIsaUJBQWtCLEVBQUUsQ0FBQyxDQUFDO0lBQy9KLENBQUM7SUFFRDs7Ozs7Ozs7Ozs7OztPQWFHO0lBQ0ksNEJBQTRCLENBQUMsWUFBb0IsRUFBRSw0QkFBb0MsRUFBRSxPQUFnQixFQUFFLE1BQWUsRUFBRSxTQUFrQjtRQUNuSixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsT0FBUSxTQUFTLElBQUksVUFBVSxDQUFDLGdCQUFpQixlQUFnQixNQUFNLElBQUksR0FBSSxJQUFLLE9BQU8sSUFBSSxHQUFJLGVBQWdCLFlBQWEsK0JBQWdDLDRCQUE2QixFQUFFLENBQUMsQ0FBQztJQUNsTixDQUFDO0lBRUQ7Ozs7Ozs7Ozs7OztPQVlHO0lBQ0ksWUFBWSxDQUFDLFlBQW9CLEVBQUUsT0FBZ0IsRUFBRSxNQUFlLEVBQUUsU0FBa0I7UUFDN0YsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLE9BQVEsU0FBUyxJQUFJLFVBQVUsQ0FBQyxnQkFBaUIsZUFBZ0IsTUFBTSxJQUFJLEdBQUksSUFBSyxPQUFPLElBQUksR0FBSSxlQUFnQixZQUFhLEVBQUUsQ0FBQyxDQUFDO0lBQ3JKLENBQUM7O0FBNWtCSCxnQ0E2a0JDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQWNjZXNzTGV2ZWxMaXN0IH0gZnJvbSAnLi4vc2hhcmVkL2FjY2Vzcy1sZXZlbCc7XG5pbXBvcnQgeyBQb2xpY3lTdGF0ZW1lbnQgfSBmcm9tICcuLi9zaGFyZWQnO1xuXG4vKipcbiAqIFN0YXRlbWVudCBwcm92aWRlciBmb3Igc2VydmljZSBbY2xlYW5yb29tc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3NlcnZpY2UtYXV0aG9yaXphdGlvbi9sYXRlc3QvcmVmZXJlbmNlL2xpc3RfYXdzY2xlYW5yb29tcy5odG1sKS5cbiAqXG4gKiBAcGFyYW0gc2lkIFtTSURdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9JQU0vbGF0ZXN0L1VzZXJHdWlkZS9yZWZlcmVuY2VfcG9saWNpZXNfZWxlbWVudHNfc2lkLmh0bWwpIG9mIHRoZSBzdGF0ZW1lbnRcbiAqL1xuZXhwb3J0IGNsYXNzIENsZWFucm9vbXMgZXh0ZW5kcyBQb2xpY3lTdGF0ZW1lbnQge1xuICBwdWJsaWMgc2VydmljZVByZWZpeCA9ICdjbGVhbnJvb21zJztcblxuICAvKipcbiAgICogU3RhdGVtZW50IHByb3ZpZGVyIGZvciBzZXJ2aWNlIFtjbGVhbnJvb21zXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vc2VydmljZS1hdXRob3JpemF0aW9uL2xhdGVzdC9yZWZlcmVuY2UvbGlzdF9hd3NjbGVhbnJvb21zLmh0bWwpLlxuICAgKlxuICAgKiBAcGFyYW0gc2lkIFtTSURdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9JQU0vbGF0ZXN0L1VzZXJHdWlkZS9yZWZlcmVuY2VfcG9saWNpZXNfZWxlbWVudHNfc2lkLmh0bWwpIG9mIHRoZSBzdGF0ZW1lbnRcbiAgICovXG4gIGNvbnN0cnVjdG9yKHNpZD86IHN0cmluZykge1xuICAgIHN1cGVyKHNpZCk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gdmlldyBkZXRhaWxzIGZvciBzY2hlbWFzXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBEZXBlbmRlbnQgYWN0aW9uczpcbiAgICogLSBjbGVhbnJvb21zOkdldFNjaGVtYVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY2xlYW4tcm9vbXMvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfQmF0Y2hHZXRTY2hlbWEuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQmF0Y2hHZXRTY2hlbWEoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0JhdGNoR2V0U2NoZW1hJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gY3JlYXRlIGEgbmV3IGNvbGxhYm9yYXRpb24sIGEgc2hhcmVkIGRhdGEgY29sbGFib3JhdGlvbiBlbnZpcm9ubWVudFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jbGVhbi1yb29tcy9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9DcmVhdGVDb2xsYWJvcmF0aW9uLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0NyZWF0ZUNvbGxhYm9yYXRpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0NyZWF0ZUNvbGxhYm9yYXRpb24nKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBjcmVhdGUgYSBuZXcgY29uZmlndXJlZCB0YWJsZVxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIERlcGVuZGVudCBhY3Rpb25zOlxuICAgKiAtIGdsdWU6QmF0Y2hHZXRQYXJ0aXRpb25cbiAgICogLSBnbHVlOkdldERhdGFiYXNlXG4gICAqIC0gZ2x1ZTpHZXREYXRhYmFzZXNcbiAgICogLSBnbHVlOkdldFBhcnRpdGlvblxuICAgKiAtIGdsdWU6R2V0UGFydGl0aW9uc1xuICAgKiAtIGdsdWU6R2V0U2NoZW1hVmVyc2lvblxuICAgKiAtIGdsdWU6R2V0VGFibGVcbiAgICogLSBnbHVlOkdldFRhYmxlc1xuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY2xlYW4tcm9vbXMvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfQ3JlYXRlQ29uZmlndXJlZFRhYmxlLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0NyZWF0ZUNvbmZpZ3VyZWRUYWJsZSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQ3JlYXRlQ29uZmlndXJlZFRhYmxlJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gY3JlYXRlIGEgYW5hbHlzaXMgcnVsZSBmb3IgYSBjb25maWd1cmVkIHRhYmxlXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2NsZWFuLXJvb21zL2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0NyZWF0ZUNvbmZpZ3VyZWRUYWJsZUFuYWx5c2lzUnVsZS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9DcmVhdGVDb25maWd1cmVkVGFibGVBbmFseXNpc1J1bGUoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0NyZWF0ZUNvbmZpZ3VyZWRUYWJsZUFuYWx5c2lzUnVsZScpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGxpbmsgYSBjb25maWd1cmVkIHRhYmxlIHdpdGggYSBjb2xsYWJvcmF0aW9uIGJ5IGNyZWF0aW5nIGEgbmV3IGFzc29jaWF0aW9uXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogRGVwZW5kZW50IGFjdGlvbnM6XG4gICAqIC0gaWFtOlBhc3NSb2xlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jbGVhbi1yb29tcy9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9DcmVhdGVDb25maWd1cmVkVGFibGVBc3NvY2lhdGlvbi5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9DcmVhdGVDb25maWd1cmVkVGFibGVBc3NvY2lhdGlvbigpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQ3JlYXRlQ29uZmlndXJlZFRhYmxlQXNzb2NpYXRpb24nKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBqb2luIGNvbGxhYm9yYXRpb25zIGJ5IGNyZWF0aW5nIGEgbWVtYmVyc2hpcFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIERlcGVuZGVudCBhY3Rpb25zOlxuICAgKiAtIGxvZ3M6Q3JlYXRlTG9nRGVsaXZlcnlcbiAgICogLSBsb2dzOkNyZWF0ZUxvZ0dyb3VwXG4gICAqIC0gbG9nczpEZWxldGVMb2dEZWxpdmVyeVxuICAgKiAtIGxvZ3M6RGVzY3JpYmVMb2dHcm91cHNcbiAgICogLSBsb2dzOkRlc2NyaWJlUmVzb3VyY2VQb2xpY2llc1xuICAgKiAtIGxvZ3M6R2V0TG9nRGVsaXZlcnlcbiAgICogLSBsb2dzOkxpc3RMb2dEZWxpdmVyaWVzXG4gICAqIC0gbG9nczpQdXRSZXNvdXJjZVBvbGljeVxuICAgKiAtIGxvZ3M6VXBkYXRlTG9nRGVsaXZlcnlcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2NsZWFuLXJvb21zL2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0NyZWF0ZU1lbWJlcnNoaXAuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQ3JlYXRlTWVtYmVyc2hpcCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQ3JlYXRlTWVtYmVyc2hpcCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGRlbGV0ZSBhbiBleGlzdGluZyBjb2xsYWJvcmF0aW9uXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2NsZWFuLXJvb21zL2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0RlbGV0ZUNvbGxhYm9yYXRpb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVsZXRlQ29sbGFib3JhdGlvbigpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVsZXRlQ29sbGFib3JhdGlvbicpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGRlbGV0ZSBhIGNvbmZpZ3VyZWQgdGFibGVcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY2xlYW4tcm9vbXMvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfRGVsZXRlQ29uZmlndXJlZFRhYmxlLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0RlbGV0ZUNvbmZpZ3VyZWRUYWJsZSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVsZXRlQ29uZmlndXJlZFRhYmxlJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZGVsZXRlIGFuIGV4aXN0aW5nIGFuYWx5c2lzIHJ1bGVcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY2xlYW4tcm9vbXMvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfRGVsZXRlQ29uZmlndXJlZFRhYmxlQW5hbHlzaXNSdWxlLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0RlbGV0ZUNvbmZpZ3VyZWRUYWJsZUFuYWx5c2lzUnVsZSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVsZXRlQ29uZmlndXJlZFRhYmxlQW5hbHlzaXNSdWxlJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gcmVtb3ZlIGEgY29uZmlndXJlZCB0YWJsZSBhc3NvY2lhdGlvbiBmcm9tIGEgY29sbGFib3JhdGlvblxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jbGVhbi1yb29tcy9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9EZWxldGVDb25maWd1cmVkVGFibGVBc3NvY2lhdGlvbi5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZWxldGVDb25maWd1cmVkVGFibGVBc3NvY2lhdGlvbigpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVsZXRlQ29uZmlndXJlZFRhYmxlQXNzb2NpYXRpb24nKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBkZWxldGUgbWVtYmVycyBmcm9tIGEgY29sbGFib3JhdGlvblxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jbGVhbi1yb29tcy9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9EZWxldGVNZW1iZXIuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVsZXRlTWVtYmVyKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZWxldGVNZW1iZXInKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBsZWF2ZSBjb2xsYWJvcmF0aW9ucyBieSBkZWxldGluZyBhIG1lbWJlcnNoaXBcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY2xlYW4tcm9vbXMvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfRGVsZXRlTWVtYmVyc2hpcC5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZWxldGVNZW1iZXJzaGlwKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZWxldGVNZW1iZXJzaGlwJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gdmlldyBkZXRhaWxzIGZvciBhIGNvbGxhYm9yYXRpb25cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jbGVhbi1yb29tcy9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9HZXRDb2xsYWJvcmF0aW9uLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0dldENvbGxhYm9yYXRpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldENvbGxhYm9yYXRpb24nKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byB2aWV3IGRldGFpbHMgZm9yIGEgY29uZmlndXJlZCB0YWJsZVxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2NsZWFuLXJvb21zL2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0dldENvbmZpZ3VyZWRUYWJsZS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9HZXRDb25maWd1cmVkVGFibGUoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldENvbmZpZ3VyZWRUYWJsZScpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHZpZXcgYW5hbHlzaXMgcnVsZXMgZm9yIGEgY29uZmlndXJlZCB0YWJsZVxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2NsZWFuLXJvb21zL2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0dldENvbmZpZ3VyZWRUYWJsZUFuYWx5c2lzUnVsZS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9HZXRDb25maWd1cmVkVGFibGVBbmFseXNpc1J1bGUoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldENvbmZpZ3VyZWRUYWJsZUFuYWx5c2lzUnVsZScpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHZpZXcgZGV0YWlscyBmb3IgYSBjb25maWd1cmVkIHRhYmxlIGFzc29jaWF0aW9uXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY2xlYW4tcm9vbXMvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfR2V0Q29uZmlndXJlZFRhYmxlQXNzb2NpYXRpb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvR2V0Q29uZmlndXJlZFRhYmxlQXNzb2NpYXRpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldENvbmZpZ3VyZWRUYWJsZUFzc29jaWF0aW9uJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gdmlldyBkZXRhaWxzIGFib3V0IGEgbWVtYmVyc2hpcFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2NsZWFuLXJvb21zL2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0dldE1lbWJlcnNoaXAuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvR2V0TWVtYmVyc2hpcCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnR2V0TWVtYmVyc2hpcCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHZpZXcgYSBwcm90ZWN0ZWQgcXVlcnlcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jbGVhbi1yb29tcy9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9HZXRQcm90ZWN0ZWRRdWVyeS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9HZXRQcm90ZWN0ZWRRdWVyeSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnR2V0UHJvdGVjdGVkUXVlcnknKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byB2aWV3IGRldGFpbHMgZm9yIGEgc2NoZW1hXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY2xlYW4tcm9vbXMvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfR2V0U2NoZW1hLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0dldFNjaGVtYSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnR2V0U2NoZW1hJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gdmlldyBhbmFseXNpcyBydWxlcyBhc3NvY2lhdGVkIHdpdGggYSBzY2hlbWFcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jbGVhbi1yb29tcy9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9HZXRTY2hlbWFBbmFseXNpc1J1bGUuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvR2V0U2NoZW1hQW5hbHlzaXNSdWxlKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdHZXRTY2hlbWFBbmFseXNpc1J1bGUnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBsaXN0IGF2YWlsYWJsZSBjb2xsYWJvcmF0aW9uc1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IExpc3RcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2NsZWFuLXJvb21zL2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0xpc3RDb2xsYWJvcmF0aW9ucy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0Q29sbGFib3JhdGlvbnMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0xpc3RDb2xsYWJvcmF0aW9ucycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGxpc3QgYXZhaWxhYmxlIGNvbmZpZ3VyZWQgdGFibGUgYXNzb2NpYXRpb25zIGZvciBhIG1lbWJlcnNoaXBcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jbGVhbi1yb29tcy9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9MaXN0Q29uZmlndXJlZFRhYmxlQXNzb2NpYXRpb25zLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RDb25maWd1cmVkVGFibGVBc3NvY2lhdGlvbnMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0xpc3RDb25maWd1cmVkVGFibGVBc3NvY2lhdGlvbnMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBsaXN0IGF2YWlsYWJsZSBjb25maWd1cmVkIHRhYmxlc1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IExpc3RcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2NsZWFuLXJvb21zL2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0xpc3RDb25maWd1cmVkVGFibGVzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RDb25maWd1cmVkVGFibGVzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0Q29uZmlndXJlZFRhYmxlcycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGxpc3QgdGhlIG1lbWJlcnMgb2YgYSBjb2xsYWJvcmF0aW9uXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY2xlYW4tcm9vbXMvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfTGlzdE1lbWJlcnMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTGlzdE1lbWJlcnMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0xpc3RNZW1iZXJzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gbGlzdCBhdmFpbGFibGUgbWVtYmVyc2hpcHNcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jbGVhbi1yb29tcy9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9MaXN0TWVtYmVyc2hpcHMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTGlzdE1lbWJlcnNoaXBzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0TWVtYmVyc2hpcHMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBsaXN0IHByb3RlY3RlZCBxdWVyaWVzXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY2xlYW4tcm9vbXMvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfTGlzdFByb3RlY3RlZFF1ZXJpZXMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTGlzdFByb3RlY3RlZFF1ZXJpZXMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0xpc3RQcm90ZWN0ZWRRdWVyaWVzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gdmlldyBhdmFpbGFibGUgc2NoZW1hcyBmb3IgYSBjb2xsYWJvcmF0aW9uXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY2xlYW4tcm9vbXMvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfTGlzdFNjaGVtYXMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTGlzdFNjaGVtYXMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0xpc3RTY2hlbWFzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gbGlzdCB0YWdzIGZvciBhIHJlc291cmNlXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY2xlYW4tcm9vbXMvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfTGlzdFRhZ3NGb3JSZXNvdXJjZS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0VGFnc0ZvclJlc291cmNlKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0VGFnc0ZvclJlc291cmNlJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gc3RhcnQgcHJvdGVjdGVkIHF1ZXJpZXNcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBEZXBlbmRlbnQgYWN0aW9uczpcbiAgICogLSBjbGVhbnJvb21zOkdldFNjaGVtYVxuICAgKiAtIHMzOkdldEJ1Y2tldExvY2F0aW9uXG4gICAqIC0gczM6TGlzdEJ1Y2tldFxuICAgKiAtIHMzOlB1dE9iamVjdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY2xlYW4tcm9vbXMvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfU3RhcnRQcm90ZWN0ZWRRdWVyeS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9TdGFydFByb3RlY3RlZFF1ZXJ5KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdTdGFydFByb3RlY3RlZFF1ZXJ5Jyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gdGFnIGEgcmVzb3VyY2VcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBUYWdnaW5nXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmQXdzVGFnS2V5cygpXG4gICAqIC0gLmlmQXdzUmVxdWVzdFRhZygpXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jbGVhbi1yb29tcy9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9UYWdSZXNvdXJjZS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9UYWdSZXNvdXJjZSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnVGFnUmVzb3VyY2UnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byB1bnRhZyBhIHJlc291cmNlXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogVGFnZ2luZ1xuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZkF3c1RhZ0tleXMoKVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY2xlYW4tcm9vbXMvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfVW50YWdSZXNvdXJjZS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9VbnRhZ1Jlc291cmNlKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdVbnRhZ1Jlc291cmNlJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gdXBkYXRlIGRldGFpbHMgb2YgdGhlIGNvbGxhYm9yYXRpb25cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY2xlYW4tcm9vbXMvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfVXBkYXRlQ29sbGFib3JhdGlvbi5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9VcGRhdGVDb2xsYWJvcmF0aW9uKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdVcGRhdGVDb2xsYWJvcmF0aW9uJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gdXBkYXRlIGFuIGV4aXN0aW5nIGNvbmZpZ3VyZWQgdGFibGVcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY2xlYW4tcm9vbXMvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfVXBkYXRlQ29uZmlndXJlZFRhYmxlLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1VwZGF0ZUNvbmZpZ3VyZWRUYWJsZSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnVXBkYXRlQ29uZmlndXJlZFRhYmxlJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gdXBkYXRlIGFuYWx5c2lzIHJ1bGVzIGZvciBhIGNvbmZpZ3VyZWQgdGFibGVcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY2xlYW4tcm9vbXMvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfVXBkYXRlQ29uZmlndXJlZFRhYmxlQW5hbHlzaXNSdWxlLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1VwZGF0ZUNvbmZpZ3VyZWRUYWJsZUFuYWx5c2lzUnVsZSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnVXBkYXRlQ29uZmlndXJlZFRhYmxlQW5hbHlzaXNSdWxlJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gdXBkYXRlIGEgY29uZmlndXJlZCB0YWJsZSBhc3NvY2lhdGlvblxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIERlcGVuZGVudCBhY3Rpb25zOlxuICAgKiAtIGlhbTpQYXNzUm9sZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY2xlYW4tcm9vbXMvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfVXBkYXRlQ29uZmlndXJlZFRhYmxlQXNzb2NpYXRpb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvVXBkYXRlQ29uZmlndXJlZFRhYmxlQXNzb2NpYXRpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1VwZGF0ZUNvbmZpZ3VyZWRUYWJsZUFzc29jaWF0aW9uJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gdXBkYXRlIGRldGFpbHMgb2YgYSBtZW1iZXJzaGlwXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogRGVwZW5kZW50IGFjdGlvbnM6XG4gICAqIC0gbG9nczpDcmVhdGVMb2dEZWxpdmVyeVxuICAgKiAtIGxvZ3M6Q3JlYXRlTG9nR3JvdXBcbiAgICogLSBsb2dzOkRlbGV0ZUxvZ0RlbGl2ZXJ5XG4gICAqIC0gbG9nczpEZXNjcmliZUxvZ0dyb3Vwc1xuICAgKiAtIGxvZ3M6RGVzY3JpYmVSZXNvdXJjZVBvbGljaWVzXG4gICAqIC0gbG9nczpHZXRMb2dEZWxpdmVyeVxuICAgKiAtIGxvZ3M6TGlzdExvZ0RlbGl2ZXJpZXNcbiAgICogLSBsb2dzOlB1dFJlc291cmNlUG9saWN5XG4gICAqIC0gbG9nczpVcGRhdGVMb2dEZWxpdmVyeVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY2xlYW4tcm9vbXMvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfVXBkYXRlTWVtYmVyc2hpcC5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9VcGRhdGVNZW1iZXJzaGlwKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdVcGRhdGVNZW1iZXJzaGlwJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gdXBkYXRlIHByb3RlY3RlZCBxdWVyaWVzXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2NsZWFuLXJvb21zL2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX1VwZGF0ZVByb3RlY3RlZFF1ZXJ5Lmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1VwZGF0ZVByb3RlY3RlZFF1ZXJ5KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdVcGRhdGVQcm90ZWN0ZWRRdWVyeScpO1xuICB9XG5cbiAgcHJvdGVjdGVkIGFjY2Vzc0xldmVsTGlzdDogQWNjZXNzTGV2ZWxMaXN0ID0ge1xuICAgIFJlYWQ6IFtcbiAgICAgICdCYXRjaEdldFNjaGVtYScsXG4gICAgICAnR2V0Q29sbGFib3JhdGlvbicsXG4gICAgICAnR2V0Q29uZmlndXJlZFRhYmxlJyxcbiAgICAgICdHZXRDb25maWd1cmVkVGFibGVBbmFseXNpc1J1bGUnLFxuICAgICAgJ0dldENvbmZpZ3VyZWRUYWJsZUFzc29jaWF0aW9uJyxcbiAgICAgICdHZXRNZW1iZXJzaGlwJyxcbiAgICAgICdHZXRQcm90ZWN0ZWRRdWVyeScsXG4gICAgICAnR2V0U2NoZW1hJyxcbiAgICAgICdHZXRTY2hlbWFBbmFseXNpc1J1bGUnXG4gICAgXSxcbiAgICBXcml0ZTogW1xuICAgICAgJ0NyZWF0ZUNvbGxhYm9yYXRpb24nLFxuICAgICAgJ0NyZWF0ZUNvbmZpZ3VyZWRUYWJsZScsXG4gICAgICAnQ3JlYXRlQ29uZmlndXJlZFRhYmxlQW5hbHlzaXNSdWxlJyxcbiAgICAgICdDcmVhdGVDb25maWd1cmVkVGFibGVBc3NvY2lhdGlvbicsXG4gICAgICAnQ3JlYXRlTWVtYmVyc2hpcCcsXG4gICAgICAnRGVsZXRlQ29sbGFib3JhdGlvbicsXG4gICAgICAnRGVsZXRlQ29uZmlndXJlZFRhYmxlJyxcbiAgICAgICdEZWxldGVDb25maWd1cmVkVGFibGVBbmFseXNpc1J1bGUnLFxuICAgICAgJ0RlbGV0ZUNvbmZpZ3VyZWRUYWJsZUFzc29jaWF0aW9uJyxcbiAgICAgICdEZWxldGVNZW1iZXInLFxuICAgICAgJ0RlbGV0ZU1lbWJlcnNoaXAnLFxuICAgICAgJ1N0YXJ0UHJvdGVjdGVkUXVlcnknLFxuICAgICAgJ1VwZGF0ZUNvbGxhYm9yYXRpb24nLFxuICAgICAgJ1VwZGF0ZUNvbmZpZ3VyZWRUYWJsZScsXG4gICAgICAnVXBkYXRlQ29uZmlndXJlZFRhYmxlQW5hbHlzaXNSdWxlJyxcbiAgICAgICdVcGRhdGVDb25maWd1cmVkVGFibGVBc3NvY2lhdGlvbicsXG4gICAgICAnVXBkYXRlTWVtYmVyc2hpcCcsXG4gICAgICAnVXBkYXRlUHJvdGVjdGVkUXVlcnknXG4gICAgXSxcbiAgICBMaXN0OiBbXG4gICAgICAnTGlzdENvbGxhYm9yYXRpb25zJyxcbiAgICAgICdMaXN0Q29uZmlndXJlZFRhYmxlQXNzb2NpYXRpb25zJyxcbiAgICAgICdMaXN0Q29uZmlndXJlZFRhYmxlcycsXG4gICAgICAnTGlzdE1lbWJlcnMnLFxuICAgICAgJ0xpc3RNZW1iZXJzaGlwcycsXG4gICAgICAnTGlzdFByb3RlY3RlZFF1ZXJpZXMnLFxuICAgICAgJ0xpc3RTY2hlbWFzJyxcbiAgICAgICdMaXN0VGFnc0ZvclJlc291cmNlJ1xuICAgIF0sXG4gICAgVGFnZ2luZzogW1xuICAgICAgJ1RhZ1Jlc291cmNlJyxcbiAgICAgICdVbnRhZ1Jlc291cmNlJ1xuICAgIF1cbiAgfTtcblxuICAvKipcbiAgICogQWRkcyBhIHJlc291cmNlIG9mIHR5cGUgQ29sbGFib3JhdGlvbiB0byB0aGUgc3RhdGVtZW50XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jbGVhbi1yb29tcy9sYXRlc3QvdXNlcmd1aWRlL3NlY3VyaXR5LWlhbS5odG1sXG4gICAqXG4gICAqIEBwYXJhbSBjb2xsYWJvcmF0aW9uSWQgLSBJZGVudGlmaWVyIGZvciB0aGUgY29sbGFib3JhdGlvbklkLlxuICAgKiBAcGFyYW0gYWNjb3VudCAtIEFjY291bnQgb2YgdGhlIHJlc291cmNlOyBkZWZhdWx0cyB0byBlbXB0eSBzdHJpbmc6IGFsbCBhY2NvdW50cy5cbiAgICogQHBhcmFtIHJlZ2lvbiAtIFJlZ2lvbiBvZiB0aGUgcmVzb3VyY2U7IGRlZmF1bHRzIHRvIGVtcHR5IHN0cmluZzogYWxsIHJlZ2lvbnMuXG4gICAqIEBwYXJhbSBwYXJ0aXRpb24gLSBQYXJ0aXRpb24gb2YgdGhlIEFXUyBhY2NvdW50IFthd3MsIGF3cy1jbiwgYXdzLXVzLWdvdl07IGRlZmF1bHRzIHRvIGBhd3NgLCB1bmxlc3MgdXNpbmcgdGhlIENESywgd2hlcmUgdGhlIGRlZmF1bHQgaXMgdGhlIGN1cnJlbnQgU3RhY2sncyBwYXJ0aXRpb24uXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmQXdzUmVzb3VyY2VUYWcoKVxuICAgKi9cbiAgcHVibGljIG9uQ29sbGFib3JhdGlvbihjb2xsYWJvcmF0aW9uSWQ6IHN0cmluZywgYWNjb3VudD86IHN0cmluZywgcmVnaW9uPzogc3RyaW5nLCBwYXJ0aXRpb24/OiBzdHJpbmcpIHtcbiAgICByZXR1cm4gdGhpcy5vbihgYXJuOiR7IHBhcnRpdGlvbiB8fCBDbGVhbnJvb21zLmRlZmF1bHRQYXJ0aXRpb24gfTpjbGVhbnJvb21zOiR7IHJlZ2lvbiB8fCAnKicgfTokeyBhY2NvdW50IHx8ICcqJyB9OmNvbGxhYm9yYXRpb24vJHsgY29sbGFib3JhdGlvbklkIH1gKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBBZGRzIGEgcmVzb3VyY2Ugb2YgdHlwZSBDb25maWd1cmVkVGFibGUgdG8gdGhlIHN0YXRlbWVudFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY2xlYW4tcm9vbXMvbGF0ZXN0L3VzZXJndWlkZS9zZWN1cml0eS1pYW0uaHRtbFxuICAgKlxuICAgKiBAcGFyYW0gY29uZmlndXJlZFRhYmxlSWQgLSBJZGVudGlmaWVyIGZvciB0aGUgY29uZmlndXJlZFRhYmxlSWQuXG4gICAqIEBwYXJhbSBhY2NvdW50IC0gQWNjb3VudCBvZiB0aGUgcmVzb3VyY2U7IGRlZmF1bHRzIHRvIGVtcHR5IHN0cmluZzogYWxsIGFjY291bnRzLlxuICAgKiBAcGFyYW0gcmVnaW9uIC0gUmVnaW9uIG9mIHRoZSByZXNvdXJjZTsgZGVmYXVsdHMgdG8gZW1wdHkgc3RyaW5nOiBhbGwgcmVnaW9ucy5cbiAgICogQHBhcmFtIHBhcnRpdGlvbiAtIFBhcnRpdGlvbiBvZiB0aGUgQVdTIGFjY291bnQgW2F3cywgYXdzLWNuLCBhd3MtdXMtZ292XTsgZGVmYXVsdHMgdG8gYGF3c2AsIHVubGVzcyB1c2luZyB0aGUgQ0RLLCB3aGVyZSB0aGUgZGVmYXVsdCBpcyB0aGUgY3VycmVudCBTdGFjaydzIHBhcnRpdGlvbi5cbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NSZXNvdXJjZVRhZygpXG4gICAqL1xuICBwdWJsaWMgb25Db25maWd1cmVkVGFibGUoY29uZmlndXJlZFRhYmxlSWQ6IHN0cmluZywgYWNjb3VudD86IHN0cmluZywgcmVnaW9uPzogc3RyaW5nLCBwYXJ0aXRpb24/OiBzdHJpbmcpIHtcbiAgICByZXR1cm4gdGhpcy5vbihgYXJuOiR7IHBhcnRpdGlvbiB8fCBDbGVhbnJvb21zLmRlZmF1bHRQYXJ0aXRpb24gfTpjbGVhbnJvb21zOiR7IHJlZ2lvbiB8fCAnKicgfTokeyBhY2NvdW50IHx8ICcqJyB9OmNvbmZpZ3VyZWR0YWJsZS8keyBjb25maWd1cmVkVGFibGVJZCB9YCk7XG4gIH1cblxuICAvKipcbiAgICogQWRkcyBhIHJlc291cmNlIG9mIHR5cGUgQ29uZmlndXJlZFRhYmxlQXNzb2NpYXRpb24gdG8gdGhlIHN0YXRlbWVudFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY2xlYW4tcm9vbXMvbGF0ZXN0L3VzZXJndWlkZS9zZWN1cml0eS1pYW0uaHRtbFxuICAgKlxuICAgKiBAcGFyYW0gbWVtYmVyc2hpcElkIC0gSWRlbnRpZmllciBmb3IgdGhlIG1lbWJlcnNoaXBJZC5cbiAgICogQHBhcmFtIGNvbmZpZ3VyZWRUYWJsZUFzc29jaWF0aW9uSWQgLSBJZGVudGlmaWVyIGZvciB0aGUgY29uZmlndXJlZFRhYmxlQXNzb2NpYXRpb25JZC5cbiAgICogQHBhcmFtIGFjY291bnQgLSBBY2NvdW50IG9mIHRoZSByZXNvdXJjZTsgZGVmYXVsdHMgdG8gZW1wdHkgc3RyaW5nOiBhbGwgYWNjb3VudHMuXG4gICAqIEBwYXJhbSByZWdpb24gLSBSZWdpb24gb2YgdGhlIHJlc291cmNlOyBkZWZhdWx0cyB0byBlbXB0eSBzdHJpbmc6IGFsbCByZWdpb25zLlxuICAgKiBAcGFyYW0gcGFydGl0aW9uIC0gUGFydGl0aW9uIG9mIHRoZSBBV1MgYWNjb3VudCBbYXdzLCBhd3MtY24sIGF3cy11cy1nb3ZdOyBkZWZhdWx0cyB0byBgYXdzYCwgdW5sZXNzIHVzaW5nIHRoZSBDREssIHdoZXJlIHRoZSBkZWZhdWx0IGlzIHRoZSBjdXJyZW50IFN0YWNrJ3MgcGFydGl0aW9uLlxuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZkF3c1Jlc291cmNlVGFnKClcbiAgICovXG4gIHB1YmxpYyBvbkNvbmZpZ3VyZWRUYWJsZUFzc29jaWF0aW9uKG1lbWJlcnNoaXBJZDogc3RyaW5nLCBjb25maWd1cmVkVGFibGVBc3NvY2lhdGlvbklkOiBzdHJpbmcsIGFjY291bnQ/OiBzdHJpbmcsIHJlZ2lvbj86IHN0cmluZywgcGFydGl0aW9uPzogc3RyaW5nKSB7XG4gICAgcmV0dXJuIHRoaXMub24oYGFybjokeyBwYXJ0aXRpb24gfHwgQ2xlYW5yb29tcy5kZWZhdWx0UGFydGl0aW9uIH06Y2xlYW5yb29tczokeyByZWdpb24gfHwgJyonIH06JHsgYWNjb3VudCB8fCAnKicgfTptZW1iZXJzaGlwLyR7IG1lbWJlcnNoaXBJZCB9L2NvbmZpZ3VyZWR0YWJsZWFzc29jaWF0aW9uLyR7IGNvbmZpZ3VyZWRUYWJsZUFzc29jaWF0aW9uSWQgfWApO1xuICB9XG5cbiAgLyoqXG4gICAqIEFkZHMgYSByZXNvdXJjZSBvZiB0eXBlIE1lbWJlcnNoaXAgdG8gdGhlIHN0YXRlbWVudFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY2xlYW4tcm9vbXMvbGF0ZXN0L3VzZXJndWlkZS9zZWN1cml0eS1pYW0uaHRtbFxuICAgKlxuICAgKiBAcGFyYW0gbWVtYmVyc2hpcElkIC0gSWRlbnRpZmllciBmb3IgdGhlIG1lbWJlcnNoaXBJZC5cbiAgICogQHBhcmFtIGFjY291bnQgLSBBY2NvdW50IG9mIHRoZSByZXNvdXJjZTsgZGVmYXVsdHMgdG8gZW1wdHkgc3RyaW5nOiBhbGwgYWNjb3VudHMuXG4gICAqIEBwYXJhbSByZWdpb24gLSBSZWdpb24gb2YgdGhlIHJlc291cmNlOyBkZWZhdWx0cyB0byBlbXB0eSBzdHJpbmc6IGFsbCByZWdpb25zLlxuICAgKiBAcGFyYW0gcGFydGl0aW9uIC0gUGFydGl0aW9uIG9mIHRoZSBBV1MgYWNjb3VudCBbYXdzLCBhd3MtY24sIGF3cy11cy1nb3ZdOyBkZWZhdWx0cyB0byBgYXdzYCwgdW5sZXNzIHVzaW5nIHRoZSBDREssIHdoZXJlIHRoZSBkZWZhdWx0IGlzIHRoZSBjdXJyZW50IFN0YWNrJ3MgcGFydGl0aW9uLlxuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZkF3c1Jlc291cmNlVGFnKClcbiAgICovXG4gIHB1YmxpYyBvbk1lbWJlcnNoaXAobWVtYmVyc2hpcElkOiBzdHJpbmcsIGFjY291bnQ/OiBzdHJpbmcsIHJlZ2lvbj86IHN0cmluZywgcGFydGl0aW9uPzogc3RyaW5nKSB7XG4gICAgcmV0dXJuIHRoaXMub24oYGFybjokeyBwYXJ0aXRpb24gfHwgQ2xlYW5yb29tcy5kZWZhdWx0UGFydGl0aW9uIH06Y2xlYW5yb29tczokeyByZWdpb24gfHwgJyonIH06JHsgYWNjb3VudCB8fCAnKicgfTptZW1iZXJzaGlwLyR7IG1lbWJlcnNoaXBJZCB9YCk7XG4gIH1cbn1cbiJdfQ==