"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Controltower = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [controltower](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscontroltower.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Controltower extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [controltower](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscontroltower.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'controltower';
        this.accessLevelList = {
            Write: [
                'CreateManagedAccount',
                'DeleteLandingZone',
                'DeregisterManagedAccount',
                'DeregisterOrganizationalUnit',
                'DisableControl',
                'DisableGuardrail',
                'EnableControl',
                'EnableGuardrail',
                'ManageOrganizationalUnit',
                'SetupLandingZone',
                'UpdateAccountFactoryConfig'
            ],
            Read: [
                'DescribeAccountFactoryConfig',
                'DescribeCoreService',
                'DescribeGuardrail',
                'DescribeGuardrailForTarget',
                'DescribeLandingZoneConfiguration',
                'DescribeManagedAccount',
                'DescribeManagedOrganizationalUnit',
                'DescribeRegisterOrganizationalUnitOperation',
                'DescribeSingleSignOn',
                'GetAccountInfo',
                'GetAvailableUpdates',
                'GetControlOperation',
                'GetGuardrailComplianceStatus',
                'GetHomeRegion',
                'GetLandingZoneDriftStatus',
                'GetLandingZoneStatus',
                'ListDriftDetails',
                'ListExternalConfigRuleCompliance',
                'PerformPreLaunchChecks'
            ],
            List: [
                'ListDirectoryGroups',
                'ListEnabledControls',
                'ListEnabledGuardrails',
                'ListExtendGovernancePrecheckDetails',
                'ListGuardrailViolations',
                'ListGuardrails',
                'ListGuardrailsForTarget',
                'ListManagedAccounts',
                'ListManagedAccountsForGuardrail',
                'ListManagedAccountsForParent',
                'ListManagedOrganizationalUnits',
                'ListManagedOrganizationalUnitsForGuardrail'
            ]
        };
    }
    /**
     * Grants permission to create an account managed by AWS Control Tower
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     */
    toCreateManagedAccount() {
        return this.to('CreateManagedAccount');
    }
    /**
     * Grants permission to delete AWS Control Tower landing zone
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/decommission-landing-zone.html
     */
    toDeleteLandingZone() {
        return this.to('DeleteLandingZone');
    }
    /**
     * Grants permission to deregister an account created through the account factory from AWS Control Tower
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     */
    toDeregisterManagedAccount() {
        return this.to('DeregisterManagedAccount');
    }
    /**
     * Grants permission to deregister an organizational unit from AWS Control Tower management
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/organizations.html
     */
    toDeregisterOrganizationalUnit() {
        return this.to('DeregisterOrganizationalUnit');
    }
    /**
     * Grants permission to describe the current account factory configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     */
    toDescribeAccountFactoryConfig() {
        return this.to('DescribeAccountFactoryConfig');
    }
    /**
     * Grants permission to describe resources managed by core accounts in AWS Control Tower
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/how-control-tower-works.html#what-shared
     */
    toDescribeCoreService() {
        return this.to('DescribeCoreService');
    }
    /**
     * Grants permission to describe a guardrail
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/controls.html
     */
    toDescribeGuardrail() {
        return this.to('DescribeGuardrail');
    }
    /**
     * Grants permission to describe a guardrail for a organizational unit
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/controls.html
     */
    toDescribeGuardrailForTarget() {
        return this.to('DescribeGuardrailForTarget');
    }
    /**
     * Grants permission to describe the current Landing Zone configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/step-two.html
     */
    toDescribeLandingZoneConfiguration() {
        return this.to('DescribeLandingZoneConfiguration');
    }
    /**
     * Grants permission to describe an account created through account factory
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     */
    toDescribeManagedAccount() {
        return this.to('DescribeManagedAccount');
    }
    /**
     * Grants permission to describe an AWS Organizations organizational unit managed by AWS Control Tower
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/organizations.html
     */
    toDescribeManagedOrganizationalUnit() {
        return this.to('DescribeManagedOrganizationalUnit');
    }
    /**
     * Grants permission to describe a Register Organizational Unit Operation
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/about-extending-governance.html
     */
    toDescribeRegisterOrganizationalUnitOperation() {
        return this.to('DescribeRegisterOrganizationalUnitOperation');
    }
    /**
     * Grants permission to describe the current AWS Control Tower SSO configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/sso.html
     */
    toDescribeSingleSignOn() {
        return this.to('DescribeSingleSignOn');
    }
    /**
     * Grants permission to remove a control from an organizational unit
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/APIReference/API_DisableControl.html
     */
    toDisableControl() {
        return this.to('DisableControl');
    }
    /**
     * Grants permission to disable a guardrail from an organizational unit
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/enable-controls-on-ou.html
     */
    toDisableGuardrail() {
        return this.to('DisableGuardrail');
    }
    /**
     * Grants permission to activate a control for an organizational unit
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/APIReference/API_EnableControl.html
     */
    toEnableControl() {
        return this.to('EnableControl');
    }
    /**
     * Grants permission to enable a guardrail to an organizational unit
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/enable-controls-on-ou.html
     */
    toEnableGuardrail() {
        return this.to('EnableGuardrail');
    }
    /**
     * Grants permission to describe an account email and validate that it exists
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/accounts.html
     */
    toGetAccountInfo() {
        return this.to('GetAccountInfo');
    }
    /**
     * Grants permission to list available updates for the current AWS Control Tower deployment
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/configuration-updates.html
     */
    toGetAvailableUpdates() {
        return this.to('GetAvailableUpdates');
    }
    /**
     * Grants permission to get the current status of a particular EnabledControl or DisableControl operation
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/APIReference/API_GetControlOperation.html
     */
    toGetControlOperation() {
        return this.to('GetControlOperation');
    }
    /**
     * Grants permission to get the current compliance status of a guardrail
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/controls.html
     */
    toGetGuardrailComplianceStatus() {
        return this.to('GetGuardrailComplianceStatus');
    }
    /**
     * Grants permission to get the home region of the AWS Control Tower setup
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/how-control-tower-works.html#region-how
     */
    toGetHomeRegion() {
        return this.to('GetHomeRegion');
    }
    /**
     * Grants permission to get the current landing zone drift status
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/drift.html
     */
    toGetLandingZoneDriftStatus() {
        return this.to('GetLandingZoneDriftStatus');
    }
    /**
     * Grants permission to get the current status of the landing zone setup
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/getting-started-with-control-tower.html#step-two
     */
    toGetLandingZoneStatus() {
        return this.to('GetLandingZoneStatus');
    }
    /**
     * Grants permission to list the current directory groups available through SSO
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/sso.html
     */
    toListDirectoryGroups() {
        return this.to('ListDirectoryGroups');
    }
    /**
     * Grants permission to list occurrences of drift in AWS Control Tower
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/drift.html
     */
    toListDriftDetails() {
        return this.to('ListDriftDetails');
    }
    /**
     * Grants permission to list all enabled controls in a specified organizational unit
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/APIReference/API_ListEnabledControls.html
     */
    toListEnabledControls() {
        return this.to('ListEnabledControls');
    }
    /**
     * Grants permission to list currently enabled guardrails
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/controls.html
     */
    toListEnabledGuardrails() {
        return this.to('ListEnabledGuardrails');
    }
    /**
     * Grants permission to list Precheck details for an Organizational Unit
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/about-extending-governance.html
     */
    toListExtendGovernancePrecheckDetails() {
        return this.to('ListExtendGovernancePrecheckDetails');
    }
    /**
     * Grants permission to list the compliance of external AWS Config rules
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/review-compliance.html
     */
    toListExternalConfigRuleCompliance() {
        return this.to('ListExternalConfigRuleCompliance');
    }
    /**
     * Grants permission to list existing guardrail violations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/controls.html
     */
    toListGuardrailViolations() {
        return this.to('ListGuardrailViolations');
    }
    /**
     * Grants permission to list all available guardrails
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/controls.html
     */
    toListGuardrails() {
        return this.to('ListGuardrails');
    }
    /**
     * Grants permission to list guardrails and their current state for a organizational unit
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/controls.html
     */
    toListGuardrailsForTarget() {
        return this.to('ListGuardrailsForTarget');
    }
    /**
     * Grants permission to list accounts managed through AWS Control Tower
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     */
    toListManagedAccounts() {
        return this.to('ListManagedAccounts');
    }
    /**
     * Grants permission to list managed accounts with a specified guardrail applied
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     */
    toListManagedAccountsForGuardrail() {
        return this.to('ListManagedAccountsForGuardrail');
    }
    /**
     * Grants permission to list managed accounts under an organizational unit
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     */
    toListManagedAccountsForParent() {
        return this.to('ListManagedAccountsForParent');
    }
    /**
     * Grants permission to list organizational units managed by AWS Control Tower
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/organizations.html
     */
    toListManagedOrganizationalUnits() {
        return this.to('ListManagedOrganizationalUnits');
    }
    /**
     * Grants permission to list managed organizational units that have a specified guardrail applied
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/organizations.html
     */
    toListManagedOrganizationalUnitsForGuardrail() {
        return this.to('ListManagedOrganizationalUnitsForGuardrail');
    }
    /**
     * Grants permission to set up an organizational unit to be managed by AWS Control Tower
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/organizations.html
     */
    toManageOrganizationalUnit() {
        return this.to('ManageOrganizationalUnit');
    }
    /**
     * Grants permission to perform validations in an account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/getting-started-prereqs.html
     */
    toPerformPreLaunchChecks() {
        return this.to('PerformPreLaunchChecks');
    }
    /**
     * Grants permission to set up or update AWS Control Tower landing zone
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/getting-started-with-control-tower.html#step-two
     */
    toSetupLandingZone() {
        return this.to('SetupLandingZone');
    }
    /**
     * Grants permission to update the account factory configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     */
    toUpdateAccountFactoryConfig() {
        return this.to('UpdateAccountFactoryConfig');
    }
}
exports.Controltower = Controltower;
_a = JSII_RTTI_SYMBOL_1;
Controltower[_a] = { fqn: "iam-floyd.Controltower", version: "0.502.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29udHJvbHRvd2VyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiY29udHJvbHRvd2VyLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQ0Esc0NBQTRDO0FBRTVDOzs7O0dBSUc7QUFDSCxNQUFhLFlBQWEsU0FBUSx3QkFBZTtJQUcvQzs7OztPQUlHO0lBQ0gsWUFBWSxHQUFZO1FBQ3RCLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQztRQVJOLGtCQUFhLEdBQUcsY0FBYyxDQUFDO1FBeWQ1QixvQkFBZSxHQUFvQjtZQUMzQyxLQUFLLEVBQUU7Z0JBQ0wsc0JBQXNCO2dCQUN0QixtQkFBbUI7Z0JBQ25CLDBCQUEwQjtnQkFDMUIsOEJBQThCO2dCQUM5QixnQkFBZ0I7Z0JBQ2hCLGtCQUFrQjtnQkFDbEIsZUFBZTtnQkFDZixpQkFBaUI7Z0JBQ2pCLDBCQUEwQjtnQkFDMUIsa0JBQWtCO2dCQUNsQiw0QkFBNEI7YUFDN0I7WUFDRCxJQUFJLEVBQUU7Z0JBQ0osOEJBQThCO2dCQUM5QixxQkFBcUI7Z0JBQ3JCLG1CQUFtQjtnQkFDbkIsNEJBQTRCO2dCQUM1QixrQ0FBa0M7Z0JBQ2xDLHdCQUF3QjtnQkFDeEIsbUNBQW1DO2dCQUNuQyw2Q0FBNkM7Z0JBQzdDLHNCQUFzQjtnQkFDdEIsZ0JBQWdCO2dCQUNoQixxQkFBcUI7Z0JBQ3JCLHFCQUFxQjtnQkFDckIsOEJBQThCO2dCQUM5QixlQUFlO2dCQUNmLDJCQUEyQjtnQkFDM0Isc0JBQXNCO2dCQUN0QixrQkFBa0I7Z0JBQ2xCLGtDQUFrQztnQkFDbEMsd0JBQXdCO2FBQ3pCO1lBQ0QsSUFBSSxFQUFFO2dCQUNKLHFCQUFxQjtnQkFDckIscUJBQXFCO2dCQUNyQix1QkFBdUI7Z0JBQ3ZCLHFDQUFxQztnQkFDckMseUJBQXlCO2dCQUN6QixnQkFBZ0I7Z0JBQ2hCLHlCQUF5QjtnQkFDekIscUJBQXFCO2dCQUNyQixpQ0FBaUM7Z0JBQ2pDLDhCQUE4QjtnQkFDOUIsZ0NBQWdDO2dCQUNoQyw0Q0FBNEM7YUFDN0M7U0FDRixDQUFDO0lBamdCRixDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksc0JBQXNCO1FBQzNCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO0lBQ3pDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxtQkFBbUI7UUFDeEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLG1CQUFtQixDQUFDLENBQUM7SUFDdEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLDBCQUEwQjtRQUMvQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsMEJBQTBCLENBQUMsQ0FBQztJQUM3QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksOEJBQThCO1FBQ25DLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyw4QkFBOEIsQ0FBQyxDQUFDO0lBQ2pELENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSw4QkFBOEI7UUFDbkMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDhCQUE4QixDQUFDLENBQUM7SUFDakQsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHFCQUFxQjtRQUMxQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMscUJBQXFCLENBQUMsQ0FBQztJQUN4QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksbUJBQW1CO1FBQ3hCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDO0lBQ3RDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSw0QkFBNEI7UUFDakMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDRCQUE0QixDQUFDLENBQUM7SUFDL0MsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGtDQUFrQztRQUN2QyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsa0NBQWtDLENBQUMsQ0FBQztJQUNyRCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksd0JBQXdCO1FBQzdCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyx3QkFBd0IsQ0FBQyxDQUFDO0lBQzNDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxtQ0FBbUM7UUFDeEMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLG1DQUFtQyxDQUFDLENBQUM7SUFDdEQsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLDZDQUE2QztRQUNsRCxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsNkNBQTZDLENBQUMsQ0FBQztJQUNoRSxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksc0JBQXNCO1FBQzNCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO0lBQ3pDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxnQkFBZ0I7UUFDckIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGdCQUFnQixDQUFDLENBQUM7SUFDbkMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGtCQUFrQjtRQUN2QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsa0JBQWtCLENBQUMsQ0FBQztJQUNyQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksZUFBZTtRQUNwQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsZUFBZSxDQUFDLENBQUM7SUFDbEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGlCQUFpQjtRQUN0QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsaUJBQWlCLENBQUMsQ0FBQztJQUNwQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksZ0JBQWdCO1FBQ3JCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDO0lBQ25DLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxxQkFBcUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHFCQUFxQixDQUFDLENBQUM7SUFDeEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHFCQUFxQjtRQUMxQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMscUJBQXFCLENBQUMsQ0FBQztJQUN4QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksOEJBQThCO1FBQ25DLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyw4QkFBOEIsQ0FBQyxDQUFDO0lBQ2pELENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxlQUFlO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxlQUFlLENBQUMsQ0FBQztJQUNsQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksMkJBQTJCO1FBQ2hDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQywyQkFBMkIsQ0FBQyxDQUFDO0lBQzlDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxzQkFBc0I7UUFDM0IsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHNCQUFzQixDQUFDLENBQUM7SUFDekMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHFCQUFxQjtRQUMxQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMscUJBQXFCLENBQUMsQ0FBQztJQUN4QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksa0JBQWtCO1FBQ3ZCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO0lBQ3JDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxxQkFBcUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHFCQUFxQixDQUFDLENBQUM7SUFDeEMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHVCQUF1QjtRQUM1QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsdUJBQXVCLENBQUMsQ0FBQztJQUMxQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0kscUNBQXFDO1FBQzFDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxxQ0FBcUMsQ0FBQyxDQUFDO0lBQ3hELENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxrQ0FBa0M7UUFDdkMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGtDQUFrQyxDQUFDLENBQUM7SUFDckQsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHlCQUF5QjtRQUM5QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMseUJBQXlCLENBQUMsQ0FBQztJQUM1QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksZ0JBQWdCO1FBQ3JCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDO0lBQ25DLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSx5QkFBeUI7UUFDOUIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHlCQUF5QixDQUFDLENBQUM7SUFDNUMsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHFCQUFxQjtRQUMxQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMscUJBQXFCLENBQUMsQ0FBQztJQUN4QyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksaUNBQWlDO1FBQ3RDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxpQ0FBaUMsQ0FBQyxDQUFDO0lBQ3BELENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSw4QkFBOEI7UUFDbkMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDhCQUE4QixDQUFDLENBQUM7SUFDakQsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGdDQUFnQztRQUNyQyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsZ0NBQWdDLENBQUMsQ0FBQztJQUNuRCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksNENBQTRDO1FBQ2pELE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyw0Q0FBNEMsQ0FBQyxDQUFDO0lBQy9ELENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSwwQkFBMEI7UUFDL0IsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDBCQUEwQixDQUFDLENBQUM7SUFDN0MsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHdCQUF3QjtRQUM3QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsd0JBQXdCLENBQUMsQ0FBQztJQUMzQyxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksa0JBQWtCO1FBQ3ZCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO0lBQ3JDLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSw0QkFBNEI7UUFDakMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDRCQUE0QixDQUFDLENBQUM7SUFDL0MsQ0FBQzs7QUF4ZEgsb0NBNGdCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEFjY2Vzc0xldmVsTGlzdCB9IGZyb20gJy4uL3NoYXJlZC9hY2Nlc3MtbGV2ZWwnO1xuaW1wb3J0IHsgUG9saWN5U3RhdGVtZW50IH0gZnJvbSAnLi4vc2hhcmVkJztcblxuLyoqXG4gKiBTdGF0ZW1lbnQgcHJvdmlkZXIgZm9yIHNlcnZpY2UgW2NvbnRyb2x0b3dlcl0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3NlcnZpY2UtYXV0aG9yaXphdGlvbi9sYXRlc3QvcmVmZXJlbmNlL2xpc3RfYXdzY29udHJvbHRvd2VyLmh0bWwpLlxuICpcbiAqIEBwYXJhbSBzaWQgW1NJRF0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0lBTS9sYXRlc3QvVXNlckd1aWRlL3JlZmVyZW5jZV9wb2xpY2llc19lbGVtZW50c19zaWQuaHRtbCkgb2YgdGhlIHN0YXRlbWVudFxuICovXG5leHBvcnQgY2xhc3MgQ29udHJvbHRvd2VyIGV4dGVuZHMgUG9saWN5U3RhdGVtZW50IHtcbiAgcHVibGljIHNlcnZpY2VQcmVmaXggPSAnY29udHJvbHRvd2VyJztcblxuICAvKipcbiAgICogU3RhdGVtZW50IHByb3ZpZGVyIGZvciBzZXJ2aWNlIFtjb250cm9sdG93ZXJdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9zZXJ2aWNlLWF1dGhvcml6YXRpb24vbGF0ZXN0L3JlZmVyZW5jZS9saXN0X2F3c2NvbnRyb2x0b3dlci5odG1sKS5cbiAgICpcbiAgICogQHBhcmFtIHNpZCBbU0lEXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vSUFNL2xhdGVzdC9Vc2VyR3VpZGUvcmVmZXJlbmNlX3BvbGljaWVzX2VsZW1lbnRzX3NpZC5odG1sKSBvZiB0aGUgc3RhdGVtZW50XG4gICAqL1xuICBjb25zdHJ1Y3RvcihzaWQ/OiBzdHJpbmcpIHtcbiAgICBzdXBlcihzaWQpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGNyZWF0ZSBhbiBhY2NvdW50IG1hbmFnZWQgYnkgQVdTIENvbnRyb2wgVG93ZXJcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY29udHJvbHRvd2VyL2xhdGVzdC91c2VyZ3VpZGUvYWNjb3VudC1mYWN0b3J5Lmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0NyZWF0ZU1hbmFnZWRBY2NvdW50KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdDcmVhdGVNYW5hZ2VkQWNjb3VudCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGRlbGV0ZSBBV1MgQ29udHJvbCBUb3dlciBsYW5kaW5nIHpvbmVcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY29udHJvbHRvd2VyL2xhdGVzdC91c2VyZ3VpZGUvZGVjb21taXNzaW9uLWxhbmRpbmctem9uZS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZWxldGVMYW5kaW5nWm9uZSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVsZXRlTGFuZGluZ1pvbmUnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBkZXJlZ2lzdGVyIGFuIGFjY291bnQgY3JlYXRlZCB0aHJvdWdoIHRoZSBhY2NvdW50IGZhY3RvcnkgZnJvbSBBV1MgQ29udHJvbCBUb3dlclxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jb250cm9sdG93ZXIvbGF0ZXN0L3VzZXJndWlkZS9hY2NvdW50LWZhY3RvcnkuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVyZWdpc3Rlck1hbmFnZWRBY2NvdW50KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZXJlZ2lzdGVyTWFuYWdlZEFjY291bnQnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBkZXJlZ2lzdGVyIGFuIG9yZ2FuaXphdGlvbmFsIHVuaXQgZnJvbSBBV1MgQ29udHJvbCBUb3dlciBtYW5hZ2VtZW50XG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2NvbnRyb2x0b3dlci9sYXRlc3QvdXNlcmd1aWRlL29yZ2FuaXphdGlvbnMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVyZWdpc3Rlck9yZ2FuaXphdGlvbmFsVW5pdCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVyZWdpc3Rlck9yZ2FuaXphdGlvbmFsVW5pdCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGRlc2NyaWJlIHRoZSBjdXJyZW50IGFjY291bnQgZmFjdG9yeSBjb25maWd1cmF0aW9uXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY29udHJvbHRvd2VyL2xhdGVzdC91c2VyZ3VpZGUvYWNjb3VudC1mYWN0b3J5Lmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0Rlc2NyaWJlQWNjb3VudEZhY3RvcnlDb25maWcoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0Rlc2NyaWJlQWNjb3VudEZhY3RvcnlDb25maWcnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBkZXNjcmliZSByZXNvdXJjZXMgbWFuYWdlZCBieSBjb3JlIGFjY291bnRzIGluIEFXUyBDb250cm9sIFRvd2VyXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY29udHJvbHRvd2VyL2xhdGVzdC91c2VyZ3VpZGUvaG93LWNvbnRyb2wtdG93ZXItd29ya3MuaHRtbCN3aGF0LXNoYXJlZFxuICAgKi9cbiAgcHVibGljIHRvRGVzY3JpYmVDb3JlU2VydmljZSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVzY3JpYmVDb3JlU2VydmljZScpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGRlc2NyaWJlIGEgZ3VhcmRyYWlsXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY29udHJvbHRvd2VyL2xhdGVzdC91c2VyZ3VpZGUvY29udHJvbHMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVzY3JpYmVHdWFyZHJhaWwoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0Rlc2NyaWJlR3VhcmRyYWlsJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZGVzY3JpYmUgYSBndWFyZHJhaWwgZm9yIGEgb3JnYW5pemF0aW9uYWwgdW5pdFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2NvbnRyb2x0b3dlci9sYXRlc3QvdXNlcmd1aWRlL2NvbnRyb2xzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0Rlc2NyaWJlR3VhcmRyYWlsRm9yVGFyZ2V0KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZXNjcmliZUd1YXJkcmFpbEZvclRhcmdldCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGRlc2NyaWJlIHRoZSBjdXJyZW50IExhbmRpbmcgWm9uZSBjb25maWd1cmF0aW9uXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY29udHJvbHRvd2VyL2xhdGVzdC91c2VyZ3VpZGUvc3RlcC10d28uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVzY3JpYmVMYW5kaW5nWm9uZUNvbmZpZ3VyYXRpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0Rlc2NyaWJlTGFuZGluZ1pvbmVDb25maWd1cmF0aW9uJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZGVzY3JpYmUgYW4gYWNjb3VudCBjcmVhdGVkIHRocm91Z2ggYWNjb3VudCBmYWN0b3J5XG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY29udHJvbHRvd2VyL2xhdGVzdC91c2VyZ3VpZGUvYWNjb3VudC1mYWN0b3J5Lmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0Rlc2NyaWJlTWFuYWdlZEFjY291bnQoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0Rlc2NyaWJlTWFuYWdlZEFjY291bnQnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBkZXNjcmliZSBhbiBBV1MgT3JnYW5pemF0aW9ucyBvcmdhbml6YXRpb25hbCB1bml0IG1hbmFnZWQgYnkgQVdTIENvbnRyb2wgVG93ZXJcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jb250cm9sdG93ZXIvbGF0ZXN0L3VzZXJndWlkZS9vcmdhbml6YXRpb25zLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0Rlc2NyaWJlTWFuYWdlZE9yZ2FuaXphdGlvbmFsVW5pdCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVzY3JpYmVNYW5hZ2VkT3JnYW5pemF0aW9uYWxVbml0Jyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZGVzY3JpYmUgYSBSZWdpc3RlciBPcmdhbml6YXRpb25hbCBVbml0IE9wZXJhdGlvblxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2NvbnRyb2x0b3dlci9sYXRlc3QvdXNlcmd1aWRlL2Fib3V0LWV4dGVuZGluZy1nb3Zlcm5hbmNlLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0Rlc2NyaWJlUmVnaXN0ZXJPcmdhbml6YXRpb25hbFVuaXRPcGVyYXRpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0Rlc2NyaWJlUmVnaXN0ZXJPcmdhbml6YXRpb25hbFVuaXRPcGVyYXRpb24nKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBkZXNjcmliZSB0aGUgY3VycmVudCBBV1MgQ29udHJvbCBUb3dlciBTU08gY29uZmlndXJhdGlvblxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2NvbnRyb2x0b3dlci9sYXRlc3QvdXNlcmd1aWRlL3Nzby5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZXNjcmliZVNpbmdsZVNpZ25PbigpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGVzY3JpYmVTaW5nbGVTaWduT24nKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byByZW1vdmUgYSBjb250cm9sIGZyb20gYW4gb3JnYW5pemF0aW9uYWwgdW5pdFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jb250cm9sdG93ZXIvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfRGlzYWJsZUNvbnRyb2wuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGlzYWJsZUNvbnRyb2woKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0Rpc2FibGVDb250cm9sJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZGlzYWJsZSBhIGd1YXJkcmFpbCBmcm9tIGFuIG9yZ2FuaXphdGlvbmFsIHVuaXRcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY29udHJvbHRvd2VyL2xhdGVzdC91c2VyZ3VpZGUvZW5hYmxlLWNvbnRyb2xzLW9uLW91Lmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0Rpc2FibGVHdWFyZHJhaWwoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0Rpc2FibGVHdWFyZHJhaWwnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBhY3RpdmF0ZSBhIGNvbnRyb2wgZm9yIGFuIG9yZ2FuaXphdGlvbmFsIHVuaXRcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY29udHJvbHRvd2VyL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0VuYWJsZUNvbnRyb2wuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRW5hYmxlQ29udHJvbCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRW5hYmxlQ29udHJvbCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGVuYWJsZSBhIGd1YXJkcmFpbCB0byBhbiBvcmdhbml6YXRpb25hbCB1bml0XG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2NvbnRyb2x0b3dlci9sYXRlc3QvdXNlcmd1aWRlL2VuYWJsZS1jb250cm9scy1vbi1vdS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9FbmFibGVHdWFyZHJhaWwoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0VuYWJsZUd1YXJkcmFpbCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGRlc2NyaWJlIGFuIGFjY291bnQgZW1haWwgYW5kIHZhbGlkYXRlIHRoYXQgaXQgZXhpc3RzXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY29udHJvbHRvd2VyL2xhdGVzdC91c2VyZ3VpZGUvYWNjb3VudHMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvR2V0QWNjb3VudEluZm8oKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldEFjY291bnRJbmZvJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gbGlzdCBhdmFpbGFibGUgdXBkYXRlcyBmb3IgdGhlIGN1cnJlbnQgQVdTIENvbnRyb2wgVG93ZXIgZGVwbG95bWVudFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2NvbnRyb2x0b3dlci9sYXRlc3QvdXNlcmd1aWRlL2NvbmZpZ3VyYXRpb24tdXBkYXRlcy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9HZXRBdmFpbGFibGVVcGRhdGVzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdHZXRBdmFpbGFibGVVcGRhdGVzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gZ2V0IHRoZSBjdXJyZW50IHN0YXR1cyBvZiBhIHBhcnRpY3VsYXIgRW5hYmxlZENvbnRyb2wgb3IgRGlzYWJsZUNvbnRyb2wgb3BlcmF0aW9uXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY29udHJvbHRvd2VyL2xhdGVzdC9BUElSZWZlcmVuY2UvQVBJX0dldENvbnRyb2xPcGVyYXRpb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvR2V0Q29udHJvbE9wZXJhdGlvbigpIHtcbiAgICByZXR1cm4gdGhpcy50bygnR2V0Q29udHJvbE9wZXJhdGlvbicpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGdldCB0aGUgY3VycmVudCBjb21wbGlhbmNlIHN0YXR1cyBvZiBhIGd1YXJkcmFpbFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2NvbnRyb2x0b3dlci9sYXRlc3QvdXNlcmd1aWRlL2NvbnRyb2xzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0dldEd1YXJkcmFpbENvbXBsaWFuY2VTdGF0dXMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldEd1YXJkcmFpbENvbXBsaWFuY2VTdGF0dXMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBnZXQgdGhlIGhvbWUgcmVnaW9uIG9mIHRoZSBBV1MgQ29udHJvbCBUb3dlciBzZXR1cFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2NvbnRyb2x0b3dlci9sYXRlc3QvdXNlcmd1aWRlL2hvdy1jb250cm9sLXRvd2VyLXdvcmtzLmh0bWwjcmVnaW9uLWhvd1xuICAgKi9cbiAgcHVibGljIHRvR2V0SG9tZVJlZ2lvbigpIHtcbiAgICByZXR1cm4gdGhpcy50bygnR2V0SG9tZVJlZ2lvbicpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGdldCB0aGUgY3VycmVudCBsYW5kaW5nIHpvbmUgZHJpZnQgc3RhdHVzXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY29udHJvbHRvd2VyL2xhdGVzdC91c2VyZ3VpZGUvZHJpZnQuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvR2V0TGFuZGluZ1pvbmVEcmlmdFN0YXR1cygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnR2V0TGFuZGluZ1pvbmVEcmlmdFN0YXR1cycpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGdldCB0aGUgY3VycmVudCBzdGF0dXMgb2YgdGhlIGxhbmRpbmcgem9uZSBzZXR1cFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2NvbnRyb2x0b3dlci9sYXRlc3QvdXNlcmd1aWRlL2dldHRpbmctc3RhcnRlZC13aXRoLWNvbnRyb2wtdG93ZXIuaHRtbCNzdGVwLXR3b1xuICAgKi9cbiAgcHVibGljIHRvR2V0TGFuZGluZ1pvbmVTdGF0dXMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldExhbmRpbmdab25lU3RhdHVzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gbGlzdCB0aGUgY3VycmVudCBkaXJlY3RvcnkgZ3JvdXBzIGF2YWlsYWJsZSB0aHJvdWdoIFNTT1xuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IExpc3RcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2NvbnRyb2x0b3dlci9sYXRlc3QvdXNlcmd1aWRlL3Nzby5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0RGlyZWN0b3J5R3JvdXBzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0RGlyZWN0b3J5R3JvdXBzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gbGlzdCBvY2N1cnJlbmNlcyBvZiBkcmlmdCBpbiBBV1MgQ29udHJvbCBUb3dlclxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2NvbnRyb2x0b3dlci9sYXRlc3QvdXNlcmd1aWRlL2RyaWZ0Lmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3REcmlmdERldGFpbHMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0xpc3REcmlmdERldGFpbHMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBsaXN0IGFsbCBlbmFibGVkIGNvbnRyb2xzIGluIGEgc3BlY2lmaWVkIG9yZ2FuaXphdGlvbmFsIHVuaXRcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jb250cm9sdG93ZXIvbGF0ZXN0L0FQSVJlZmVyZW5jZS9BUElfTGlzdEVuYWJsZWRDb250cm9scy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0RW5hYmxlZENvbnRyb2xzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0RW5hYmxlZENvbnRyb2xzJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gbGlzdCBjdXJyZW50bHkgZW5hYmxlZCBndWFyZHJhaWxzXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY29udHJvbHRvd2VyL2xhdGVzdC91c2VyZ3VpZGUvY29udHJvbHMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTGlzdEVuYWJsZWRHdWFyZHJhaWxzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0RW5hYmxlZEd1YXJkcmFpbHMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBsaXN0IFByZWNoZWNrIGRldGFpbHMgZm9yIGFuIE9yZ2FuaXphdGlvbmFsIFVuaXRcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jb250cm9sdG93ZXIvbGF0ZXN0L3VzZXJndWlkZS9hYm91dC1leHRlbmRpbmctZ292ZXJuYW5jZS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0RXh0ZW5kR292ZXJuYW5jZVByZWNoZWNrRGV0YWlscygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTGlzdEV4dGVuZEdvdmVybmFuY2VQcmVjaGVja0RldGFpbHMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBsaXN0IHRoZSBjb21wbGlhbmNlIG9mIGV4dGVybmFsIEFXUyBDb25maWcgcnVsZXNcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jb250cm9sdG93ZXIvbGF0ZXN0L3VzZXJndWlkZS9yZXZpZXctY29tcGxpYW5jZS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0RXh0ZXJuYWxDb25maWdSdWxlQ29tcGxpYW5jZSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTGlzdEV4dGVybmFsQ29uZmlnUnVsZUNvbXBsaWFuY2UnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBsaXN0IGV4aXN0aW5nIGd1YXJkcmFpbCB2aW9sYXRpb25zXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY29udHJvbHRvd2VyL2xhdGVzdC91c2VyZ3VpZGUvY29udHJvbHMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTGlzdEd1YXJkcmFpbFZpb2xhdGlvbnMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0xpc3RHdWFyZHJhaWxWaW9sYXRpb25zJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gbGlzdCBhbGwgYXZhaWxhYmxlIGd1YXJkcmFpbHNcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jb250cm9sdG93ZXIvbGF0ZXN0L3VzZXJndWlkZS9jb250cm9scy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0R3VhcmRyYWlscygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTGlzdEd1YXJkcmFpbHMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBsaXN0IGd1YXJkcmFpbHMgYW5kIHRoZWlyIGN1cnJlbnQgc3RhdGUgZm9yIGEgb3JnYW5pemF0aW9uYWwgdW5pdFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IExpc3RcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2NvbnRyb2x0b3dlci9sYXRlc3QvdXNlcmd1aWRlL2NvbnRyb2xzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RHdWFyZHJhaWxzRm9yVGFyZ2V0KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0R3VhcmRyYWlsc0ZvclRhcmdldCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGxpc3QgYWNjb3VudHMgbWFuYWdlZCB0aHJvdWdoIEFXUyBDb250cm9sIFRvd2VyXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY29udHJvbHRvd2VyL2xhdGVzdC91c2VyZ3VpZGUvYWNjb3VudC1mYWN0b3J5Lmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RNYW5hZ2VkQWNjb3VudHMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0xpc3RNYW5hZ2VkQWNjb3VudHMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBsaXN0IG1hbmFnZWQgYWNjb3VudHMgd2l0aCBhIHNwZWNpZmllZCBndWFyZHJhaWwgYXBwbGllZFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IExpc3RcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2NvbnRyb2x0b3dlci9sYXRlc3QvdXNlcmd1aWRlL2FjY291bnQtZmFjdG9yeS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0TWFuYWdlZEFjY291bnRzRm9yR3VhcmRyYWlsKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0TWFuYWdlZEFjY291bnRzRm9yR3VhcmRyYWlsJyk7XG4gIH1cblxuICAvKipcbiAgICogR3JhbnRzIHBlcm1pc3Npb24gdG8gbGlzdCBtYW5hZ2VkIGFjY291bnRzIHVuZGVyIGFuIG9yZ2FuaXphdGlvbmFsIHVuaXRcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jb250cm9sdG93ZXIvbGF0ZXN0L3VzZXJndWlkZS9hY2NvdW50LWZhY3RvcnkuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTGlzdE1hbmFnZWRBY2NvdW50c0ZvclBhcmVudCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTGlzdE1hbmFnZWRBY2NvdW50c0ZvclBhcmVudCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIGxpc3Qgb3JnYW5pemF0aW9uYWwgdW5pdHMgbWFuYWdlZCBieSBBV1MgQ29udHJvbCBUb3dlclxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IExpc3RcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2NvbnRyb2x0b3dlci9sYXRlc3QvdXNlcmd1aWRlL29yZ2FuaXphdGlvbnMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTGlzdE1hbmFnZWRPcmdhbml6YXRpb25hbFVuaXRzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0TWFuYWdlZE9yZ2FuaXphdGlvbmFsVW5pdHMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBsaXN0IG1hbmFnZWQgb3JnYW5pemF0aW9uYWwgdW5pdHMgdGhhdCBoYXZlIGEgc3BlY2lmaWVkIGd1YXJkcmFpbCBhcHBsaWVkXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY29udHJvbHRvd2VyL2xhdGVzdC91c2VyZ3VpZGUvb3JnYW5pemF0aW9ucy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0TWFuYWdlZE9yZ2FuaXphdGlvbmFsVW5pdHNGb3JHdWFyZHJhaWwoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0xpc3RNYW5hZ2VkT3JnYW5pemF0aW9uYWxVbml0c0Zvckd1YXJkcmFpbCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHNldCB1cCBhbiBvcmdhbml6YXRpb25hbCB1bml0IHRvIGJlIG1hbmFnZWQgYnkgQVdTIENvbnRyb2wgVG93ZXJcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY29udHJvbHRvd2VyL2xhdGVzdC91c2VyZ3VpZGUvb3JnYW5pemF0aW9ucy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9NYW5hZ2VPcmdhbml6YXRpb25hbFVuaXQoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ01hbmFnZU9yZ2FuaXphdGlvbmFsVW5pdCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIEdyYW50cyBwZXJtaXNzaW9uIHRvIHBlcmZvcm0gdmFsaWRhdGlvbnMgaW4gYW4gYWNjb3VudFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2NvbnRyb2x0b3dlci9sYXRlc3QvdXNlcmd1aWRlL2dldHRpbmctc3RhcnRlZC1wcmVyZXFzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1BlcmZvcm1QcmVMYXVuY2hDaGVja3MoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1BlcmZvcm1QcmVMYXVuY2hDaGVja3MnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byBzZXQgdXAgb3IgdXBkYXRlIEFXUyBDb250cm9sIFRvd2VyIGxhbmRpbmcgem9uZVxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jb250cm9sdG93ZXIvbGF0ZXN0L3VzZXJndWlkZS9nZXR0aW5nLXN0YXJ0ZWQtd2l0aC1jb250cm9sLXRvd2VyLmh0bWwjc3RlcC10d29cbiAgICovXG4gIHB1YmxpYyB0b1NldHVwTGFuZGluZ1pvbmUoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1NldHVwTGFuZGluZ1pvbmUnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBHcmFudHMgcGVybWlzc2lvbiB0byB1cGRhdGUgdGhlIGFjY291bnQgZmFjdG9yeSBjb25maWd1cmF0aW9uXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2NvbnRyb2x0b3dlci9sYXRlc3QvdXNlcmd1aWRlL2FjY291bnQtZmFjdG9yeS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9VcGRhdGVBY2NvdW50RmFjdG9yeUNvbmZpZygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnVXBkYXRlQWNjb3VudEZhY3RvcnlDb25maWcnKTtcbiAgfVxuXG4gIHByb3RlY3RlZCBhY2Nlc3NMZXZlbExpc3Q6IEFjY2Vzc0xldmVsTGlzdCA9IHtcbiAgICBXcml0ZTogW1xuICAgICAgJ0NyZWF0ZU1hbmFnZWRBY2NvdW50JyxcbiAgICAgICdEZWxldGVMYW5kaW5nWm9uZScsXG4gICAgICAnRGVyZWdpc3Rlck1hbmFnZWRBY2NvdW50JyxcbiAgICAgICdEZXJlZ2lzdGVyT3JnYW5pemF0aW9uYWxVbml0JyxcbiAgICAgICdEaXNhYmxlQ29udHJvbCcsXG4gICAgICAnRGlzYWJsZUd1YXJkcmFpbCcsXG4gICAgICAnRW5hYmxlQ29udHJvbCcsXG4gICAgICAnRW5hYmxlR3VhcmRyYWlsJyxcbiAgICAgICdNYW5hZ2VPcmdhbml6YXRpb25hbFVuaXQnLFxuICAgICAgJ1NldHVwTGFuZGluZ1pvbmUnLFxuICAgICAgJ1VwZGF0ZUFjY291bnRGYWN0b3J5Q29uZmlnJ1xuICAgIF0sXG4gICAgUmVhZDogW1xuICAgICAgJ0Rlc2NyaWJlQWNjb3VudEZhY3RvcnlDb25maWcnLFxuICAgICAgJ0Rlc2NyaWJlQ29yZVNlcnZpY2UnLFxuICAgICAgJ0Rlc2NyaWJlR3VhcmRyYWlsJyxcbiAgICAgICdEZXNjcmliZUd1YXJkcmFpbEZvclRhcmdldCcsXG4gICAgICAnRGVzY3JpYmVMYW5kaW5nWm9uZUNvbmZpZ3VyYXRpb24nLFxuICAgICAgJ0Rlc2NyaWJlTWFuYWdlZEFjY291bnQnLFxuICAgICAgJ0Rlc2NyaWJlTWFuYWdlZE9yZ2FuaXphdGlvbmFsVW5pdCcsXG4gICAgICAnRGVzY3JpYmVSZWdpc3Rlck9yZ2FuaXphdGlvbmFsVW5pdE9wZXJhdGlvbicsXG4gICAgICAnRGVzY3JpYmVTaW5nbGVTaWduT24nLFxuICAgICAgJ0dldEFjY291bnRJbmZvJyxcbiAgICAgICdHZXRBdmFpbGFibGVVcGRhdGVzJyxcbiAgICAgICdHZXRDb250cm9sT3BlcmF0aW9uJyxcbiAgICAgICdHZXRHdWFyZHJhaWxDb21wbGlhbmNlU3RhdHVzJyxcbiAgICAgICdHZXRIb21lUmVnaW9uJyxcbiAgICAgICdHZXRMYW5kaW5nWm9uZURyaWZ0U3RhdHVzJyxcbiAgICAgICdHZXRMYW5kaW5nWm9uZVN0YXR1cycsXG4gICAgICAnTGlzdERyaWZ0RGV0YWlscycsXG4gICAgICAnTGlzdEV4dGVybmFsQ29uZmlnUnVsZUNvbXBsaWFuY2UnLFxuICAgICAgJ1BlcmZvcm1QcmVMYXVuY2hDaGVja3MnXG4gICAgXSxcbiAgICBMaXN0OiBbXG4gICAgICAnTGlzdERpcmVjdG9yeUdyb3VwcycsXG4gICAgICAnTGlzdEVuYWJsZWRDb250cm9scycsXG4gICAgICAnTGlzdEVuYWJsZWRHdWFyZHJhaWxzJyxcbiAgICAgICdMaXN0RXh0ZW5kR292ZXJuYW5jZVByZWNoZWNrRGV0YWlscycsXG4gICAgICAnTGlzdEd1YXJkcmFpbFZpb2xhdGlvbnMnLFxuICAgICAgJ0xpc3RHdWFyZHJhaWxzJyxcbiAgICAgICdMaXN0R3VhcmRyYWlsc0ZvclRhcmdldCcsXG4gICAgICAnTGlzdE1hbmFnZWRBY2NvdW50cycsXG4gICAgICAnTGlzdE1hbmFnZWRBY2NvdW50c0Zvckd1YXJkcmFpbCcsXG4gICAgICAnTGlzdE1hbmFnZWRBY2NvdW50c0ZvclBhcmVudCcsXG4gICAgICAnTGlzdE1hbmFnZWRPcmdhbml6YXRpb25hbFVuaXRzJyxcbiAgICAgICdMaXN0TWFuYWdlZE9yZ2FuaXphdGlvbmFsVW5pdHNGb3JHdWFyZHJhaWwnXG4gICAgXVxuICB9O1xufVxuIl19