import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [datazonecontrol](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazondatazonecontrol.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Datazonecontrol extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [datazonecontrol](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazondatazonecontrol.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to request association of an account with a given domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toCreateAccountAssociationInvitation(): this;
    /**
     * Grants permission to create Amazon DataZone data sources used for publishing and subscribing to data
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toCreateDataSource(): this;
    /**
     * Grants permission to provision a root-domain which is a top level entity that contains other Amazon DataZone resources
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toCreateEnvironment(): this;
    /**
     * Grants permission to delete a data source
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toDeleteDataSource(): this;
    /**
     * Grants permission to delete a provisioned root-domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toDeleteEnvironment(): this;
    /**
     * Grants permission to disassociate an account with a given domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toDissociateAccount(): this;
    /**
     * Grants permission to retrieve information about any associated domain in the associated account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toGetAssociatedDomain(): this;
    /**
     * Grants permission to retrieve any data source under any domain for a given root-domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toGetDataSourceByEnvironment(): this;
    /**
     * Grants permission to retrieve information about any domain in the account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toGetDomain(): this;
    /**
     * Grants permission to retrieve information about a root-domain
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toGetEnvironment(): this;
    /**
     * Grants permission to retrieve a publishing job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toGetMetadataCollector(): this;
    /**
     * Grants permission to retrieve credentials to log into Amazon DataZone data portal from AWS management console
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toGetUserPortalLoginAuthCode(): this;
    /**
     * Grants permission to retrieve all account-association invitations for a given associated account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toListAccountAssociationInvitations(): this;
    /**
     * Grants permission to list all associated accounts under the given root-domain, including accounts associated to its sub-domains
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toListAllAssociatedAccountsForEnvironment(): this;
    /**
     * Grants permission to lists all the associated domains for a given associated account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toListAssociatedEnvironments(): this;
    /**
     * Grants permission to retrieve all data sources under any domain in the associated account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toListDataSources(): this;
    /**
     * Grants permission to retrieve all data sources under any domain for a given root-domain
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toListDataSourcesByEnvironment(): this;
    /**
     * Grants permission to list all the sub-domains for a given domain or a root-domain
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toListDomains(): this;
    /**
     * Grants permission to retrieve all root-domains
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toListEnvironment(): this;
    /**
     * Grants permission to list all runs for a given publishing job through Amazon DataZone console for a data source
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toListMetadataCollectorRuns(): this;
    /**
     * Grants permission to retrieve all publishing jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toListMetadataCollectors(): this;
    /**
     * Grants permission to retrieve all Amazon DataZone projects
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toListProjects(): this;
    /**
     * Grants permission to retrieve all tags associated with a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to accept or reject the pending association requests for the given account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toReviewAccountAssociationInvitation(): this;
    /**
     * Grants permission to add or update tags to a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toTagResource(): this;
    /**
     * Grants permission to remove tags associated with a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toUntagResource(): this;
    /**
     * Grants permission to update the description of the account association of the given associated account and given domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toUpdateAccountAssociationDescription(): this;
    /**
     * Grants permission to update a data source
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toUpdateDataSource(): this;
    /**
     * Grants permission to update information for a root-domain
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/what-is-datazone.html#accessing-datazone
     */
    toUpdateEnvironment(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type environment to the statement
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/create-root-domain.html
     *
     * @param domainId - Identifier for the domainId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onEnvironment(domainId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type data-source to the statement
     *
     * https://docs.aws.amazon.com/datazone/latest/userguide/create-glue-data-source.html
     *
     * @param domainId - Identifier for the domainId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDataSource(domainId: string, account?: string, region?: string, partition?: string): this;
}
