import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [iotdeviceadvisor](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotcoredeviceadvisor.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Iotdeviceadvisor extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [iotdeviceadvisor](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotcoredeviceadvisor.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to create a suite definition
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_iotdeviceadvisor_CreateSuiteDefinition.html
     */
    toCreateSuiteDefinition(): this;
    /**
     * Grants permission to delete a suite definition
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_iotdeviceadvisor_DeleteSuiteDefinition.html
     */
    toDeleteSuiteDefinition(): this;
    /**
     * Grants permission to get a Device Advisor endpoint
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_iotdeviceadvisor_GetEndpoint.html
     */
    toGetEndpoint(): this;
    /**
     * Grants permission to get a suite definition
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_iotdeviceadvisor_GetSuiteDefinition.html
     */
    toGetSuiteDefinition(): this;
    /**
     * Grants permission to get a suite run
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_iotdeviceadvisor_GetSuiteRun.html
     */
    toGetSuiteRun(): this;
    /**
     * Grants permission to get the qualification report for a suite run
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_iotdeviceadvisor_GetSuiteRunReport.html
     */
    toGetSuiteRunReport(): this;
    /**
     * Grants permission to list suite definitions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_iotdeviceadvisor_ListSuiteDefinitions.html
     */
    toListSuiteDefinitions(): this;
    /**
     * Grants permission to list suite runs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_iotdeviceadvisor_ListSuiteRuns.html
     */
    toListSuiteRuns(): this;
    /**
     * Grants permission to list the tags (metadata) assigned to a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_iotdeviceadvisor_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to start a suite run
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_iotdeviceadvisor_StartSuiteRun.html
     */
    toStartSuiteRun(): this;
    /**
     * Grants permission to stop a suite run
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_iotdeviceadvisor_StopSuiteRun.html
     */
    toStopSuiteRun(): this;
    /**
     * Grants permission to add to or modify the tags of the given resource. Tags are metadata which can be used to manage a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_iotdeviceadvisor_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove the given tags (metadata) from a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_iotdeviceadvisor_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update a suite definition
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_iotdeviceadvisor_UpdateSuiteDefinition.html
     */
    toUpdateSuiteDefinition(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type Suitedefinition to the statement
     *
     * https://docs.aws.amazon.com/iot/latest/developerguide/device-advisor-workflow.html#device-advisor-workflow-create-suite-definition
     *
     * @param suiteDefinitionId - Identifier for the suiteDefinitionId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSuitedefinition(suiteDefinitionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type Suiterun to the statement
     *
     * https://docs.aws.amazon.com/iot/latest/developerguide/device-advisor-workflow.html#device-advisor-workflow-start-suite-run
     *
     * @param suiteDefinitionId - Identifier for the suiteDefinitionId.
     * @param suiteRunId - Identifier for the suiteRunId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSuiterun(suiteDefinitionId: string, suiteRunId: string, account?: string, region?: string, partition?: string): this;
}
