"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Iq = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [iq](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiq.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Iq extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [iq](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiq.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'iq';
        this.accessLevelList = {
            Write: [
                'AcceptCall',
                'ApprovePaymentRequest',
                'ApproveProposal',
                'ArchiveConversation',
                'CompleteProposal',
                'CreateConversation',
                'CreateExpert',
                'CreateListing',
                'CreateMilestoneProposal',
                'CreatePaymentRequest',
                'CreateProject',
                'CreateRequest',
                'CreateScheduledProposal',
                'CreateSeller',
                'CreateUpfrontProposal',
                'DeclineCall',
                'DeleteAttachment',
                'EndCall',
                'HideRequest',
                'InitiateCall',
                'MarkChatMessageRead',
                'RejectPaymentRequest',
                'RejectProposal',
                'SendCompanyChatMessage',
                'SendIndividualChatMessage',
                'UnarchiveConversation',
                'UpdateCompanyProfile',
                'UpdateConversationMembers',
                'UpdateExpert',
                'UpdateListing',
                'UpdateRequest',
                'UploadAttachment',
                'WithdrawPaymentRequest',
                'WithdrawProposal',
                'WriteReview'
            ],
            Read: [
                'GetBuyer',
                'GetCall',
                'GetChatInfo',
                'GetChatMessages',
                'GetChatToken',
                'GetCompanyProfile',
                'GetConversation',
                'GetExpert',
                'GetListing',
                'GetMarketplaceSeller',
                'GetPaymentRequest',
                'GetProposal',
                'GetReview',
                'ListConversations',
                'ListListings',
                'ListPaymentRequests',
                'ListProposals',
                'ListRequests',
                'ListReviews'
            ]
        };
    }
    /**
     * Grants permission to accept an incoming voice/video call
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toAcceptCall() {
        return this.to('AcceptCall');
    }
    /**
     * Grants permission to approve a payment request
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toApprovePaymentRequest() {
        return this.to('ApprovePaymentRequest');
    }
    /**
     * Grants permission to approve a proposal
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toApproveProposal() {
        return this.to('ApproveProposal');
    }
    /**
     * Grants permission to archive a conversation
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toArchiveConversation() {
        return this.to('ArchiveConversation');
    }
    /**
     * Grants permission to complete a proposal
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toCompleteProposal() {
        return this.to('CompleteProposal');
    }
    /**
     * Grants permission to respond to a request or send a direct message to initiate a conversation
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toCreateConversation() {
        return this.to('CreateConversation');
    }
    /**
     * Grants permission to create an expert profile
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toCreateExpert() {
        return this.to('CreateExpert');
    }
    /**
     * Grants permission to create a listing
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toCreateListing() {
        return this.to('CreateListing');
    }
    /**
     * Grants permission to create a milestone proposal
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toCreateMilestoneProposal() {
        return this.to('CreateMilestoneProposal');
    }
    /**
     * Grants permission to create a payment request
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toCreatePaymentRequest() {
        return this.to('CreatePaymentRequest');
    }
    /**
     * Grants permission to submit new requests
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toCreateProject() {
        return this.to('CreateProject');
    }
    /**
     * Grants permission to submit new requests
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toCreateRequest() {
        return this.to('CreateRequest');
    }
    /**
     * Grants permission to create a scheduled proposal
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toCreateScheduledProposal() {
        return this.to('CreateScheduledProposal');
    }
    /**
     * Grants permission to create a seller profile
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toCreateSeller() {
        return this.to('CreateSeller');
    }
    /**
     * Grants permission to create an upfront proposal
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toCreateUpfrontProposal() {
        return this.to('CreateUpfrontProposal');
    }
    /**
     * Grants permission to decline an incoming voice/video call
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toDeclineCall() {
        return this.to('DeclineCall');
    }
    /**
     * Grants permission to delete an existing attachment
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toDeleteAttachment() {
        return this.to('DeleteAttachment');
    }
    /**
     * Grants permission to end a voice/video call
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toEndCall() {
        return this.to('EndCall');
    }
    /**
     * Grants permission to read buyer information
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toGetBuyer() {
        return this.to('GetBuyer');
    }
    /**
     * Grants permission to read details of a voice/video call
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toGetCall() {
        return this.to('GetCall');
    }
    /**
     * Grants permission to read the chat environment details about a conversation
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toGetChatInfo() {
        return this.to('GetChatInfo');
    }
    /**
     * Grants permission to read chat messages in a conversation
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toGetChatMessages() {
        return this.to('GetChatMessages');
    }
    /**
     * Grants permission to request a websocket token for the conversation notifications
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toGetChatToken() {
        return this.to('GetChatToken');
    }
    /**
     * Grants permission to read a company profile
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toGetCompanyProfile() {
        return this.to('GetCompanyProfile');
    }
    /**
     * Grants permission to read details of a conversation
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toGetConversation() {
        return this.to('GetConversation');
    }
    /**
     * Grants permission to read expert information
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toGetExpert() {
        return this.to('GetExpert');
    }
    /**
     * Grants permission to read a listing
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toGetListing() {
        return this.to('GetListing');
    }
    /**
     * Grants permission to read a seller profile information
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toGetMarketplaceSeller() {
        return this.to('GetMarketplaceSeller');
    }
    /**
     * Grants permission to read a payment request
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toGetPaymentRequest() {
        return this.to('GetPaymentRequest');
    }
    /**
     * Grants permission to read a proposal
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toGetProposal() {
        return this.to('GetProposal');
    }
    /**
     * Grants permission to read a review for an expert
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toGetReview() {
        return this.to('GetReview');
    }
    /**
     * Grants permission to hide a request
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toHideRequest() {
        return this.to('HideRequest');
    }
    /**
     * Grants permission to start a voice/video call
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toInitiateCall() {
        return this.to('InitiateCall');
    }
    /**
     * Grants permission to list existing conversations
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toListConversations() {
        return this.to('ListConversations');
    }
    /**
     * Grants permission to list listings
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toListListings() {
        return this.to('ListListings');
    }
    /**
     * Grants permission to list payment requests
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toListPaymentRequests() {
        return this.to('ListPaymentRequests');
    }
    /**
     * Grants permission to list proposals
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toListProposals() {
        return this.to('ListProposals');
    }
    /**
     * Grants permission to list requests that are created
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toListRequests() {
        return this.to('ListRequests');
    }
    /**
     * Grants permission to list reviews for an expert
     *
     * Access Level: Read
     *
     * https://aws.amazon.com/iq/
     */
    toListReviews() {
        return this.to('ListReviews');
    }
    /**
     * Grants permission to mark a message as read in a conversation
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toMarkChatMessageRead() {
        return this.to('MarkChatMessageRead');
    }
    /**
     * Grants permission to reject a payment request
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toRejectPaymentRequest() {
        return this.to('RejectPaymentRequest');
    }
    /**
     * Grants permission to reject a proposal
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toRejectProposal() {
        return this.to('RejectProposal');
    }
    /**
     * Grants permission to send a message in a conversation as a company
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toSendCompanyChatMessage() {
        return this.to('SendCompanyChatMessage');
    }
    /**
     * Grants permission to send a message in a conversation as an individual
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toSendIndividualChatMessage() {
        return this.to('SendIndividualChatMessage');
    }
    /**
     * Grants permission to unarchive a conversation
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toUnarchiveConversation() {
        return this.to('UnarchiveConversation');
    }
    /**
     * Grants permission to update a company profile
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toUpdateCompanyProfile() {
        return this.to('UpdateCompanyProfile');
    }
    /**
     * Grants permission to add more participants into a conversation
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toUpdateConversationMembers() {
        return this.to('UpdateConversationMembers');
    }
    /**
     * Grants permission to update an expert information
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toUpdateExpert() {
        return this.to('UpdateExpert');
    }
    /**
     * Grants permission to update a listing
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toUpdateListing() {
        return this.to('UpdateListing');
    }
    /**
     * Grants permission to update a request
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toUpdateRequest() {
        return this.to('UpdateRequest');
    }
    /**
     * Grants permission to upload an attachment
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toUploadAttachment() {
        return this.to('UploadAttachment');
    }
    /**
     * Grants permission to withdraw a payment request
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toWithdrawPaymentRequest() {
        return this.to('WithdrawPaymentRequest');
    }
    /**
     * Grants permission to withdraw a proposal
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toWithdrawProposal() {
        return this.to('WithdrawProposal');
    }
    /**
     * Grants permission to write a review for an expert
     *
     * Access Level: Write
     *
     * https://aws.amazon.com/iq/
     */
    toWriteReview() {
        return this.to('WriteReview');
    }
    /**
     * Adds a resource of type conversation to the statement
     *
     * https://aws.amazon.com/iq/
     *
     * @param conversationId - Identifier for the conversationId.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onConversation(conversationId, region, partition) {
        return this.on(`arn:${partition || Iq.defaultPartition}:iq:${region || '*'}::conversation/${conversationId}`);
    }
    /**
     * Adds a resource of type buyer to the statement
     *
     * https://aws.amazon.com/iq/
     *
     * @param buyerId - Identifier for the buyerId.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onBuyer(buyerId, region, partition) {
        return this.on(`arn:${partition || Iq.defaultPartition}:iq:${region || '*'}::buyer/${buyerId}`);
    }
    /**
     * Adds a resource of type expert to the statement
     *
     * https://aws.amazon.com/iq/
     *
     * @param expertId - Identifier for the expertId.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onExpert(expertId, region, partition) {
        return this.on(`arn:${partition || Iq.defaultPartition}:iq:${region || '*'}::expert/${expertId}`);
    }
    /**
     * Adds a resource of type call to the statement
     *
     * https://aws.amazon.com/iq/
     *
     * @param callId - Identifier for the callId.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onCall(callId, region, partition) {
        return this.on(`arn:${partition || Iq.defaultPartition}:iq:${region || '*'}::call/${callId}`);
    }
    /**
     * Adds a resource of type token to the statement
     *
     * https://aws.amazon.com/iq/
     *
     * @param tokenId - Identifier for the tokenId.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onToken(tokenId, region, partition) {
        return this.on(`arn:${partition || Iq.defaultPartition}:iq:${region || '*'}::token/${tokenId}`);
    }
    /**
     * Adds a resource of type proposal to the statement
     *
     * https://aws.amazon.com/iq/
     *
     * @param conversationId - Identifier for the conversationId.
     * @param proposalId - Identifier for the proposalId.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onProposal(conversationId, proposalId, region, partition) {
        return this.on(`arn:${partition || Iq.defaultPartition}:iq:${region || '*'}::proposal/${conversationId}/${proposalId}`);
    }
    /**
     * Adds a resource of type paymentRequest to the statement
     *
     * https://aws.amazon.com/iq/
     *
     * @param conversationId - Identifier for the conversationId.
     * @param proposalId - Identifier for the proposalId.
     * @param paymentRequestId - Identifier for the paymentRequestId.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onPaymentRequest(conversationId, proposalId, paymentRequestId, region, partition) {
        return this.on(`arn:${partition || Iq.defaultPartition}:iq:${region || '*'}::paymentRequest/${conversationId}/${proposalId}/${paymentRequestId}`);
    }
    /**
     * Adds a resource of type paymentSchedule to the statement
     *
     * https://aws.amazon.com/iq/
     *
     * @param conversationId - Identifier for the conversationId.
     * @param proposalId - Identifier for the proposalId.
     * @param versionId - Identifier for the versionId.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onPaymentSchedule(conversationId, proposalId, versionId, region, partition) {
        return this.on(`arn:${partition || Iq.defaultPartition}:iq:${region || '*'}::paymentSchedule/${conversationId}/${proposalId}/${versionId}`);
    }
    /**
     * Adds a resource of type seller to the statement
     *
     * https://aws.amazon.com/iq/
     *
     * @param sellerAwsAccountId - Identifier for the sellerAwsAccountId.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onSeller(sellerAwsAccountId, region, partition) {
        return this.on(`arn:${partition || Iq.defaultPartition}:iq:${region || '*'}::seller/${sellerAwsAccountId}`);
    }
    /**
     * Adds a resource of type company to the statement
     *
     * https://aws.amazon.com/iq/
     *
     * @param companyId - Identifier for the companyId.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onCompany(companyId, region, partition) {
        return this.on(`arn:${partition || Iq.defaultPartition}:iq:${region || '*'}::company/${companyId}`);
    }
    /**
     * Adds a resource of type request to the statement
     *
     * https://aws.amazon.com/iq/
     *
     * @param requestId - Identifier for the requestId.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onRequest(requestId, region, partition) {
        return this.on(`arn:${partition || Iq.defaultPartition}:iq:${region || '*'}::request/${requestId}`);
    }
    /**
     * Adds a resource of type listing to the statement
     *
     * https://aws.amazon.com/iq/
     *
     * @param listingId - Identifier for the listingId.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onListing(listingId, region, partition) {
        return this.on(`arn:${partition || Iq.defaultPartition}:iq:${region || '*'}::listing/${listingId}`);
    }
    /**
     * Adds a resource of type attachment to the statement
     *
     * https://aws.amazon.com/iq/
     *
     * @param attachmentId - Identifier for the attachmentId.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onAttachment(attachmentId, region, partition) {
        return this.on(`arn:${partition || Iq.defaultPartition}:iq:${region || '*'}::attachment/${attachmentId}`);
    }
}
exports.Iq = Iq;
_a = JSII_RTTI_SYMBOL_1;
Iq[_a] = { fqn: "iam-floyd.Iq", version: "0.502.0" };
//# sourceMappingURL=data:application/json;base64,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