"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Lakeformation = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [lakeformation](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awslakeformation.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Lakeformation extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [lakeformation](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awslakeformation.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'lakeformation';
        this.accessLevelList = {
            Tagging: [
                'AddLFTagsToResource',
                'RemoveLFTagsFromResource'
            ],
            'Permissions management': [
                'BatchGrantPermissions',
                'BatchRevokePermissions',
                'GrantPermissions',
                'PutDataLakeSettings',
                'RevokePermissions'
            ],
            Write: [
                'CancelTransaction',
                'CommitTransaction',
                'CreateDataCellsFilter',
                'CreateLFTag',
                'DeleteDataCellsFilter',
                'DeleteLFTag',
                'DeleteObjectsOnCancel',
                'DeregisterResource',
                'ExtendTransaction',
                'GetDataAccess',
                'RegisterResource',
                'StartQueryPlanning',
                'StartTransaction',
                'UpdateDataCellsFilter',
                'UpdateLFTag',
                'UpdateResource',
                'UpdateTableObjects',
                'UpdateTableStorageOptimizer'
            ],
            Read: [
                'DescribeResource',
                'DescribeTransaction',
                'GetDataCellsFilter',
                'GetDataLakeSettings',
                'GetEffectivePermissionsForPath',
                'GetLFTag',
                'GetQueryState',
                'GetQueryStatistics',
                'GetResourceLFTags',
                'GetTableObjects',
                'GetWorkUnitResults',
                'GetWorkUnits',
                'ListLFTags',
                'SearchDatabasesByLFTags',
                'SearchTablesByLFTags'
            ],
            List: [
                'ListDataCellsFilter',
                'ListPermissions',
                'ListResources',
                'ListTableStorageOptimizers',
                'ListTransactions'
            ]
        };
    }
    /**
     * Grants permission to attach Lake Formation tags to catalog resources
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-AddLFTagsToResource
     */
    toAddLFTagsToResource() {
        return this.to('AddLFTagsToResource');
    }
    /**
     * Grants permission to data lake permissions to one or more principals in a batch
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-BatchGrantPermissions
     */
    toBatchGrantPermissions() {
        return this.to('BatchGrantPermissions');
    }
    /**
     * Grants permission to revoke data lake permissions from one or more principals in a batch
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-BatchRevokePermissions
     */
    toBatchRevokePermissions() {
        return this.to('BatchRevokePermissions');
    }
    /**
     * Grants permission to cancel the given transaction
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-transactions-api.html#aws-lake-formation-api-transactions-api-CancelTransaction
     */
    toCancelTransaction() {
        return this.to('CancelTransaction');
    }
    /**
     * Grants permission to commit the given transaction
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-transactions-api.html#aws-lake-formation-api-transactions-api-CommitTransaction
     */
    toCommitTransaction() {
        return this.to('CommitTransaction');
    }
    /**
     * Grants permission to create a Lake Formation data cell filter
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-data-filter.html#aws-lake-formation-api-data-filter-CreateDataCellsFilter
     */
    toCreateDataCellsFilter() {
        return this.to('CreateDataCellsFilter');
    }
    /**
     * Grants permission to create a Lake Formation tag
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-CreateLFTag
     */
    toCreateLFTag() {
        return this.to('CreateLFTag');
    }
    /**
     * Grants permission to delete a Lake Formation data cell filter
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-data-filter.html#aws-lake-formation-api-data-filter-DeleteDataCellsFilter
     */
    toDeleteDataCellsFilter() {
        return this.to('DeleteDataCellsFilter');
    }
    /**
     * Grants permission to delete a Lake Formation tag
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-DeleteLFTag
     */
    toDeleteLFTag() {
        return this.to('DeleteLFTag');
    }
    /**
     * Grants permission to delete the specified objects if the transaction is canceled
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-transactions-api.html#aws-lake-formation-api-transactions-api-DeleteObjectsOnCancel
     */
    toDeleteObjectsOnCancel() {
        return this.to('DeleteObjectsOnCancel');
    }
    /**
     * Grants permission to deregister a registered location
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-DeregisterResource
     */
    toDeregisterResource() {
        return this.to('DeregisterResource');
    }
    /**
     * Grants permission to describe a registered location
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-DescribeResource
     */
    toDescribeResource() {
        return this.to('DescribeResource');
    }
    /**
     * Grants permission to get status of the given transaction
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-transactions-api.html#aws-lake-formation-api-transactions-api-DescribeTransaction
     */
    toDescribeTransaction() {
        return this.to('DescribeTransaction');
    }
    /**
     * Grants permission to extend the timeout of the given transaction
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-transactions-api.html#aws-lake-formation-api-transactions-api-ExtendTransaction
     */
    toExtendTransaction() {
        return this.to('ExtendTransaction');
    }
    /**
     * Grants permission to virtual data lake access
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-GetDataAccess
     */
    toGetDataAccess() {
        return this.to('GetDataAccess');
    }
    /**
     * Grants permission to retrieve a Lake Formation data cell filter
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-data-filter.html#aws-lake-formation-api-data-filter-GetDataCellsFilter
     */
    toGetDataCellsFilter() {
        return this.to('GetDataCellsFilter');
    }
    /**
     * Grants permission to retrieve data lake settings such as the list of data lake administrators and database and table default permissions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-GetDataLakeSettings
     */
    toGetDataLakeSettings() {
        return this.to('GetDataLakeSettings');
    }
    /**
     * Grants permission to retrieve permissions attached to resources in the given path
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-GetEffectivePermissionsForPath
     */
    toGetEffectivePermissionsForPath() {
        return this.to('GetEffectivePermissionsForPath');
    }
    /**
     * Grants permission to retrieve a Lake Formation tag
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-GetLFTag
     */
    toGetLFTag() {
        return this.to('GetLFTag');
    }
    /**
     * Grants permission to retrieve the state of the given query
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - lakeformation:StartQueryPlanning
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-querying.html#aws-lake-formation-api-querying-GetQueryState
     */
    toGetQueryState() {
        return this.to('GetQueryState');
    }
    /**
     * Grants permission to retrieve the statistics for the given query
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - lakeformation:StartQueryPlanning
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-querying.html#aws-lake-formation-api-querying-GetQueryStatistics
     */
    toGetQueryStatistics() {
        return this.to('GetQueryStatistics');
    }
    /**
     * Grants permission to retrieve lakeformation tags on a catalog resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-GetResourceLFTags
     */
    toGetResourceLFTags() {
        return this.to('GetResourceLFTags');
    }
    /**
     * Grants permission to retrieve objects from a table
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-objects.html#aws-lake-formation-api-objects-GetTableObjects
     */
    toGetTableObjects() {
        return this.to('GetTableObjects');
    }
    /**
     * Grants permission to retrieve the results for the given work units
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - lakeformation:GetWorkUnits
     * - lakeformation:StartQueryPlanning
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-querying.html#aws-lake-formation-api-querying-GetWorkUnitResults
     */
    toGetWorkUnitResults() {
        return this.to('GetWorkUnitResults');
    }
    /**
     * Grants permission to retrieve the work units for the given query
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - lakeformation:StartQueryPlanning
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-querying.html#aws-lake-formation-api-querying-GetWorkUnits
     */
    toGetWorkUnits() {
        return this.to('GetWorkUnits');
    }
    /**
     * Grants permission to data lake permissions to a principal
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-GrantPermissions
     */
    toGrantPermissions() {
        return this.to('GrantPermissions');
    }
    /**
     * Grants permission to list cell filters
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-data-filter.html#aws-lake-formation-api-data-filter-ListDataCellsFilter
     */
    toListDataCellsFilter() {
        return this.to('ListDataCellsFilter');
    }
    /**
     * Grants permission to list Lake Formation tags
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-ListLFTags
     */
    toListLFTags() {
        return this.to('ListLFTags');
    }
    /**
     * Grants permission to list permissions filtered by principal or resource
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-ListPermissions
     */
    toListPermissions() {
        return this.to('ListPermissions');
    }
    /**
     * Grants permission to List registered locations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-ListResources
     */
    toListResources() {
        return this.to('ListResources');
    }
    /**
     * Grants permission to list all the storage optimizers for the Governed table
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-optimizers.html#aws-lake-formation-api-optimizers-ListTableStorageOptimizers
     */
    toListTableStorageOptimizers() {
        return this.to('ListTableStorageOptimizers');
    }
    /**
     * Grants permission to list all transactions in the system
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-transactions-api.html#aws-lake-formation-api-transactions-api-ListTransactions
     */
    toListTransactions() {
        return this.to('ListTransactions');
    }
    /**
     * Grants permission to overwrite data lake settings such as the list of data lake administrators and database and table default permissions
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-PutDataLakeSettings
     */
    toPutDataLakeSettings() {
        return this.to('PutDataLakeSettings');
    }
    /**
     * Grants permission to register a new location to be managed by Lake Formation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-RegisterResource
     */
    toRegisterResource() {
        return this.to('RegisterResource');
    }
    /**
     * Grants permission to remove lakeformation tags from catalog resources
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-RemoveLFTagsFromResource
     */
    toRemoveLFTagsFromResource() {
        return this.to('RemoveLFTagsFromResource');
    }
    /**
     * Grants permission to revoke data lake permissions from a principal
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-RevokePermissions
     */
    toRevokePermissions() {
        return this.to('RevokePermissions');
    }
    /**
     * Grants permission to list catalog databases with Lake Formation tags
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-SearchDatabasesByLFTags
     */
    toSearchDatabasesByLFTags() {
        return this.to('SearchDatabasesByLFTags');
    }
    /**
     * Grants permission to list catalog tables with Lake Formation tags
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-SearchTablesByLFTags
     */
    toSearchTablesByLFTags() {
        return this.to('SearchTablesByLFTags');
    }
    /**
     * Grants permission to initiate the planning of the given query
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-querying.html#aws-lake-formation-api-querying-StartQueryPlanning
     */
    toStartQueryPlanning() {
        return this.to('StartQueryPlanning');
    }
    /**
     * Grants permission to start a new transaction
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-transactions-api.html#aws-lake-formation-api-transactions-api-StartTransaction
     */
    toStartTransaction() {
        return this.to('StartTransaction');
    }
    /**
     * Grants permission to update a Lake Formation data cell filter
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-data-filter.html#aws-lake-formation-api-data-filter-UpdateDataCellsFilter
     */
    toUpdateDataCellsFilter() {
        return this.to('UpdateDataCellsFilter');
    }
    /**
     * Grants permission to update a Lake Formation tag
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-UpdateLFTag
     */
    toUpdateLFTag() {
        return this.to('UpdateLFTag');
    }
    /**
     * Grants permission to update a registered location
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-UpdateResource
     */
    toUpdateResource() {
        return this.to('UpdateResource');
    }
    /**
     * Grants permission to add or delete the specified objects to or from a table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-objects.html#aws-lake-formation-api-objects-UpdateTableObjects
     */
    toUpdateTableObjects() {
        return this.to('UpdateTableObjects');
    }
    /**
     * Grants permission to update the configuration of the storage optimizer for the Governed table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-optimizers.html#aws-lake-formation-api-optimizers-UpdateTableStorageOptimizer
     */
    toUpdateTableStorageOptimizer() {
        return this.to('UpdateTableStorageOptimizer');
    }
}
exports.Lakeformation = Lakeformation;
_a = JSII_RTTI_SYMBOL_1;
Lakeformation[_a] = { fqn: "iam-floyd.Lakeformation", version: "0.502.0" };
//# sourceMappingURL=data:application/json;base64,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