import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [tnb](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awstelconetworkbuilder.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Tnb extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [tnb](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awstelconetworkbuilder.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to cancel a network operation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_CancelSolNetworkOperation.html
     */
    toCancelSolNetworkOperation(): this;
    /**
     * Grants permission to create a function package
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_CreateSolFunctionPackage.html
     */
    toCreateSolFunctionPackage(): this;
    /**
     * Grants permission to create a network instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_CreateSolNetworkInstance.html
     */
    toCreateSolNetworkInstance(): this;
    /**
     * Grants permission to create a network package
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_CreateSolNetworkPackage.html
     */
    toCreateSolNetworkPackage(): this;
    /**
     * Grants permission to delete a function package
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_DeleteSolFunctionPackage.html
     */
    toDeleteSolFunctionPackage(): this;
    /**
     * Grants permission to delete a network instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_DeleteSolNetworkInstance.html
     */
    toDeleteSolNetworkInstance(): this;
    /**
     * Grants permission to delete a network package
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_DeleteSolNetworkPackage.html
     */
    toDeleteSolNetworkPackage(): this;
    /**
     * Grants permission to get a function instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_GetSolFunctionInstance.html
     */
    toGetSolFunctionInstance(): this;
    /**
     * Grants permission to get a function package
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_GetSolFunctionPackage.html
     */
    toGetSolFunctionPackage(): this;
    /**
     * Grants permission to get a function package contents
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_GetSolFunctionPackageContent.html
     */
    toGetSolFunctionPackageContent(): this;
    /**
     * Grants permission to get a function package descriptor
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_GetSolFunctionPackageDescriptor.html
     */
    toGetSolFunctionPackageDescriptor(): this;
    /**
     * Grants permission to get a network instance
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_GetSolNetworkInstance.html
     */
    toGetSolNetworkInstance(): this;
    /**
     * Grants permission to get a network operation
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_GetSolNetworkOperation.html
     */
    toGetSolNetworkOperation(): this;
    /**
     * Grants permission to get a network package
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_GetSolNetworkPackage.html
     */
    toGetSolNetworkPackage(): this;
    /**
     * Grants permission to get a network package contents
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_GetSolNetworkPackageContent.html
     */
    toGetSolNetworkPackageContent(): this;
    /**
     * Grants permission to get a network package descriptor
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_GetSolNetworkPackageDescriptor.html
     */
    toGetSolNetworkPackageDescriptor(): this;
    /**
     * Grants permission to instantiate a network instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_InstantiateSolNetworkInstance.html
     */
    toInstantiateSolNetworkInstance(): this;
    /**
     * Grants permission to list function instances
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_ListSolFunctionInstances.html
     */
    toListSolFunctionInstances(): this;
    /**
     * Grants permission to list function packages
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_ListSolFunctionPackages.html
     */
    toListSolFunctionPackages(): this;
    /**
     * Grants permission to list network instances
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_ListSolNetworkInstances.html
     */
    toListSolNetworkInstances(): this;
    /**
     * Grants permission to list network operations
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_ListSolNetworkOperations.html
     */
    toListSolNetworkOperations(): this;
    /**
     * Grants permission to list network packages
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_ListSolNetworkPackages.html
     */
    toListSolNetworkPackages(): this;
    /**
     * Grants permission to return a list of tags for a resource
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to upload function package content
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_PutSolFunctionPackageContent.html
     */
    toPutSolFunctionPackageContent(): this;
    /**
     * Grants permission to upload network package content
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_PutSolNetworkPackageContent.html
     */
    toPutSolNetworkPackageContent(): this;
    /**
     * Grants permission to add tags to the specified resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to terminate a network instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_TerminateSolNetworkInstance.html
     */
    toTerminateSolNetworkInstance(): this;
    /**
     * Grants permission to remove tags from the specified resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update a function package
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_UpdateSolFunctionPackage.html
     */
    toUpdateSolFunctionPackage(): this;
    /**
     * Grants permission to update a network instance
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_UpdateSolNetworkInstance.html
     */
    toUpdateSolNetworkInstance(): this;
    /**
     * Grants permission to update a network package
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_UpdateSolNetworkPackage.html
     */
    toUpdateSolNetworkPackage(): this;
    /**
     * Grants permission to validate function package content
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_ValidateSolFunctionPackageContent.html
     */
    toValidateSolFunctionPackageContent(): this;
    /**
     * Grants permission to validate network package content
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/tnb/latest/APIReference/API_ValidateSolNetworkPackageContent.html
     */
    toValidateSolNetworkPackageContent(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type function-package to the statement
     *
     * https://docs.aws.amazon.com/tnb/latest/ug/function-packages.html
     *
     * @param functionPackageId - Identifier for the functionPackageId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onFunctionPackage(functionPackageId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type network-package to the statement
     *
     * https://docs.aws.amazon.com/tnb/latest/ug/network-packages.html
     *
     * @param networkPackageId - Identifier for the networkPackageId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onNetworkPackage(networkPackageId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type network-instance to the statement
     *
     * https://docs.aws.amazon.com/tnb/latest/ug/network-instances.html
     *
     * @param networkInstanceId - Identifier for the networkInstanceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onNetworkInstance(networkInstanceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type function-instance to the statement
     *
     * https://docs.aws.amazon.com/tnb/latest/ug/function-packages.html
     *
     * @param functionInstanceId - Identifier for the functionInstanceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onFunctionInstance(functionInstanceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type network-operation to the statement
     *
     * https://docs.aws.amazon.com/tnb/latest/ug/network-operations.html
     *
     * @param networkOperationId - Identifier for the networkOperationId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onNetworkOperation(networkOperationId: string, account?: string, region?: string, partition?: string): this;
}
