"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Wellarchitected = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [wellarchitected](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awswell-architectedtool.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Wellarchitected extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [wellarchitected](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awswell-architectedtool.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'wellarchitected';
        this.accessLevelList = {
            Write: [
                'AssociateLenses',
                'CreateLensShare',
                'CreateLensVersion',
                'CreateMilestone',
                'CreateWorkload',
                'CreateWorkloadShare',
                'DeleteLens',
                'DeleteLensShare',
                'DeleteWorkload',
                'DeleteWorkloadShare',
                'DisassociateLenses',
                'ImportLens',
                'UpdateAnswer',
                'UpdateGlobalSettings',
                'UpdateLensReview',
                'UpdateShareInvitation',
                'UpdateWorkload',
                'UpdateWorkloadShare',
                'UpgradeLensReview'
            ],
            Read: [
                'ExportLens',
                'GetAnswer',
                'GetConsolidatedReport',
                'GetLens',
                'GetLensReview',
                'GetLensReviewReport',
                'GetLensVersionDifference',
                'GetMilestone',
                'GetWorkload',
                'ListTagsForResource'
            ],
            List: [
                'ListAnswers',
                'ListCheckDetails',
                'ListCheckSummaries',
                'ListLensReviewImprovements',
                'ListLensReviews',
                'ListLensShares',
                'ListLenses',
                'ListMilestones',
                'ListNotifications',
                'ListShareInvitations',
                'ListWorkloadShares',
                'ListWorkloads'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to associate a lens to the specified workload
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_AssociateLenses.html
     */
    toAssociateLenses() {
        return this.to('AssociateLenses');
    }
    /**
     * Grants permission to an owner of a lens to share with other AWS accounts and IAM Users
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_CreateLensShare.html
     */
    toCreateLensShare() {
        return this.to('CreateLensShare');
    }
    /**
     * Grants permission to create a new lens version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_CreateLensVersion.html
     */
    toCreateLensVersion() {
        return this.to('CreateLensVersion');
    }
    /**
     * Grants permission to create a new milestone for the specified workload
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_CreateMilestone.html
     */
    toCreateMilestone() {
        return this.to('CreateMilestone');
    }
    /**
     * Grants permission to create a new workload
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_CreateWorkload.html
     */
    toCreateWorkload() {
        return this.to('CreateWorkload');
    }
    /**
     * Grants permission to share a workload with another account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_CreateWorkloadShare.html
     */
    toCreateWorkloadShare() {
        return this.to('CreateWorkloadShare');
    }
    /**
     * Grants permission to delete a lens
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_DeleteLens.html
     */
    toDeleteLens() {
        return this.to('DeleteLens');
    }
    /**
     * Grants permission to delete an existing lens share
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_DeleteLensShare.html
     */
    toDeleteLensShare() {
        return this.to('DeleteLensShare');
    }
    /**
     * Grants permission to delete an existing workload
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_DeleteWorkload.html
     */
    toDeleteWorkload() {
        return this.to('DeleteWorkload');
    }
    /**
     * Grants permission to delete an existing workload share
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_DeleteWorkloadShare.html
     */
    toDeleteWorkloadShare() {
        return this.to('DeleteWorkloadShare');
    }
    /**
     * Grants permission to disassociate a lens from the specified workload
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_DisassociateLenses.html
     */
    toDisassociateLenses() {
        return this.to('DisassociateLenses');
    }
    /**
     * Grants permission to export an existing lens
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_ExportLens.html
     */
    toExportLens() {
        return this.to('ExportLens');
    }
    /**
     * Grants permission to retrieve the specified answer from the specified lens review
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_GetAnswer.html
     */
    toGetAnswer() {
        return this.to('GetAnswer');
    }
    /**
     * Grants permission to get consolidated report metrics or to generate the consolidated report PDF in this account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_GetConsolidatedReport.html
     */
    toGetConsolidatedReport() {
        return this.to('GetConsolidatedReport');
    }
    /**
     * Grants permission to get an existing lens
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_DeleteLensShare.html
     */
    toGetLens() {
        return this.to('GetLens');
    }
    /**
     * Grants permission to retrieve the specified lens review of the specified workload
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_GetLensReview.html
     */
    toGetLensReview() {
        return this.to('GetLensReview');
    }
    /**
     * Grants permission to retrieve the report for the specified lens review
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_GetLensReviewReport.html
     */
    toGetLensReviewReport() {
        return this.to('GetLensReviewReport');
    }
    /**
     * Grants permission to get the difference between the specified lens version and latest available lens version
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_GetLensVersionDifference.html
     */
    toGetLensVersionDifference() {
        return this.to('GetLensVersionDifference');
    }
    /**
     * Grants permission to retrieve the specified milestone of the specified workload
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_GetMilestone.html
     */
    toGetMilestone() {
        return this.to('GetMilestone');
    }
    /**
     * Grants permission to retrieve the specified workload
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_GetWorkload.html
     */
    toGetWorkload() {
        return this.to('GetWorkload');
    }
    /**
     * Grants permission to import a new lens
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_ImportLens.html
     */
    toImportLens() {
        return this.to('ImportLens');
    }
    /**
     * Grants permission to list the answers from the specified lens review
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_ListAnswers.html
     */
    toListAnswers() {
        return this.to('ListAnswers');
    }
    /**
     * Grants permission to list the check-details for the workload
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_ListCheckDetails.html
     */
    toListCheckDetails() {
        return this.to('ListCheckDetails');
    }
    /**
     * Grants permission to list the check-summaries for the workload
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_ListCheckSummaries.html
     */
    toListCheckSummaries() {
        return this.to('ListCheckSummaries');
    }
    /**
     * Grants permission to list the improvements of the specified lens review
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_ListLensReviewImprovements.html
     */
    toListLensReviewImprovements() {
        return this.to('ListLensReviewImprovements');
    }
    /**
     * Grants permission to list the lens reviews of the specified workload
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_ListLensReviews.html
     */
    toListLensReviews() {
        return this.to('ListLensReviews');
    }
    /**
     * Grants permission to list all shares created for a lens
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_ListLensShares.html
     */
    toListLensShares() {
        return this.to('ListLensShares');
    }
    /**
     * Grants permission to list the lenses available to this account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_ListLenses.html
     */
    toListLenses() {
        return this.to('ListLenses');
    }
    /**
     * Grants permission to list the milestones of the specified workload
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_ListMilestones.html
     */
    toListMilestones() {
        return this.to('ListMilestones');
    }
    /**
     * Grants permission to list notifications related to the account or specified resource
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_ListNotifications.html
     */
    toListNotifications() {
        return this.to('ListNotifications');
    }
    /**
     * Grants permission to list the workload share invitations of the specified account or user
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_ListShareInvitations.html
     */
    toListShareInvitations() {
        return this.to('ListShareInvitations');
    }
    /**
     * Grants permission to list tags for a Well-Architected resource
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to list the workload shares of the specified workload
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_ListWorkloadShares.html
     */
    toListWorkloadShares() {
        return this.to('ListWorkloadShares');
    }
    /**
     * Grants permission to list the workloads in this account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_ListWorkloads.html
     */
    toListWorkloads() {
        return this.to('ListWorkloads');
    }
    /**
     * Grants permission to tag a Well-Architected resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to untag a Well-Architected resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update properties of the specified answer
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_UpdateAnswer.html
     */
    toUpdateAnswer() {
        return this.to('UpdateAnswer');
    }
    /**
     * Grants permission to update settings to enable aws-organization support
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_UpdateGlobalSettings.html
     */
    toUpdateGlobalSettings() {
        return this.to('UpdateGlobalSettings');
    }
    /**
     * Grants permission to update properties of the specified lens review
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_UpdateLensReview.html
     */
    toUpdateLensReview() {
        return this.to('UpdateLensReview');
    }
    /**
     * Grants permission to update status of the specified workload share invitation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_UpdateShareInvitation.html
     */
    toUpdateShareInvitation() {
        return this.to('UpdateShareInvitation');
    }
    /**
     * Grants permission to update properties of the specified workload
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_UpdateWorkload.html
     */
    toUpdateWorkload() {
        return this.to('UpdateWorkload');
    }
    /**
     * Grants permission to update properties of the specified workload
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_UpdateWorkloadShare.html
     */
    toUpdateWorkloadShare() {
        return this.to('UpdateWorkloadShare');
    }
    /**
     * Grants permission to upgrade the specified lens review to use the latest version of the associated lens
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_UpgradeLensReview.html
     */
    toUpgradeLensReview() {
        return this.to('UpgradeLensReview');
    }
    /**
     * Adds a resource of type workload to the statement
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_Workload.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onWorkload(resourceId, account, region, partition) {
        return this.on(`arn:${partition || Wellarchitected.defaultPartition}:wellarchitected:${region || '*'}:${account || '*'}:workload/${resourceId}`);
    }
    /**
     * Adds a resource of type lens to the statement
     *
     * https://docs.aws.amazon.com/wellarchitected/latest/APIReference/API_Lens.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onLens(resourceId, account, region, partition) {
        return this.on(`arn:${partition || Wellarchitected.defaultPartition}:wellarchitected:${region || '*'}:${account || '*'}:lens/${resourceId}`);
    }
}
exports.Wellarchitected = Wellarchitected;
_a = JSII_RTTI_SYMBOL_1;
Wellarchitected[_a] = { fqn: "iam-floyd.Wellarchitected", version: "0.502.0" };
//# sourceMappingURL=data:application/json;base64,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