import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [wickr](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awswickr.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Wickr extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [wickr](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awswickr.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to create and manage Wickr networks
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wickr/latest/adminguide/security-iam.html
     */
    toCreateAdminSession(): this;
    /**
     * Grants permission to create a new wickr network
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wickr/latest/adminguide/security-iam.html
     */
    toCreateNetwork(): this;
    /**
     * Grants permission to view Wickr networks
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wickr/latest/adminguide/security-iam.html
     */
    toListNetworks(): this;
    /**
     * Grants permission to list the tags applied to a Wickr resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/wickr/latest/adminguide/security-iam.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to add tags to a specified wickr resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/wickr/latest/adminguide/security-iam.html
     */
    toTagResource(): this;
    /**
     * Grants permission to untag the specified tags from the specified wickr resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/wickr/latest/adminguide/security-iam.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update Wickr network details
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/wickr/latest/adminguide/security-iam.html
     */
    toUpdateNetworkDetails(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type network to the statement
     *
     * https://docs.aws.amazon.com/wickr/latest/adminguide/
     *
     * @param networkId - Identifier for the networkId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onNetwork(networkId: string, account?: string, region?: string, partition?: string): this;
}
