"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Resiliencehub = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [resiliencehub](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsresiliencehubservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Resiliencehub extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [resiliencehub](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsresiliencehubservice.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'resiliencehub';
        this.accessLevelList = {
            Write: [
                'AddDraftAppVersionResourceMappings',
                'CreateApp',
                'CreateRecommendationTemplate',
                'CreateResiliencyPolicy',
                'DeleteApp',
                'DeleteAppAssessment',
                'DeleteRecommendationTemplate',
                'DeleteResiliencyPolicy',
                'ImportResourcesToDraftAppVersion',
                'PublishAppVersion',
                'PutDraftAppVersionTemplate',
                'RemoveDraftAppVersionResourceMappings',
                'ResolveAppVersionResources',
                'StartAppAssessment',
                'UpdateApp',
                'UpdateResiliencyPolicy'
            ],
            Read: [
                'DescribeApp',
                'DescribeAppAssessment',
                'DescribeAppVersionResourcesResolutionStatus',
                'DescribeAppVersionTemplate',
                'DescribeDraftAppVersionResourcesImportStatus',
                'DescribeResiliencyPolicy',
                'ListTagsForResource'
            ],
            List: [
                'ListAlarmRecommendations',
                'ListAppAssessments',
                'ListAppComponentCompliances',
                'ListAppComponentRecommendations',
                'ListAppVersionResourceMappings',
                'ListAppVersionResources',
                'ListAppVersions',
                'ListApps',
                'ListRecommendationTemplates',
                'ListResiliencyPolicies',
                'ListSopRecommendations',
                'ListSuggestedResiliencyPolicies',
                'ListTestRecommendations',
                'ListUnsupportedAppVersionResources'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to add draft application version resource mappings
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - cloudformation:DescribeStacks
     * - cloudformation:ListStackResources
     * - resource-groups:GetGroup
     * - resource-groups:ListGroupResources
     * - servicecatalog:GetApplication
     * - servicecatalog:ListAssociatedResources
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_AddDraftAppVersionResourceMappings.html
     */
    toAddDraftAppVersionResourceMappings() {
        return this.to('AddDraftAppVersionResourceMappings');
    }
    /**
     * Grants permission to create application
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_CreateApp.html
     */
    toCreateApp() {
        return this.to('CreateApp');
    }
    /**
     * Grants permission to create recommendation template
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - s3:CreateBucket
     * - s3:ListBucket
     * - s3:PutObject
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_CreateRecommendationTemplate.html
     */
    toCreateRecommendationTemplate() {
        return this.to('CreateRecommendationTemplate');
    }
    /**
     * Grants permission to create resiliency policy
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_CreateResiliencyPolicy.html
     */
    toCreateResiliencyPolicy() {
        return this.to('CreateResiliencyPolicy');
    }
    /**
     * Grants permission to batch delete application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DeleteApp.html
     */
    toDeleteApp() {
        return this.to('DeleteApp');
    }
    /**
     * Grants permission to batch delete application assessment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DeleteAppAssessment.html
     */
    toDeleteAppAssessment() {
        return this.to('DeleteAppAssessment');
    }
    /**
     * Grants permission to batch delete recommendation template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DeleteRecommendationTemplate.html
     */
    toDeleteRecommendationTemplate() {
        return this.to('DeleteRecommendationTemplate');
    }
    /**
     * Grants permission to batch delete resiliency policy
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DeleteResiliencyPolicy.html
     */
    toDeleteResiliencyPolicy() {
        return this.to('DeleteResiliencyPolicy');
    }
    /**
     * Grants permission to describe application
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DescribeApp.html
     */
    toDescribeApp() {
        return this.to('DescribeApp');
    }
    /**
     * Grants permission to describe application assessment
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DescribeAppAssessment.html
     */
    toDescribeAppAssessment() {
        return this.to('DescribeAppAssessment');
    }
    /**
     * Grants permission to describe application resolution
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DescribeAppVersionResourcesResolutionStatus.html
     */
    toDescribeAppVersionResourcesResolutionStatus() {
        return this.to('DescribeAppVersionResourcesResolutionStatus');
    }
    /**
     * Grants permission to describe application version template
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DescribeAppVersionTemplate.html
     */
    toDescribeAppVersionTemplate() {
        return this.to('DescribeAppVersionTemplate');
    }
    /**
     * Grants permission to describe draft application version resources import status
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DescribeDraftAppVersionResourcesImportStatus.html
     */
    toDescribeDraftAppVersionResourcesImportStatus() {
        return this.to('DescribeDraftAppVersionResourcesImportStatus');
    }
    /**
     * Grants permission to describe resiliency policy
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DescribeResiliencyPolicy.html
     */
    toDescribeResiliencyPolicy() {
        return this.to('DescribeResiliencyPolicy');
    }
    /**
     * Grants permission to import resources to draft application version
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - cloudformation:DescribeStacks
     * - cloudformation:ListStackResources
     * - resource-groups:GetGroup
     * - resource-groups:ListGroupResources
     * - servicecatalog:GetApplication
     * - servicecatalog:ListAssociatedResources
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ImportResourcesToDraftAppVersion.html
     */
    toImportResourcesToDraftAppVersion() {
        return this.to('ImportResourcesToDraftAppVersion');
    }
    /**
     * Grants permission to list alarm recommendation
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListAlarmRecommendations.html
     */
    toListAlarmRecommendations() {
        return this.to('ListAlarmRecommendations');
    }
    /**
     * Grants permission to list application assessment
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListAppAssessments.html
     */
    toListAppAssessments() {
        return this.to('ListAppAssessments');
    }
    /**
     * Grants permission to list app component compliances
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListAppComponentCompliances.html
     */
    toListAppComponentCompliances() {
        return this.to('ListAppComponentCompliances');
    }
    /**
     * Grants permission to list app component recommendations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListAppComponentRecommendations.html
     */
    toListAppComponentRecommendations() {
        return this.to('ListAppComponentRecommendations');
    }
    /**
     * Grants permission to application version resource mappings
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListAppVersionResourceMappings.html
     */
    toListAppVersionResourceMappings() {
        return this.to('ListAppVersionResourceMappings');
    }
    /**
     * Grants permission to list application resources
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListAppVersionResources.html
     */
    toListAppVersionResources() {
        return this.to('ListAppVersionResources');
    }
    /**
     * Grants permission to list application version
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListAppVersions.html
     */
    toListAppVersions() {
        return this.to('ListAppVersions');
    }
    /**
     * Grants permission to list applications
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListApps.html
     */
    toListApps() {
        return this.to('ListApps');
    }
    /**
     * Grants permission to list recommendation templates
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListRecommendationTemplates.html
     */
    toListRecommendationTemplates() {
        return this.to('ListRecommendationTemplates');
    }
    /**
     * Grants permission to list resiliency policies
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListResiliencyPolicies.html
     */
    toListResiliencyPolicies() {
        return this.to('ListResiliencyPolicies');
    }
    /**
     * Grants permission to list SOP recommendations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListSopRecommendations.html
     */
    toListSopRecommendations() {
        return this.to('ListSopRecommendations');
    }
    /**
     * Grants permission to list suggested resiliency policies
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListSuggestedResiliencyPolicies.html
     */
    toListSuggestedResiliencyPolicies() {
        return this.to('ListSuggestedResiliencyPolicies');
    }
    /**
     * Grants permission to list tags for a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to list test recommendations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListTestRecommendations.html
     */
    toListTestRecommendations() {
        return this.to('ListTestRecommendations');
    }
    /**
     * Grants permission to list unsupported application version resources
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListUnsupportedAppVersionResources.html
     */
    toListUnsupportedAppVersionResources() {
        return this.to('ListUnsupportedAppVersionResources');
    }
    /**
     * Grants permission to publish application version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_PublishAppVersion.html
     */
    toPublishAppVersion() {
        return this.to('PublishAppVersion');
    }
    /**
     * Grants permission to put draft application version template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_PutDraftAppVersionTemplate.html
     */
    toPutDraftAppVersionTemplate() {
        return this.to('PutDraftAppVersionTemplate');
    }
    /**
     * Grants permission to remove draft application version mappings
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_RemoveDraftAppVersionResourceMappings.html
     */
    toRemoveDraftAppVersionResourceMappings() {
        return this.to('RemoveDraftAppVersionResourceMappings');
    }
    /**
     * Grants permission to resolve application version resources
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - cloudformation:DescribeStacks
     * - cloudformation:ListStackResources
     * - resource-groups:GetGroup
     * - resource-groups:ListGroupResources
     * - servicecatalog:GetApplication
     * - servicecatalog:ListAssociatedResources
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ResolveAppVersionResources.html
     */
    toResolveAppVersionResources() {
        return this.to('ResolveAppVersionResources');
    }
    /**
     * Grants permission to create application assessment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - cloudformation:DescribeStacks
     * - cloudformation:ListStackResources
     * - cloudwatch:DescribeAlarms
     * - cloudwatch:GetMetricData
     * - cloudwatch:GetMetricStatistics
     * - cloudwatch:PutMetricData
     * - fis:GetExperimentTemplate
     * - fis:ListExperimentTemplates
     * - fis:ListExperiments
     * - resource-groups:GetGroup
     * - resource-groups:ListGroupResources
     * - servicecatalog:GetApplication
     * - servicecatalog:ListAssociatedResources
     * - ssm:GetParametersByPath
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_StartAppAssessment.html
     */
    toStartAppAssessment() {
        return this.to('StartAppAssessment');
    }
    /**
     * Grants permission to assign a resource tag
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to untag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_UpdateApp.html
     */
    toUpdateApp() {
        return this.to('UpdateApp');
    }
    /**
     * Grants permission to update resiliency policy
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_UpdateResiliencyPolicy.html
     */
    toUpdateResiliencyPolicy() {
        return this.to('UpdateResiliencyPolicy');
    }
    /**
     * Adds a resource of type resiliency-policy to the statement
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ResiliencyPolicy.html
     *
     * @param resiliencyPolicyID - Identifier for the resiliencyPolicyID.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onResiliencyPolicy(resiliencyPolicyID, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:resiliencehub:${region || '*'}:${account || '*'}:resiliency-policy/${resiliencyPolicyID}`);
    }
    /**
     * Adds a resource of type application to the statement
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_App.html
     *
     * @param appID - Identifier for the appID.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onApplication(appID, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:resiliencehub:${region || '*'}:${account || '*'}:app/${appID}`);
    }
    /**
     * Adds a resource of type app-assessment to the statement
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_AppAssessment.html
     *
     * @param appAssessmentID - Identifier for the appAssessmentID.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onAppAssessment(appAssessmentID, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:resiliencehub:${region || '*'}:${account || '*'}:app-assessment/${appAssessmentID}`);
    }
    /**
     * Adds a resource of type recommendation-template to the statement
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_RecommendationTemplate.html
     *
     * @param recommendationTemplateID - Identifier for the recommendationTemplateID.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onRecommendationTemplate(recommendationTemplateID, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:resiliencehub:${region || '*'}:${account || '*'}:recommendation-template/${recommendationTemplateID}`);
    }
}
exports.Resiliencehub = Resiliencehub;
_a = JSII_RTTI_SYMBOL_1;
Resiliencehub[_a] = { fqn: "iam-floyd.Resiliencehub", version: "0.327.0" };
//# sourceMappingURL=data:application/json;base64,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