import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [snow-device-management](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssnowdevicemanagement.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class SnowDeviceManagement extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [snow-device-management](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssnowdevicemanagement.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to cancel tasks on remote devices
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/snowcone-guide/sdms-cli-cancel-task.html
     */
    toCancelTask(): this;
    /**
     * Grants permission to create tasks on remote devices
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/snowball/latest/snowcone-guide/sdms-cli-create-task.html
     */
    toCreateTask(): this;
    /**
     * Grants permission to describe a remotely-managed device
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snowball/latest/snowcone-guide/sdms-cli-describe-device.html
     */
    toDescribeDevice(): this;
    /**
     * Grants permission to describe a remotely-managed device's EC2 instances
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snowball/latest/snowcone-guide/sdms-cli-describe-ec2-instances.html
     */
    toDescribeDeviceEc2Instances(): this;
    /**
     * Grants permission to describe task executions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snowball/latest/snowcone-guide/sdms-cli-describe-execution.html
     */
    toDescribeExecution(): this;
    /**
     * Grants permission to describe a task
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snowball/latest/snowcone-guide/sdms-cli-describe-task.html
     */
    toDescribeTask(): this;
    /**
     * Grants permission to list a remotely-managed device's resources
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/snowball/latest/snowcone-guide/sdms-cli-list-device-resources.html
     */
    toListDeviceResources(): this;
    /**
     * Grants permission to list remotely-managed devices
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/snowball/latest/snowcone-guide/sdms-cli-list-devices.html
     */
    toListDevices(): this;
    /**
     * Grants permission to list task executions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/snowball/latest/snowcone-guide/sdms-cli-list-executions.html
     */
    toListExecutions(): this;
    /**
     * Grants permission to list the tags for a resource (device or task)
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/snowball/latest/snowcone-guide/sdms-cli-list-tags-for-resource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to list tasks
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/snowball/latest/snowcone-guide/sdms-cli-list-tasks.html
     */
    toListTasks(): this;
    /**
     * Grants permission to tag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/snowball/latest/snowcone-guide/sdms-cli-tag-resource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to untag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/snowball/latest/snowcone-guide/sdms-cli-untag-resources.html
     */
    toUntagResource(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type managed-device to the statement
     *
     * https://docs.aws.amazon.com/snowball/latest/snowcone-guide/aws-sdms.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onManagedDevice(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type task to the statement
     *
     * https://docs.aws.amazon.com/snowball/latest/snowcone-guide/aws-sdms.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onTask(resourceId: string, account?: string, region?: string, partition?: string): this;
}
