# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['cfm_id']

package_data = \
{'': ['*']}

install_requires = \
['llvmlite>=0.34.0,<0.35.0', 'matchms>=0.9.2,<0.10.0', 'pandas>=1.3.4,<2.0.0']

entry_points = \
{'console_scripts': ['test = tests.cli:run']}

setup_kwargs = {
    'name': 'cfm-id',
    'version': '0.1.2',
    'description': 'A Python wrapper to use CFM-ID : https://cfmid.wishartlab.com',
    'long_description': '# CFM-ID Python Package\n\nThis package is a Python wrapper to use CFM-ID : https://cfmid.wishartlab.com\n\n> CFM-ID provides a method for accurately and efficiently identifying metabolites\n> in spectra generated by electrospray tandem mass spectrometry (ESI-MS/MS).\n> The program uses Competitive Fragmentation Modeling to produce a probabilistic generative model\n> for the MS/MS fragmentation process and machine learning techniques to adapt the model parameters from data.\n\nThis package is under devopment and work only for `cfm-predict` of the CFM-ID version 2.0.\n\n## Install\n\n```bash\npip install cfm-id\n```\n\n## Usage\n\n```python\nfrom cfm_id import CfmId\n\ncfm_id = CfmId("/path/to/cfm_id/folder")\ncfm_id.predict("O=C1OC(CO)C(O)=C1O")\n```\n\nThe default output format is a list of MatchMS [`Spectrum`](https://matchms.readthedocs.io/en/latest/api/matchms.Spectrum.html),\nincluding a "merged" spectrum of the 3 energies.\n\nYou can specify the CFM-ID raw text format export with the `raw_format` param :\n\n```python\ncfm_id.predict("O=C1OC(CO)C(O)=C1O", raw_format=True)\n```\n\n## Environement variable\n\nYou can also use environement variable `CFMID_PATH` rather than path argument.\n\n```bash\nexport CFMID_PATH=path/to/cfm_id/folder\n```\n\n```python\nfrom cfm_id import CfmId\n\ncfm_id = CfmId()\n```\n\n## Param and config files\n\nBy default `CfmId` will use `param_output.log`\xa0and `param_config.txt` files\nlocated at the root of the cfm_id folder as respectively param and config files.\n\nYou can specify anoter files location at instantiation with local path as ist of string :\n\n```python\nfrom cfm_id import CfmId\n\ncfm_id = CfmId(\n    "/path/to/cfm_id/folder",\n    param=["param", "param_output0_neg.log"], conf=["conf", "param_config_neg.txt"]\n)\n```\n\nIn this example, the `cfm_id` instance will use `/path/to/cfm_id/folder/param/param_output0_neg.log`\nas param file.\n\n## Use Docker image\n\nYou can use a Docker image for CFM-ID rather than local files by using `CfmIdDocker` class.\n\n```python\nfrom cfm_id import CfmIdDocker\n\ncfm_id = CfmIdDocker("myrepo/image_name:tag")\n```\n\nIn the Docker image, `cfm-predict` has to be in the PATH environement variable\nand `param_output.log`\xa0and `param_config.txt` files must be located at the working directory.\n\nYou can also use environement variable `CFMID_IMAGE` rather than path argument.\n\n```bash\nexport CFMID_IMAGE=myrepo/image_name:tag\n```\n\n```python\nfrom cfm_id import CfmIdDocker\n\ncfm_id = CfmIdDocker()\n```\n',
    'author': 'Yann Beauxis',
    'author_email': 'dev@yannbeauxis.net',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://gitlab.com/metwork/libs/cfm-id',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7.1,<4.0.0',
}


setup(**setup_kwargs)
