import os
from difflib import SequenceMatcher
from typing import Callable

from ...exceptions import OpenGameError

__all__ = ['backgrounds', 'sprites', 'sounds', 'load', 'resources', 'search', 'search_all']
_builtin = os.path.dirname(__file__)


class _ResourceClass(object):
    def __getitem__(self, item):
        return getattr(self, item)
    
    @classmethod
    def resources(cls):
        return resources(cls)
    
    @classmethod
    def search(cls, *args, **kwargs):
        return search(cls, *args, **kwargs)


class backgrounds(_ResourceClass):
    alps = os.path.join(_builtin, 'Alps.jpg')
    aurora = os.path.join(_builtin, 'aurora.jpg')
    autumn = os.path.join(_builtin, 'autumn.jpg')
    city = os.path.join(_builtin, 'city.png')
    coordinate = os.path.join(_builtin, 'coordinate.png')
    chrysanthemum = os.path.join(_builtin, 'chrysanthemum.jpg')
    dna = os.path.join(_builtin, 'DNA.jpg')
    dusk = os.path.join(_builtin, 'dusk.jpg')
    football = football_field = os.path.join(_builtin, 'football.png')
    forest = os.path.join(_builtin, 'forest.png')
    galaxy = os.path.join(_builtin, 'galaxy.png')
    green = os.path.join(_builtin, 'green.jpg')
    grid = os.path.join(_builtin, 'grid.png')
    hill = os.path.join(_builtin, 'hill.jpg')
    kitten = os.path.join(_builtin, 'kitten.jpg')
    party = os.path.join(_builtin, 'party.png')
    planet = os.path.join(_builtin, 'planet.png')
    rays = os.path.join(_builtin, 'rays.svg')
    sea1 = os.path.join(_builtin, 'sea1.jpg')
    sea2 = os.path.join(_builtin, 'sea2.jpg')
    sea3 = os.path.join(_builtin, 'sea3.jpg')
    sea4 = os.path.join(_builtin, 'sea4.gif')
    sky = os.path.join(_builtin, 'sky.png')
    solar = solar_system = os.path.join(_builtin, 'solar.png')
    stripes = os.path.join(_builtin, 'stripes.png')
    space = os.path.join(_builtin, 'space.png')
    tunnel = os.path.join(_builtin, 'tunnel.png')


class sprites(_ResourceClass):
    airplane1 = os.path.join(_builtin, 'airplane1.png')
    airplane2 = os.path.join(_builtin, 'airplane2.png')
    airplane3 = os.path.join(_builtin, 'airplane3.png')
    airplane4 = os.path.join(_builtin, 'airplane4.png')
    airplane5 = os.path.join(_builtin, 'airplane5.png')
    ant = os.path.join(_builtin, 'ant.png')
    apple = os.path.join(_builtin, 'apple.png')
    avocado = os.path.join(_builtin, 'avocado.png')
    balloon1 = os.path.join(_builtin, 'balloon1.png')
    balloon2 = os.path.join(_builtin, 'balloon2.png')
    bananas = os.path.join(_builtin, 'bananas.png')
    bam = os.path.join(_builtin, 'bam.png')
    bamboo = os.path.join(_builtin, 'bamboo.png')
    bamm = os.path.join(_builtin, 'bamm.png')
    bang1 = os.path.join(_builtin, 'bang1.png')
    bang2 = os.path.join(_builtin, 'bang2.png')
    baseball = os.path.join(_builtin, 'baseball.png')
    basketball = os.path.join(_builtin, 'basketball.png')
    bat = os.path.join(_builtin, 'bat.svg')
    beach_ball = os.path.join(_builtin, 'beach-ball.png')
    bear = os.path.join(_builtin, 'bear.png')
    beaver = os.path.join(_builtin, 'beaver.png')
    bee = os.path.join(_builtin, 'bee.png')
    beetle = os.path.join(_builtin, 'beetle.png')
    bell = os.path.join(_builtin, 'bell.png')
    bicycle = bike = os.path.join(_builtin, 'bicycle.png')
    bird1 = os.path.join(_builtin, 'bird1.png')
    bird2 = os.path.join(_builtin, 'bird2.png')
    bird3 = os.path.join(_builtin, 'bird3.png')
    bird4 = os.path.join(_builtin, 'bird4.png')
    blaaam = os.path.join(_builtin, 'blaaam.png')
    bomb = os.path.join(_builtin, 'bomb.png')
    boom = os.path.join(_builtin, 'boom.png')
    bulb_dark = os.path.join(_builtin, 'bulb-dark.png')
    bulb_light = os.path.join(_builtin, 'bulb-light.png')
    bullet = os.path.join(_builtin, 'bullet.png')
    bus = os.path.join(_builtin, 'bus.png')
    cactus = os.path.join(_builtin, 'cactus.png')
    cake = os.path.join(_builtin, 'cake.png')
    car1 = os.path.join(_builtin, 'car1.png')
    car2 = os.path.join(_builtin, 'car2.png')
    car3 = os.path.join(_builtin, 'car3.png')
    car4 = os.path.join(_builtin, 'car4.png')
    car5 = os.path.join(_builtin, 'car5.png')
    car6 = os.path.join(_builtin, 'car6.png')
    car7 = os.path.join(_builtin, 'car7.png')
    car8 = os.path.join(_builtin, 'car8.png')
    car9 = os.path.join(_builtin, 'car9.png')
    car10 = os.path.join(_builtin, 'car10.png')
    car11 = os.path.join(_builtin, 'car11.png')
    car12 = os.path.join(_builtin, 'car12.png')
    car13 = os.path.join(_builtin, 'car13.png')
    car14 = os.path.join(_builtin, 'car14.png')
    car15 = os.path.join(_builtin, 'car15.png')
    car16 = os.path.join(_builtin, 'car16.png')
    car17 = os.path.join(_builtin, 'car17.png')
    car18 = os.path.join(_builtin, 'car18.png')
    carrot = os.path.join(_builtin, 'carrot.png')
    cat = os.path.join(_builtin, 'cat.png')
    chick = os.path.join(_builtin, 'chick.png')
    chips = os.path.join(_builtin, 'chips.png')
    clip = os.path.join(_builtin, 'clip.png')
    cloud = os.path.join(_builtin, 'cloud.png')
    convertible = os.path.join(_builtin, 'convertible.png')
    corn = os.path.join(_builtin, 'corn.png')
    crab = os.path.join(_builtin, 'crab.png')
    crash = os.path.join(_builtin, 'crash.png')
    crocodile = os.path.join(_builtin, 'crocodile.png')
    crown = os.path.join(_builtin, 'crown.png')
    deer1 = os.path.join(_builtin, 'deer1.png')
    deer2 = os.path.join(_builtin, 'deer2.png')
    diamond1 = os.path.join(_builtin, 'diamond1.png')
    diamond2 = os.path.join(_builtin, 'diamond2.png')
    diamond3 = os.path.join(_builtin, 'diamond3.png')
    diamond4 = os.path.join(_builtin, 'diamond4.png')
    dog = os.path.join(_builtin, 'dog.png')
    donut = os.path.join(_builtin, 'donut.png')
    dolphin = os.path.join(_builtin, 'dolphin.png')
    doughnut = os.path.join(_builtin, 'doughnut.png')
    dragonfly = os.path.join(_builtin, 'dragonfly.png')
    drum = os.path.join(_builtin, 'drum.png')
    duck = os.path.join(_builtin, 'duck.png')
    durian = os.path.join(_builtin, 'durian.png')
    earthworm = os.path.join(_builtin, 'earthworm.png')
    eel = os.path.join(_builtin, 'eel.png')
    egg = os.path.join(_builtin, 'egg.png')
    eggplant = os.path.join(_builtin, 'eggplant.png')
    elephant1 = os.path.join(_builtin, 'elephant1.png')
    elephant2 = os.path.join(_builtin, 'elephant2.png')
    fire = os.path.join(_builtin, 'fire.png')
    fireworks = os.path.join(_builtin, 'fireworks.png')
    fish = os.path.join(_builtin, 'fish.png')
    flash = os.path.join(_builtin, 'flash.png')
    flower = os.path.join(_builtin, 'flower.png')
    forklift = os.path.join(_builtin, 'forklift.png')
    fox = os.path.join(_builtin, 'fox.png')
    frog = os.path.join(_builtin, 'frog.png')
    fryer = os.path.join(_builtin, 'fryer.png')
    gameover1 = os.path.join(_builtin, 'gameover1.png')
    gameover2 = os.path.join(_builtin, 'gameover2.png')
    gameover3 = os.path.join(_builtin, 'gameover3.png')
    gecko = os.path.join(_builtin, 'gecko.png')
    giraffe = os.path.join(_builtin, 'giraffe.png')
    goose = os.path.join(_builtin, 'goose.png')
    grape = os.path.join(_builtin, 'grape.png')
    grass1 = os.path.join(_builtin, 'grass1.png')
    grass2 = os.path.join(_builtin, 'grass2.png')
    grass3 = os.path.join(_builtin, 'grass3.png')
    hamburger = os.path.join(_builtin, 'hamburger.png')
    heart = os.path.join(_builtin, 'heart.png')
    hedgehog = os.path.join(_builtin, 'hedgehog.png')
    helicopter = os.path.join(_builtin, 'helicopter.png')
    hippo = os.path.join(_builtin, 'hippo.png')
    historic_building = os.path.join(_builtin, 'historic-building.png')
    horse = os.path.join(_builtin, 'horse.png')
    hot_air_balloon = os.path.join(_builtin, 'hot-air-balloon.png')
    hourglass = os.path.join(_builtin, 'hourglass.png')
    kiwi = os.path.join(_builtin, 'kiwi.png')
    koala = os.path.join(_builtin, 'koala.png')
    krack = os.path.join(_builtin, 'krack.png')
    ladybug = os.path.join(_builtin, 'ladybug.png')
    leaf = os.path.join(_builtin, 'leaf.png')
    lemon = os.path.join(_builtin, 'lemon.png')
    lion = os.path.join(_builtin, 'lion.png')
    lobster = os.path.join(_builtin, 'lobster.png')
    lock = os.path.join(_builtin, 'Lock1.png')
    locust = os.path.join(_builtin, 'locust.png')
    lollipop = os.path.join(_builtin, 'lollipop.png')
    mouse = os.path.join(_builtin, 'mouse.png')
    octopus = os.path.join(_builtin, 'octopus.png')
    oh_yeah = os.path.join(_builtin, 'oh-yeah.png')
    omg = os.path.join(_builtin, 'OMG.png')
    ooops = os.path.join(_builtin, 'ooops.png')
    orange = os.path.join(_builtin, 'orange.png')
    ostrich = os.path.join(_builtin, 'ostrich.png')
    owl = os.path.join(_builtin, 'owl.png')
    paddle = os.path.join(_builtin, 'paddle.png')
    pear = os.path.join(_builtin, 'pear.png')
    pencil = os.path.join(_builtin, 'pencil.png')
    penguin = os.path.join(_builtin, 'penguin.png')
    pepper = os.path.join(_builtin, 'pepper.png')
    pig = os.path.join(_builtin, 'pig.png')
    pizza = os.path.join(_builtin, 'pizza.png')
    potion = os.path.join(_builtin, 'potion.png')
    pooow = os.path.join(_builtin, 'pooow.png')
    right = os.path.join(_builtin, 'right.png')
    rhinoceros = os.path.join(_builtin, 'rhinoceros.png')
    rocket = os.path.join(_builtin, 'rocket.png')
    scratch_cat = os.path.join(_builtin, 'scratch-cat.png')
    snow = os.path.join(_builtin, 'snow.png')
    soccerball = os.path.join(_builtin, 'soccerball.png')
    star = os.path.join(_builtin, 'star.png')
    start_button = os.path.join(_builtin, 'start-button.png')
    strawberry = os.path.join(_builtin, 'strawberry.png')
    sun = os.path.join(_builtin, 'sun.png')
    sword = os.path.join(_builtin, 'sword.png')
    tennisball = os.path.join(_builtin, 'tennisball.png')
    tiger = os.path.join(_builtin, 'tiger.png')
    tomato = os.path.join(_builtin, 'tomato.png')
    tree = os.path.join(_builtin, 'tree.png')
    trophy = os.path.join(_builtin, 'trophy.png')
    turtle = os.path.join(_builtin, 'turtle.png')
    trampoline = os.path.join(_builtin, 'trampoline.png')
    trumpet = os.path.join(_builtin, 'trumpet.png')
    ufo = os.path.join(_builtin, 'UFO.png')
    walrus = os.path.join(_builtin, 'walrus.png')
    water_drop = os.path.join(_builtin, 'water-drop.png')
    watermelon1 = os.path.join(_builtin, 'watermelon1.png')
    watermelon2 = os.path.join(_builtin, 'watermelon2.png')
    whale = os.path.join(_builtin, 'whale.png')
    wow = os.path.join(_builtin, 'wow.png')
    wrong = os.path.join(_builtin, 'wrong.png')
    zebra = os.path.join(_builtin, 'zebra.png')


class sounds(_ResourceClass):
    boing = os.path.join(_builtin, 'boing.wav')
    bonk = os.path.join(_builtin, 'bonk.wav')
    bubble = bubbles = os.path.join(_builtin, 'bubbles.wav')
    clang = os.path.join(_builtin, 'clang.mp3')
    collect = os.path.join(_builtin, 'collect.wav')
    coin = os.path.join(_builtin, 'coin.wav')
    connect = os.path.join(_builtin, 'connect.wav')
    doorbell = os.path.join(_builtin, 'doorbell.wav')
    footstep = os.path.join(_builtin, 'footstep.wav')
    high_whoosh = os.path.join(_builtin, 'high-whoosh.wav')
    jump = os.path.join(_builtin, 'jump.wav')
    meow = os.path.join(_builtin, 'meow.wav')
    oops = os.path.join(_builtin, 'oops.wav')
    stone = os.path.join(_builtin, 'stone.wav')
    tada = os.path.join(_builtin, 'tada.wav')
    telephone = os.path.join(_builtin, 'telephone.wav')
    traffic = os.path.join(_builtin, 'traffic.wav')
    tropical_birds = os.path.join(_builtin, 'tropical-birds.wav')
    trumpet = os.path.join(_builtin, 'trumpet.wav')
    wand = os.path.join(_builtin, 'wand.wav')
    water_drop = os.path.join(_builtin, 'water-drop.wav')
    wobble = os.path.join(_builtin, 'wobble.wav')
    wolf = os.path.join(_builtin, 'wolf-howl.wav')
    win = os.path.join(_builtin, 'win.wav')
    whistle_thump = os.path.join(_builtin, 'whistle_thump.wav')
    whiz = os.path.join(_builtin, 'whiz.wav')
    pop = os.path.join(_builtin, 'pop.wav')
    pop_quietly = os.path.join(_builtin, 'pop-quietly.wav')
    xylo1 = os.path.join(_builtin, 'xylo1.wav')
    xylo2 = os.path.join(_builtin, 'xylo2.wav')
    xylo3 = os.path.join(_builtin, 'xylo3.wav')
    xylo4 = os.path.join(_builtin, 'xylo4.wav')
    ya = os.path.join(_builtin, 'ya.wav')
    zip = os.path.join(_builtin, 'zip.wav')
    
    
def load(name: str):
    res = getattr(sprites, name, None)
    if not res:
        res = getattr(sounds, name, None)
        if not res:
            res = getattr(backgrounds, name, None)
            if not res:
                raise OpenGameError('no resource found')
    return res


def resources(obj):
    d = dir(obj)
    res = {}
    for attr in d:
        if attr[0] == '_' or attr == 'resources':
            continue
        res[attr] = getattr(obj, attr)
    return res


_DEFAULT_IGNORE = 0.56
_DEFAULT_IGNORE_FUNC = lambda x: x < _DEFAULT_IGNORE


def search(obj, name: str, ignore: Callable[[float], bool] = _DEFAULT_IGNORE_FUNC, check_if_in: bool = True):
    resource = resources(obj)
    res = []
    for attr_name, attr_value in resource.items():
        x = round(SequenceMatcher(None, attr_name, name).ratio(), 2)
        if (check_if_in and (name in attr_name)) or (not ignore(x)):
            res.append((attr_name, attr_value, x))
    res.sort(key=lambda n: n[2])
    return res


def search_all(*args, **kwargs):
    res = []
    res.extend(search(backgrounds, *args, **kwargs))
    res.extend(search(sprites, *args, **kwargs))
    res.extend(search(sounds, *args, **kwargs))
    res.sort(key=lambda x: x[2])
    return res
