# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['symmetric', 'symmetric.cli', 'symmetric.openapi']

package_data = \
{'': ['*']}

install_requires = \
['flask>=1.1.1,<2.0.0']

entry_points = \
{'console_scripts': ['symmetric = symmetric.cli.core:dispatcher']}

setup_kwargs = {
    'name': 'symmetric',
    'version': '3.4.1',
    'description': 'A powerful yet lean wrapper over Flask to massively speed up API creations and enable super fast module-to-API transformations.',
    'long_description': '# Symmetric\n\n![PyPI - Version](https://img.shields.io/pypi/v/symmetric?style=for-the-badge&logo=python&color=306998&logoColor=%23fff&label=version)\n![PyPI - Downloads](https://img.shields.io/pypi/dm/symmetric?style=for-the-badge&logo=python&color=306998&logoColor=%23fff)\n\nA powerful yet lean wrapper over **[Flask](https://github.com/pallets/flask)** to massively speed up **[API](https://en.wikipedia.org/wiki/Web_API)** creations and enable super fast module-to-**[API](https://en.wikipedia.org/wiki/Web_API)** transformations.\n\n![Tests Workflow](https://img.shields.io/github/workflow/status/daleal/symmetric/tests?label=tests&logo=github&style=for-the-badge)\n![Linters Workflow](https://img.shields.io/github/workflow/status/daleal/symmetric/linters?label=linters&logo=github&style=for-the-badge)\n\n## Why Symmetric?\n\nRaw developing speed and ease of use, that\'s why. While `Flask` is a powerful tool to have, getting it to work from scratch can be a bit of a pain, especially if you have never used it before. The idea behind `symmetric` is to be able to take any module **already written** and transform it into a working API in a matter of minutes, instead of having to design the module ground-up to work with `Flask` (it can also be used to build an API from scratch really fast). With `symmetric`, you will also get some neat features, namely:\n\n- Auto logging.\n- Server-side error detection and exception handling.\n- Native support for an authentication token on a per-endpoint basis.\n- Auto-generated `/docs` endpoint for your API with **interactive documentation**.\n- Auto-generated [OpenAPI Specification](https://swagger.io/docs/specification/about/) and Markdown documentation files for your API.\n\nThe [complete documentation](https://symmetric.one/docs/basic-usage/) is available on the [official website](https://symmetric.one/).\n\n## Installing\n\nInstall using pip!\n\n```bash\npip install symmetric\n```\n\n## Usage\n\n### Running the development server\n\nTo start the development server, just run:\n\n```bash\nsymmetric run <module>\n```\n\nWhere `<module>` is your module name (in the examples, we will be writing in a file named `module.py`, so the module name will be just `module`). A `Flask` instance will be spawned immediately and can be reached at [http://127.0.0.1:5000](http://127.0.0.1:5000) by default. We don\'t have any endpoints yet, so we\'ll add some later. **Do not use this in production**. The `Flask` server is meant for development only. Instead, you can use any `WSGI` server to run the API. For example, to run the API using [gunicorn](https://gunicorn.org/), you just need to run `gunicorn module:symmetric` and a production ready server will be spawned.\n\n### Defining the API endpoints\n\nThe module consists of a main object called `symmetric`, which includes an important element: the `router` decorator. Let\'s analyze it:\n\n```py\nfrom symmetric import symmetric\n\n@symmetric.router("/some-route", methods=["post"], response_code=200, auth_token=False)\n```\n\nThe decorator recieves 4 arguments: the `route` argument (the endpoint of the API to which the decorated function will map), the `methods` argument (a list of the methods accepted to connect to that endpoint, defaults in only `POST` requests), the `response_code` argument (the response code of the endpoint if everything goes according to the plan. Defaults to `200`) and the `auth_token` argument (a boolean stating if the endpoint requires authentication using a `symmetric` token. Defaults to `False`).\n\nNow let\'s imagine that we have the following method:\n\n```py\ndef some_function():\n    """Greets the world."""\n    return "Hello World!"\n```\n\nTo transform that method into an API endpoint, all you need to do is add one line:\n\n```py\n@symmetric.router("/sample", methods=["get"])\ndef some_function():\n    """Greets the world."""\n    return "Hello World!"\n```\n\nRun `symmetric run module` and send a `GET` request to `http://127.0.0.1:5000/sample`. You should get a `Hello World!` in response! (To try it with a browser, make sure to run the above command and click [this link](http://127.0.0.1:5000/sample)).\n\nBut what about methods with arguments? Of course they can be API\'d too! Let\'s now say that you have the following function:\n\n```py\ndef another_function(a, b=372):\n    """\n    Adds :a and :b and returns the result of\n    that operation.\n    """\n    return a + b\n```\n\nTo transform that method into an API endpoint, all you need to do, again, is add one line:\n\n```py\n@symmetric.router("/add")\ndef another_function(a, b=372):\n    """\n    Adds :a and :b and returns the result of\n    that operation.\n    """\n    return a + b\n```\n\n### Querying API endpoints\n\nTo give parameters to a function, all we need to do is send a `json` body with the names of the parameters as keys. Let\'s see how! Run `symmetric run module` and send a `POST` request (the default `HTTP` method) to `http://127.0.0.1:5000/add`, now using the `requests` module.\n\n```python\nimport requests\n\npayload = {\n    "a": 48,\n    "b": 21\n}\nresponse = requests.post("http://127.0.0.1:5000/add", json=payload)\nprint(response.json())\n```\n\nWe got a `69` response! (`48 + 21 = 69`). Of course, you can return dictionaries from your methods and those will get returned as a `json` body in the response object **automagically**!\n\nWith this in mind, you can transform any existing project into a usable API very quickly!\n\n## ReDoc Documentation\n\nBy default, you can `GET` the `/docs` endpoint (using a browser) to access to **interactive auto-generated documentation** about your API. It will include request bodies for each endpoint, response codes, authentication required, default values, and much more!\n\n**Tip**: Given that the [ReDoc Documentation](https://github.com/Redocly/redoc) is based on the OpenAPI standard, using **type annotations** in your code will result in a more detailed interactive documentation. Instead of the parameters being allowed to be any type, they will be forced into the type declared in your code. Cool, right?\n\n## Developing\n\nClone the repository:\n\n```bash\ngit clone https://github.com/daleal/symmetric.git\n\ncd symmetric\n```\n\nRecreate environment:\n\n```bash\n./environment.sh\n\n. .venv/bin/activate\n```\n\nTest install:\n\n```bash\npoetry install  # will also install the symmetric CLI\n```\n\nRun the tests:\n\n```bash\npython -m unittest\n```\n\n## Resources\n\n- [Official Website](https://symmetric.one/)\n- [Issue Tracker](https://github.com/daleal/symmetric/issues/)\n',
    'author': 'Daniel Leal',
    'author_email': 'dlleal@uc.cl',
    'maintainer': 'Daniel Leal',
    'maintainer_email': 'dlleal@uc.cl',
    'url': 'https://symmetric.one/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
