"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Awsconnector = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [awsconnector](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsconnectorservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Awsconnector extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [awsconnector](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsconnectorservice.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'awsconnector';
        this.accessLevelList = {
            Read: [
                'GetConnectorHealth',
                'ValidateConnectorId'
            ],
            Write: [
                'RegisterConnector'
            ]
        };
    }
    /**
     * Retrieves all health metrics that were published from the Server Migration Connector.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/userguide/prereqs.html#connector-permissions
     */
    toGetConnectorHealth() {
        return this.to('GetConnectorHealth');
    }
    /**
     * Registers AWS Connector with AWS Connector Service.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/userguide/prereqs.html#connector-permissions
     */
    toRegisterConnector() {
        return this.to('RegisterConnector');
    }
    /**
     * Validates Server Migration Connector Id that was registered with AWS Connector Service.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/server-migration-service/latest/userguide/prereqs.html#connector-permissions
     */
    toValidateConnectorId() {
        return this.to('ValidateConnectorId');
    }
}
exports.Awsconnector = Awsconnector;
_a = JSII_RTTI_SYMBOL_1;
Awsconnector[_a] = { fqn: "iam-floyd.Awsconnector", version: "0.448.0" };
//# sourceMappingURL=data:application/json;base64,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