"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Controltower = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [controltower](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscontroltower.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Controltower extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [controltower](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscontroltower.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'controltower';
        this.accessLevelList = {
            Write: [
                'CreateManagedAccount',
                'DeregisterManagedAccount',
                'DeregisterOrganizationalUnit',
                'DisableControl',
                'DisableGuardrail',
                'EnableControl',
                'EnableGuardrail',
                'ManageOrganizationalUnit',
                'SetupLandingZone',
                'UpdateAccountFactoryConfig'
            ],
            Read: [
                'DescribeAccountFactoryConfig',
                'DescribeCoreService',
                'DescribeGuardrail',
                'DescribeGuardrailForTarget',
                'DescribeManagedAccount',
                'DescribeManagedOrganizationalUnit',
                'DescribeSingleSignOn',
                'GetAvailableUpdates',
                'GetControlOperation',
                'GetGuardrailComplianceStatus',
                'GetHomeRegion',
                'GetLandingZoneStatus'
            ],
            List: [
                'ListDirectoryGroups',
                'ListEnabledControls',
                'ListEnabledGuardrails',
                'ListGuardrailViolations',
                'ListGuardrails',
                'ListGuardrailsForTarget',
                'ListManagedAccounts',
                'ListManagedAccountsForGuardrail',
                'ListManagedAccountsForParent',
                'ListManagedOrganizationalUnits',
                'ListManagedOrganizationalUnitsForGuardrail'
            ]
        };
    }
    /**
     * Grants permission to create an account managed by AWS Control Tower
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     */
    toCreateManagedAccount() {
        return this.to('CreateManagedAccount');
    }
    /**
     * Grants permission to deregister an account created through the account factory from AWS Control Tower
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     */
    toDeregisterManagedAccount() {
        return this.to('DeregisterManagedAccount');
    }
    /**
     * Grants permission to deregister an organizational unit from AWS Control Tower management
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/organizations.html
     */
    toDeregisterOrganizationalUnit() {
        return this.to('DeregisterOrganizationalUnit');
    }
    /**
     * Grants permission to describe the current account factory configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     */
    toDescribeAccountFactoryConfig() {
        return this.to('DescribeAccountFactoryConfig');
    }
    /**
     * Grants permission to describe resources managed by core accounts in AWS Control Tower
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/how-control-tower-works.html#what-shared
     */
    toDescribeCoreService() {
        return this.to('DescribeCoreService');
    }
    /**
     * Grants permission to describe a guardrail
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/guardrails.html
     */
    toDescribeGuardrail() {
        return this.to('DescribeGuardrail');
    }
    /**
     * Grants permission to describe a guardrail for a organizational unit
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/guardrails.html
     */
    toDescribeGuardrailForTarget() {
        return this.to('DescribeGuardrailForTarget');
    }
    /**
     * Grants permission to describe an account created through account factory
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     */
    toDescribeManagedAccount() {
        return this.to('DescribeManagedAccount');
    }
    /**
     * Grants permission to describe an AWS Organizations organizational unit managed by AWS Control Tower
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/organizations.html
     */
    toDescribeManagedOrganizationalUnit() {
        return this.to('DescribeManagedOrganizationalUnit');
    }
    /**
     * Grants permission to describe the current AWS Control Tower SSO configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/sso.html
     */
    toDescribeSingleSignOn() {
        return this.to('DescribeSingleSignOn');
    }
    /**
     * Grants permission to remove a control from an organizational unit
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/APIReference/API_DisableControl.html
     */
    toDisableControl() {
        return this.to('DisableControl');
    }
    /**
     * Grants permission to disable a guardrail from an organizational unit
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/guardrails.html#enable-guardrails
     */
    toDisableGuardrail() {
        return this.to('DisableGuardrail');
    }
    /**
     * Grants permission to activate a control for an organizational unit
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/APIReference/API_EnableControl.html
     */
    toEnableControl() {
        return this.to('EnableControl');
    }
    /**
     * Grants permission to enable a guardrail to an organizational unit
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/guardrails.html#enable-guardrails
     */
    toEnableGuardrail() {
        return this.to('EnableGuardrail');
    }
    /**
     * Grants permission to list available updates for the current AWS Control Tower deployment
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/configuration-updates.html
     */
    toGetAvailableUpdates() {
        return this.to('GetAvailableUpdates');
    }
    /**
     * Grants permission to get the current status of a particular EnabledControl or DisableControl operation
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/APIReference/API_GetControlOperation.html
     */
    toGetControlOperation() {
        return this.to('GetControlOperation');
    }
    /**
     * Grants permission to get the current compliance status of a guardrail
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/guardrails.html
     */
    toGetGuardrailComplianceStatus() {
        return this.to('GetGuardrailComplianceStatus');
    }
    /**
     * Grants permission to get the home region of the AWS Control Tower setup
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/how-control-tower-works.html#region-how
     */
    toGetHomeRegion() {
        return this.to('GetHomeRegion');
    }
    /**
     * Grants permission to get the current status of the landing zone setup
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/getting-started-with-control-tower.html#step-two
     */
    toGetLandingZoneStatus() {
        return this.to('GetLandingZoneStatus');
    }
    /**
     * Grants permission to list the current directory groups available through SSO
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/sso.html
     */
    toListDirectoryGroups() {
        return this.to('ListDirectoryGroups');
    }
    /**
     * Grants permission to list all enabled controls in a specified organizational unit
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/APIReference/API_ListEnabledControls.html
     */
    toListEnabledControls() {
        return this.to('ListEnabledControls');
    }
    /**
     * Grants permission to list currently enabled guardrails
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/guardrails.html
     */
    toListEnabledGuardrails() {
        return this.to('ListEnabledGuardrails');
    }
    /**
     * Grants permission to list existing guardrail violations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/guardrails.html
     */
    toListGuardrailViolations() {
        return this.to('ListGuardrailViolations');
    }
    /**
     * Grants permission to list all available guardrails
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/guardrails.html
     */
    toListGuardrails() {
        return this.to('ListGuardrails');
    }
    /**
     * Grants permission to list guardrails and their current state for a organizational unit
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/guardrails.html
     */
    toListGuardrailsForTarget() {
        return this.to('ListGuardrailsForTarget');
    }
    /**
     * Grants permission to list accounts managed through AWS Control Tower
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     */
    toListManagedAccounts() {
        return this.to('ListManagedAccounts');
    }
    /**
     * Grants permission to list managed accounts with a specified guardrail applied
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     */
    toListManagedAccountsForGuardrail() {
        return this.to('ListManagedAccountsForGuardrail');
    }
    /**
     * Grants permission to list managed accounts under an organizational unit
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     */
    toListManagedAccountsForParent() {
        return this.to('ListManagedAccountsForParent');
    }
    /**
     * Grants permission to list organizational units managed by AWS Control Tower
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/organizations.html
     */
    toListManagedOrganizationalUnits() {
        return this.to('ListManagedOrganizationalUnits');
    }
    /**
     * Grants permission to list managed organizational units that have a specified guardrail applied
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/organizations.html
     */
    toListManagedOrganizationalUnitsForGuardrail() {
        return this.to('ListManagedOrganizationalUnitsForGuardrail');
    }
    /**
     * Grants permission to set up an organizational unit to be managed by AWS Control Tower
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/organizations.html
     */
    toManageOrganizationalUnit() {
        return this.to('ManageOrganizationalUnit');
    }
    /**
     * Grants permission to set up or update AWS Control Tower landing zone
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/getting-started-with-control-tower.html#step-two
     */
    toSetupLandingZone() {
        return this.to('SetupLandingZone');
    }
    /**
     * Grants permission to update the account factory configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/controltower/latest/userguide/account-factory.html
     */
    toUpdateAccountFactoryConfig() {
        return this.to('UpdateAccountFactoryConfig');
    }
}
exports.Controltower = Controltower;
_a = JSII_RTTI_SYMBOL_1;
Controltower[_a] = { fqn: "iam-floyd.Controltower", version: "0.448.0" };
//# sourceMappingURL=data:application/json;base64,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