"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Supportapp = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [supportapp](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupportappforslack.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Supportapp extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [supportapp](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupportappforslack.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'supportapp';
        this.accessLevelList = {
            Write: [
                'CreateSlackChannelConfiguration',
                'DeleteAccountAlias',
                'DeleteSlackChannelConfiguration',
                'DeleteSlackWorkspaceConfiguration',
                'PutAccountAlias',
                'RegisterSlackWorkspaceForOrganization',
                'UpdateSlackChannelConfiguration'
            ],
            Read: [
                'GetAccountAlias',
                'ListSlackChannelConfigurations',
                'ListSlackWorkspaceConfigurations'
            ]
        };
    }
    /**
     * Grants permission to create a Slack channel configuration for your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/supportapp/latest/APIReference/API_CreateSlackChannelConfiguration.html
     */
    toCreateSlackChannelConfiguration() {
        return this.to('CreateSlackChannelConfiguration');
    }
    /**
     * Grants permission to delete an alias from your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/supportapp/latest/APIReference/API_DeleteAccountAlias.html
     */
    toDeleteAccountAlias() {
        return this.to('DeleteAccountAlias');
    }
    /**
     * Grants permission to delete a Slack channel configuration from your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/supportapp/latest/APIReference/API_DeleteSlackChannelConfiguration.html
     */
    toDeleteSlackChannelConfiguration() {
        return this.to('DeleteSlackChannelConfiguration');
    }
    /**
     * Grants permission to delete a Slack workspace configuration from your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/supportapp/latest/APIReference/API_DeleteSlackWorkspaceConfiguration.html
     */
    toDeleteSlackWorkspaceConfiguration() {
        return this.to('DeleteSlackWorkspaceConfiguration');
    }
    /**
     * Grants permission to get the alias for your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/supportapp/latest/APIReference/API_GetAccountAlias.html
     */
    toGetAccountAlias() {
        return this.to('GetAccountAlias');
    }
    /**
     * Grants permission to list all Slack channel configurations for your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/supportapp/latest/APIReference/API_ListSlackChannelConfigurations.html
     */
    toListSlackChannelConfigurations() {
        return this.to('ListSlackChannelConfigurations');
    }
    /**
     * Grants permission to list all Slack workspace configurations for your account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/supportapp/latest/APIReference/API_ListSlackWorkspaceConfigurations.html
     */
    toListSlackWorkspaceConfigurations() {
        return this.to('ListSlackWorkspaceConfigurations');
    }
    /**
     * Grants permission to create or update an alias for your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/supportapp/latest/APIReference/API_PutAccountAlias.html
     */
    toPutAccountAlias() {
        return this.to('PutAccountAlias');
    }
    /**
     * Grants permission to register a Slack workspace for an AWS account that is part of an organization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/supportapp/latest/APIReference/API_RegisterSlackWorkspaceForOrganization.html
     */
    toRegisterSlackWorkspaceForOrganization() {
        return this.to('RegisterSlackWorkspaceForOrganization');
    }
    /**
     * Grants permission to update a Slack channel configuration for your account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/supportapp/latest/APIReference/API_UpdateSlackChannelConfiguration.html
     */
    toUpdateSlackChannelConfiguration() {
        return this.to('UpdateSlackChannelConfiguration');
    }
}
exports.Supportapp = Supportapp;
_a = JSII_RTTI_SYMBOL_1;
Supportapp[_a] = { fqn: "iam-floyd.Supportapp", version: "0.448.0" };
//# sourceMappingURL=data:application/json;base64,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