import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [supportplans](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupportplans.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Supportplans extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [supportplans](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssupportplans.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to view details about the current support plan for this AWS account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-support-plans.html
     */
    toGetSupportPlan(): this;
    /**
     * Grants permission to view details about the status for a request to update a support plan
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-support-plans.html
     */
    toGetSupportPlanUpdateStatus(): this;
    /**
     * Grants permission to update the support plan for this AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-support-plans.html
     */
    toStartSupportPlanUpdate(): this;
    protected accessLevelList: AccessLevelList;
}
