"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Tiros = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [tiros](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awstiros.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Tiros extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [tiros](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awstiros.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'tiros';
        this.accessLevelList = {
            Write: [
                'CreateQuery',
                'ExtendQuery'
            ],
            Read: [
                'GetQueryAnswer',
                'GetQueryExplanation',
                'GetQueryExtensionAccounts'
            ]
        };
    }
    /**
     * Grants permission to create a VPC reachability query
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/vpc/latest/reachability/security_iam_required-API-permissions.html
     */
    toCreateQuery() {
        return this.to('CreateQuery');
    }
    /**
     * Grants permission to extend a VPC reachability query to include the calling principals account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/vpc/latest/reachability/security_iam_required-API-permissions.html
     */
    toExtendQuery() {
        return this.to('ExtendQuery');
    }
    /**
     * Grants permission to get VPC reachability query answers
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/vpc/latest/reachability/security_iam_required-API-permissions.html
     */
    toGetQueryAnswer() {
        return this.to('GetQueryAnswer');
    }
    /**
     * Grants permission to get VPC reachability query explanations
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/vpc/latest/reachability/security_iam_required-API-permissions.html
     */
    toGetQueryExplanation() {
        return this.to('GetQueryExplanation');
    }
    /**
     * Grants permission to list accounts that might be useful in a new query
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/vpc/latest/reachability/security_iam_required-API-permissions.html
     */
    toGetQueryExtensionAccounts() {
        return this.to('GetQueryExtensionAccounts');
    }
}
exports.Tiros = Tiros;
_a = JSII_RTTI_SYMBOL_1;
Tiros[_a] = { fqn: "iam-floyd.Tiros", version: "0.448.0" };
//# sourceMappingURL=data:application/json;base64,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