# mypy-boto3-accessanalyzer<a id="mypy-boto3-accessanalyzer"></a>

[![PyPI - mypy-boto3-accessanalyzer](https://img.shields.io/pypi/v/mypy-boto3-accessanalyzer.svg?color=blue)](https://pypi.org/project/mypy-boto3-accessanalyzer)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-accessanalyzer.svg?color=blue)](https://pypi.org/project/mypy-boto3-accessanalyzer)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-accessanalyzer?color=blue)](https://pypistats.org/packages/mypy-boto3-accessanalyzer)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.AccessAnalyzer 1.17.90](https://boto3.amazonaws.com/v1/documentation/api/1.17.90/reference/services/accessanalyzer.html#AccessAnalyzer)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-buider 4.15.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-accessanalyzer docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_accessanalyzer/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-accessanalyzer](#mypy-boto3-accessanalyzer)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

## How to install<a id="how-to-install"></a>

Install `boto3-stubs` for `AccessAnalyzer` service.

```bash
python -m pip install boto3-stubs[accessanalyzer]
```

## Usage<a id="usage"></a>

### VSCode<a id="vscode"></a>

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[accessanalyzer]` in your environment:
  `python -m pip install 'boto3-stubs[accessanalyzer]'`

Both type checking and auto-complete should work for `AccessAnalyzer` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm<a id="pycharm"></a>

- Install `boto-stubs[accessanalyzer]` in your environment:
  `python -m pip install 'boto3-stubs[accessanalyzer]'`

Both type checking and auto-complete should work for `AccessAnalyzer` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

### Other IDEs<a id="other-ides"></a>

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

### mypy<a id="mypy"></a>

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[accessanalyzer]` in your environment:
  `python -m pip install 'boto3-stubs[accessanalyzer]'`
- Run `mypy` as usual

Type checking should work for `AccessAnalyzer` service. No explicit type
annotations required, write your `boto3` code as usual.

### pyright<a id="pyright"></a>

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[accessanalyzer]` in your environment:
  `python -m pip install 'boto3-stubs[accessanalyzer]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `AccessAnalyzer` service. No explicit type
annotations required, write your `boto3` code as usual.

## Explicit type annotations<a id="explicit-type-annotations"></a>

### Client annotations<a id="client-annotations"></a>

`AccessAnalyzerClient` provides annotations for
`boto3.client("accessanalyzer")`.

```python
import boto3

from mypy_boto3_accessanalyzer import AccessAnalyzerClient

client: AccessAnalyzerClient = boto3.client("accessanalyzer")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: AccessAnalyzerClient = session.client("accessanalyzer")
```

### Paginators annotations<a id="paginators-annotations"></a>

`mypy_boto3_accessanalyzer.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_accessanalyzer import AccessAnalyzerClient
from mypy_boto3_accessanalyzer.paginator import (
    ListAccessPreviewFindingsPaginator,
    ListAccessPreviewsPaginator,
    ListAnalyzedResourcesPaginator,
    ListAnalyzersPaginator,
    ListArchiveRulesPaginator,
    ListFindingsPaginator,
    ListPolicyGenerationsPaginator,
    ValidatePolicyPaginator,
)

client: AccessAnalyzerClient = boto3.client("accessanalyzer")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_access_preview_findings_paginator: ListAccessPreviewFindingsPaginator = client.get_paginator("list_access_preview_findings")
list_access_previews_paginator: ListAccessPreviewsPaginator = client.get_paginator("list_access_previews")
list_analyzed_resources_paginator: ListAnalyzedResourcesPaginator = client.get_paginator("list_analyzed_resources")
list_analyzers_paginator: ListAnalyzersPaginator = client.get_paginator("list_analyzers")
list_archive_rules_paginator: ListArchiveRulesPaginator = client.get_paginator("list_archive_rules")
list_findings_paginator: ListFindingsPaginator = client.get_paginator("list_findings")
list_policy_generations_paginator: ListPolicyGenerationsPaginator = client.get_paginator("list_policy_generations")
validate_policy_paginator: ValidatePolicyPaginator = client.get_paginator("validate_policy")
```

### Literals<a id="literals"></a>

`mypy_boto3_accessanalyzer.literals` module contains literals extracted from
shapes that can be used in user code for type checking.

```python
from mypy_boto3_accessanalyzer.literals import (
    AccessPreviewStatusReasonCodeType,
    AccessPreviewStatusType,
    AclPermissionType,
    AnalyzerStatusType,
    FindingChangeTypeType,
    FindingSourceTypeType,
    FindingStatusType,
    FindingStatusUpdateType,
    JobErrorCodeType,
    JobStatusType,
    KmsGrantOperationType,
    ListAccessPreviewFindingsPaginatorName,
    ListAccessPreviewsPaginatorName,
    ListAnalyzedResourcesPaginatorName,
    ListAnalyzersPaginatorName,
    ListArchiveRulesPaginatorName,
    ListFindingsPaginatorName,
    ListPolicyGenerationsPaginatorName,
    LocaleType,
    OrderByType,
    PolicyTypeType,
    ReasonCodeType,
    ResourceTypeType,
    TypeType,
    ValidatePolicyFindingTypeType,
    ValidatePolicyPaginatorName,
)

def check_value(value: AccessPreviewStatusReasonCodeType) -> bool:
    ...
```

### Typed dictionaries<a id="typed-dictionaries"></a>

`mypy_boto3_accessanalyzer.type_defs` module contains structures and shapes
assembled to typed dictionaries for additional type checking.

```python
from mypy_boto3_accessanalyzer.type_defs import (
    AccessPreviewFindingTypeDef,
    AccessPreviewStatusReasonTypeDef,
    AccessPreviewSummaryTypeDef,
    AccessPreviewTypeDef,
    AclGranteeTypeDef,
    AnalyzedResourceSummaryTypeDef,
    AnalyzedResourceTypeDef,
    AnalyzerSummaryTypeDef,
    ArchiveRuleSummaryTypeDef,
    CloudTrailDetailsTypeDef,
    CloudTrailPropertiesTypeDef,
    ConfigurationTypeDef,
    CreateAccessPreviewResponseTypeDef,
    CreateAnalyzerResponseTypeDef,
    CriterionTypeDef,
    FindingSourceDetailTypeDef,
    FindingSourceTypeDef,
    FindingSummaryTypeDef,
    FindingTypeDef,
    GeneratedPolicyPropertiesTypeDef,
    GeneratedPolicyResultTypeDef,
    GeneratedPolicyTypeDef,
    GetAccessPreviewResponseTypeDef,
    GetAnalyzedResourceResponseTypeDef,
    GetAnalyzerResponseTypeDef,
    GetArchiveRuleResponseTypeDef,
    GetFindingResponseTypeDef,
    GetGeneratedPolicyResponseTypeDef,
    IamRoleConfigurationTypeDef,
    InlineArchiveRuleTypeDef,
    JobDetailsTypeDef,
    JobErrorTypeDef,
    KmsGrantConfigurationTypeDef,
    KmsGrantConstraintsTypeDef,
    KmsKeyConfigurationTypeDef,
    ListAccessPreviewFindingsResponseTypeDef,
    ListAccessPreviewsResponseTypeDef,
    ListAnalyzedResourcesResponseTypeDef,
    ListAnalyzersResponseTypeDef,
    ListArchiveRulesResponseTypeDef,
    ListFindingsResponseTypeDef,
    ListPolicyGenerationsResponseTypeDef,
    ListTagsForResourceResponseTypeDef,
    LocationTypeDef,
    NetworkOriginConfigurationTypeDef,
    PaginatorConfigTypeDef,
    PathElementTypeDef,
    PolicyGenerationDetailsTypeDef,
    PolicyGenerationTypeDef,
    PositionTypeDef,
    S3AccessPointConfigurationTypeDef,
    S3BucketAclGrantConfigurationTypeDef,
    S3BucketConfigurationTypeDef,
    S3PublicAccessBlockConfigurationTypeDef,
    SecretsManagerSecretConfigurationTypeDef,
    SortCriteriaTypeDef,
    SpanTypeDef,
    SqsQueueConfigurationTypeDef,
    StartPolicyGenerationResponseTypeDef,
    StatusReasonTypeDef,
    SubstringTypeDef,
    TrailPropertiesTypeDef,
    TrailTypeDef,
    ValidatePolicyFindingTypeDef,
    ValidatePolicyResponseTypeDef,
    VpcConfigurationTypeDef,
)

def get_structure() -> AccessPreviewFindingTypeDef:
    return {
      ...
    }
```

## Versioning<a id="versioning"></a>

`mypy-boto3-accessanalyzer` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

## Documentation<a id="documentation"></a>

All type annotations can be found in
[mypy-boto3-accessanalyzer docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_accessanalyzer/)

## Support and contributing<a id="support-and-contributing"></a>

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
