"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MetaflowApi = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const apigw = require("@aws-cdk/aws-apigateway");
const logs = require("@aws-cdk/aws-logs");
const cdk = require("@aws-cdk/core");
/**
 * @experimental
 * @summary Metaflow Api
 */
class MetaflowApi extends cdk.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        const logGroup = new logs.LogGroup(this, 'api-logs', {
            logGroupName: cdk.Aws.STACK_NAME + '-api',
            removalPolicy: cdk.RemovalPolicy.DESTROY,
        });
        this.api = new apigw.RestApi(this, 'api', {
            endpointConfiguration: {
                types: [apigw.EndpointType.EDGE],
            },
            deployOptions: {
                metricsEnabled: true,
                accessLogDestination: new apigw.LogGroupLogDestination(logGroup),
                loggingLevel: apigw.MethodLoggingLevel.INFO,
                dataTraceEnabled: true,
                tracingEnabled: true,
                stageName: 'api',
            },
        });
        const link = new apigw.VpcLink(cdk.Stack.of(this), 'gatewayLink', {
            targets: [props.nlb],
            vpcLinkName: 'apiGatewayECSLink',
        });
        const dbIntegration = new apigw.Integration({
            type: apigw.IntegrationType.HTTP_PROXY,
            options: {
                connectionType: apigw.ConnectionType.VPC_LINK,
                vpcLink: link,
                passthroughBehavior: apigw.PassthroughBehavior.WHEN_NO_MATCH,
                integrationResponses: [
                    {
                        statusCode: '200',
                    },
                ],
            },
            integrationHttpMethod: 'GET',
            uri: `http://${props.nlb.loadBalancerDnsName}:8082/db_schema_status`,
        });
        const apiIntegration = new apigw.Integration({
            type: apigw.IntegrationType.HTTP_PROXY,
            options: {
                connectionType: apigw.ConnectionType.VPC_LINK,
                vpcLink: link,
                passthroughBehavior: apigw.PassthroughBehavior.WHEN_NO_MATCH,
                cacheKeyParameters: ['method.request.path.proxy'],
                requestParameters: {
                    'integration.request.path.proxy': 'method.request.path.proxy',
                },
                integrationResponses: [
                    {
                        statusCode: '200',
                    },
                ],
            },
            integrationHttpMethod: 'ANY',
            uri: `http://${props.nlb.loadBalancerDnsName}/{proxy}`,
        });
        const resource = this.api.root.addResource('{proxy+}');
        resource.addMethod('ANY', apiIntegration, {
            requestParameters: {
                'method.request.path.proxy': true,
            },
        });
        const dbResource = this.api.root.addResource('db_schema_status');
        dbResource.addMethod('GET', dbIntegration, {
            authorizationType: apigw.AuthorizationType.NONE,
        });
    }
}
exports.MetaflowApi = MetaflowApi;
_a = JSII_RTTI_SYMBOL_1;
MetaflowApi[_a] = { fqn: "cdk-metaflow.MetaflowApi", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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