"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MetaflowTable = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ddb = require("@aws-cdk/aws-dynamodb");
const cdk = require("@aws-cdk/core");
const defaults = {
    billingMode: ddb.BillingMode.PAY_PER_REQUEST,
    removalPolicy: cdk.RemovalPolicy.DESTROY,
    pointInTimeRecovery: true,
    partitionKey: {
        name: 'pathspec',
        type: ddb.AttributeType.STRING,
    },
    timeToLiveAttribute: 'ttl',
};
/**
 * @experimental
 * @summary Metaflow DynamoDB Table
 * This may be going away entirely because I'm not sure that
 * ddb is necessary to manage state with dynamo with the recent support
 * for strong read-after-write consistency.
 */
class MetaflowTable extends ddb.Table {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id, { ...defaults, ...props });
        this.resource = this.node.findChild('Resource');
    }
}
exports.MetaflowTable = MetaflowTable;
_a = JSII_RTTI_SYMBOL_1;
MetaflowTable[_a] = { fqn: "cdk-metaflow.MetaflowTable", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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