"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MetaflowExports = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ssm = require("@aws-cdk/aws-ssm");
const cdk = require("@aws-cdk/core");
/**
 * @experimental
 * @summary Metaflow Nlb
 */
class MetaflowExports extends cdk.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        const exports = {
            'METAFLOW-BATCH-JOB-QUEUE': `arn:${cdk.Aws.PARTITION}:batch:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:job-queue/jobs`,
            'METAFLOW-DATASTORE-SYSROOT-S3': `s3://${props.bucketName}/metaflow`,
            'METAFLOW-DATATOOLS-SYSROOT-S3': `s3://${props.bucketName}/data`,
            'METAFLOW-DEFAULT-DATASTORE': 's3',
            'METAFLOW-DEFAULT-METADATA': 'service',
            'METAFLOW-ECS-S3-ACCESS-IAM-ROLE': props.batchS3TaskRoleArn,
            'METAFLOW-EVENTS-SFN-ACCESS-IAM-ROLE': props.eventBridgeRoleArn,
            'METAFLOW-SERVICE-INTERNAL-URL': `http://${props.nlbDnsName}/`,
            'METAFLOW-SERVICE-URL': `http://${props.nlbDnsName}/api`,
            'METAFLOW-SFN-DYNAMO-DB-TABLE': props.tableName,
            'METAFLOW-SFN-IAM-ROLE': props.stepFunctionsRoleArn,
        };
        let k;
        for (k in exports) {
            const v = exports[k];
            new cdk.CfnOutput(this, `${k}Output`, {
                exportName: k,
                value: v,
            });
            new ssm.StringParameter(this, `${k}Param`, {
                parameterName: k,
                stringValue: v,
                type: ssm.ParameterType.STRING,
            });
        }
    }
}
exports.MetaflowExports = MetaflowExports;
_a = JSII_RTTI_SYMBOL_1;
MetaflowExports[_a] = { fqn: "cdk-metaflow.MetaflowExports", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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