"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MetaflowFargateService = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("@aws-cdk/aws-ec2");
const ecs = require("@aws-cdk/aws-ecs");
const cdk = require("@aws-cdk/core");
const constants_1 = require("./constants");
/**
 * @experimental
 */
class MetaflowFargateService extends cdk.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.fargateTaskDefinition = new ecs.FargateTaskDefinition(this, 'metaflow-fargate-task-definition', {
            family: constants_1.ServiceInfo.SERVICE_NAME,
            cpu: Number(constants_1.ServiceInfo.CONTAINER_CPU),
            memoryLimitMiB: Number(constants_1.ServiceInfo.CONTAINER_MEMORY),
            executionRole: props.executionRole,
            taskRole: props.taskRole,
        });
        this.fargateTaskDefinition.addContainer('metadata-service', {
            containerName: constants_1.ServiceInfo.SERVICE_NAME,
            image: ecs.ContainerImage.fromRegistry(constants_1.ServiceInfo.IMAGE_URL),
            cpu: Number(constants_1.ServiceInfo.CONTAINER_CPU),
            memoryLimitMiB: Number(constants_1.ServiceInfo.CONTAINER_MEMORY),
            portMappings: [
                {
                    containerPort: Number(constants_1.ServiceInfo.CONTAINER_PORT),
                    hostPort: Number(constants_1.ServiceInfo.CONTAINER_PORT),
                    protocol: ecs.Protocol.TCP,
                },
                {
                    containerPort: 8082,
                    hostPort: 8082,
                    protocol: ecs.Protocol.TCP,
                },
            ],
            logging: ecs.LogDrivers.awsLogs({
                streamPrefix: 'ecs',
                logGroup: props.logGroup,
            }),
            environment: {
                MF_METADATA_DB_HOST: props.database.dbInstanceEndpointAddress,
                MF_METADATA_DB_PORT: props.database.dbInstanceEndpointPort,
                MF_METADATA_DB_USER: constants_1.ServiceInfo.DB_USER,
                MF_METADATA_DB_PSWD: props.secret
                    .secretValueFromJson('password')
                    .toString(),
                MF_METADATA_DB_NAME: 'metaflow',
            },
        });
        // this.fargateTaskDefinition.addContainer('xray', {
        //   image: ecs.ContainerImage.fromRegistry('amazon/aws-xray-daemon'),
        //   essential: true,
        //   memoryReservationMiB: 256,
        //   environment: {
        //     AWS_REGION: cdk.Stack.of(this).region,
        //   },
        //   portMappings: [
        //     {
        //       containerPort: 2000,
        //       protocol: ecs.Protocol.UDP,
        //     },
        //   ],
        //   logging: ecs.LogDrivers.awsLogs({
        //     streamPrefix: 'xray',
        //     logGroup: props.logGroup,
        //   }),
        //   entryPoint: ['/usr/bin/xray', '-b', '127.0.0.1:2000', '-l', 'dev', '-o'],
        // });
        this.fargateService = new ecs.FargateService(this, 'Service', {
            cluster: props.cluster,
            taskDefinition: this.fargateTaskDefinition,
            vpcSubnets: {
                subnetType: ec2.SubnetType.PUBLIC,
            },
            desiredCount: Number(constants_1.ServiceInfo.DESIRED_COUNT),
            securityGroups: [props.securityGroup],
            assignPublicIp: true,
            healthCheckGracePeriod: cdk.Duration.minutes(10),
            minHealthyPercent: 75,
            maxHealthyPercent: 200,
        });
    }
}
exports.MetaflowFargateService = MetaflowFargateService;
_a = JSII_RTTI_SYMBOL_1;
MetaflowFargateService[_a] = { fqn: "cdk-metaflow.MetaflowFargateService", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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