"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MetaflowNlb = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("@aws-cdk/aws-ec2");
const elbv2 = require("@aws-cdk/aws-elasticloadbalancingv2");
const cdk = require("@aws-cdk/core");
/**
 * @experimental
 * @summary Metaflow Nlb
 */
class MetaflowNlb extends cdk.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.nlb = new elbv2.NetworkLoadBalancer(this, 'ExternalNlb', {
            vpc: props.vpc,
            vpcSubnets: { subnetType: ec2.SubnetType.PUBLIC },
        });
        this.nlbTargetGroup = new elbv2.NetworkTargetGroup(this, 'nlb-target-group', {
            protocol: elbv2.Protocol.TCP,
            targetType: elbv2.TargetType.IP,
            port: 8080,
            vpc: props.vpc,
            healthCheck: {
                healthyThresholdCount: 2,
                unhealthyThresholdCount: 2,
                protocol: elbv2.Protocol.TCP,
                interval: cdk.Duration.seconds(10),
                timeout: cdk.Duration.seconds(10),
            },
        });
        this.dbMigrateTargetGroup = new elbv2.NetworkTargetGroup(this, 'db-migrate-target-group', {
            protocol: elbv2.Protocol.TCP,
            targetType: elbv2.TargetType.IP,
            port: 8082,
            vpc: props.vpc,
            healthCheck: {
                healthyThresholdCount: 2,
                unhealthyThresholdCount: 2,
                port: '8080',
                protocol: elbv2.Protocol.TCP,
                interval: cdk.Duration.seconds(10),
                timeout: cdk.Duration.seconds(10),
            },
        });
        new elbv2.NetworkListener(this, 'nlb-listener', {
            loadBalancer: this.nlb,
            port: 80,
            protocol: elbv2.Protocol.TCP,
            defaultAction: elbv2.NetworkListenerAction.forward([this.nlbTargetGroup]),
        });
        new elbv2.NetworkListener(this, 'db-migrate-listener', {
            loadBalancer: this.nlb,
            port: 8082,
            protocol: elbv2.Protocol.TCP,
            defaultAction: elbv2.NetworkListenerAction.forward([
                this.dbMigrateTargetGroup,
            ]),
        });
    }
}
exports.MetaflowNlb = MetaflowNlb;
_a = JSII_RTTI_SYMBOL_1;
MetaflowNlb[_a] = { fqn: "cdk-metaflow.MetaflowNlb", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibmxiLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vc3JjL2NvbnN0cnVjdHMvbmxiLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsd0NBQXdDO0FBQ3hDLDZEQUE2RDtBQUM3RCxxQ0FBcUM7Ozs7O0FBT3JDLE1BQWEsV0FBWSxTQUFRLEdBQUcsQ0FBQyxTQUFTOzs7O0lBSzVDLFlBQVksS0FBb0IsRUFBRSxFQUFVLEVBQUUsS0FBdUI7UUFDbkUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixJQUFJLENBQUMsR0FBRyxHQUFHLElBQUksS0FBSyxDQUFDLG1CQUFtQixDQUFDLElBQUksRUFBRSxhQUFhLEVBQUU7WUFDNUQsR0FBRyxFQUFFLEtBQUssQ0FBQyxHQUFHO1lBQ2QsVUFBVSxFQUFFLEVBQUUsVUFBVSxFQUFFLEdBQUcsQ0FBQyxVQUFVLENBQUMsTUFBTSxFQUFFO1NBQ2xELENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyxjQUFjLEdBQUcsSUFBSSxLQUFLLENBQUMsa0JBQWtCLENBQ2hELElBQUksRUFDSixrQkFBa0IsRUFDbEI7WUFDRSxRQUFRLEVBQUUsS0FBSyxDQUFDLFFBQVEsQ0FBQyxHQUFHO1lBQzVCLFVBQVUsRUFBRSxLQUFLLENBQUMsVUFBVSxDQUFDLEVBQUU7WUFDL0IsSUFBSSxFQUFFLElBQUk7WUFDVixHQUFHLEVBQUUsS0FBSyxDQUFDLEdBQUc7WUFDZCxXQUFXLEVBQUU7Z0JBQ1gscUJBQXFCLEVBQUUsQ0FBQztnQkFDeEIsdUJBQXVCLEVBQUUsQ0FBQztnQkFDMUIsUUFBUSxFQUFFLEtBQUssQ0FBQyxRQUFRLENBQUMsR0FBRztnQkFDNUIsUUFBUSxFQUFFLEdBQUcsQ0FBQyxRQUFRLENBQUMsT0FBTyxDQUFDLEVBQUUsQ0FBQztnQkFDbEMsT0FBTyxFQUFFLEdBQUcsQ0FBQyxRQUFRLENBQUMsT0FBTyxDQUFDLEVBQUUsQ0FBQzthQUNsQztTQUNGLENBQ0YsQ0FBQztRQUVGLElBQUksQ0FBQyxvQkFBb0IsR0FBRyxJQUFJLEtBQUssQ0FBQyxrQkFBa0IsQ0FDdEQsSUFBSSxFQUNKLHlCQUF5QixFQUN6QjtZQUNFLFFBQVEsRUFBRSxLQUFLLENBQUMsUUFBUSxDQUFDLEdBQUc7WUFDNUIsVUFBVSxFQUFFLEtBQUssQ0FBQyxVQUFVLENBQUMsRUFBRTtZQUMvQixJQUFJLEVBQUUsSUFBSTtZQUNWLEdBQUcsRUFBRSxLQUFLLENBQUMsR0FBRztZQUNkLFdBQVcsRUFBRTtnQkFDWCxxQkFBcUIsRUFBRSxDQUFDO2dCQUN4Qix1QkFBdUIsRUFBRSxDQUFDO2dCQUMxQixJQUFJLEVBQUUsTUFBTTtnQkFDWixRQUFRLEVBQUUsS0FBSyxDQUFDLFFBQVEsQ0FBQyxHQUFHO2dCQUM1QixRQUFRLEVBQUUsR0FBRyxDQUFDLFFBQVEsQ0FBQyxPQUFPLENBQUMsRUFBRSxDQUFDO2dCQUNsQyxPQUFPLEVBQUUsR0FBRyxDQUFDLFFBQVEsQ0FBQyxPQUFPLENBQUMsRUFBRSxDQUFDO2FBQ2xDO1NBQ0YsQ0FDRixDQUFDO1FBRUYsSUFBSSxLQUFLLENBQUMsZUFBZSxDQUFDLElBQUksRUFBRSxjQUFjLEVBQUU7WUFDOUMsWUFBWSxFQUFFLElBQUksQ0FBQyxHQUFJO1lBQ3ZCLElBQUksRUFBRSxFQUFFO1lBQ1IsUUFBUSxFQUFFLEtBQUssQ0FBQyxRQUFRLENBQUMsR0FBRztZQUM1QixhQUFhLEVBQUUsS0FBSyxDQUFDLHFCQUFxQixDQUFDLE9BQU8sQ0FBQyxDQUFDLElBQUksQ0FBQyxjQUFjLENBQUMsQ0FBQztTQUMxRSxDQUFDLENBQUM7UUFFSCxJQUFJLEtBQUssQ0FBQyxlQUFlLENBQUMsSUFBSSxFQUFFLHFCQUFxQixFQUFFO1lBQ3JELFlBQVksRUFBRSxJQUFJLENBQUMsR0FBSTtZQUN2QixJQUFJLEVBQUUsSUFBSTtZQUNWLFFBQVEsRUFBRSxLQUFLLENBQUMsUUFBUSxDQUFDLEdBQUc7WUFDNUIsYUFBYSxFQUFFLEtBQUssQ0FBQyxxQkFBcUIsQ0FBQyxPQUFPLENBQUM7Z0JBQ2pELElBQUksQ0FBQyxvQkFBb0I7YUFDMUIsQ0FBQztTQUNILENBQUMsQ0FBQztJQUNMLENBQUM7O0FBakVILGtDQWtFQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGVjMiBmcm9tICdAYXdzLWNkay9hd3MtZWMyJztcbmltcG9ydCAqIGFzIGVsYnYyIGZyb20gJ0Bhd3MtY2RrL2F3cy1lbGFzdGljbG9hZGJhbGFuY2luZ3YyJztcbmltcG9ydCAqIGFzIGNkayBmcm9tICdAYXdzLWNkay9jb3JlJztcblxuZXhwb3J0IGludGVyZmFjZSBNZXRhZmxvd05sYlByb3BzIHtcbiAgcmVhZG9ubHkgdnBjOiBlYzIuSVZwYztcbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBNZXRhZmxvd05sYiBleHRlbmRzIGNkay5Db25zdHJ1Y3Qge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgbmxiOiBlbGJ2Mi5OZXR3b3JrTG9hZEJhbGFuY2VyO1xuICByZWFkb25seSBubGJUYXJnZXRHcm91cDogZWxidjIuTmV0d29ya1RhcmdldEdyb3VwO1xuICByZWFkb25seSBkYk1pZ3JhdGVUYXJnZXRHcm91cDogZWxidjIuTmV0d29ya1RhcmdldEdyb3VwO1xuICBjb25zdHJ1Y3RvcihzY29wZTogY2RrLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IE1ldGFmbG93TmxiUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgdGhpcy5ubGIgPSBuZXcgZWxidjIuTmV0d29ya0xvYWRCYWxhbmNlcih0aGlzLCAnRXh0ZXJuYWxObGInLCB7XG4gICAgICB2cGM6IHByb3BzLnZwYyxcbiAgICAgIHZwY1N1Ym5ldHM6IHsgc3VibmV0VHlwZTogZWMyLlN1Ym5ldFR5cGUuUFVCTElDIH0sXG4gICAgfSk7XG5cbiAgICB0aGlzLm5sYlRhcmdldEdyb3VwID0gbmV3IGVsYnYyLk5ldHdvcmtUYXJnZXRHcm91cChcbiAgICAgIHRoaXMsXG4gICAgICAnbmxiLXRhcmdldC1ncm91cCcsXG4gICAgICB7XG4gICAgICAgIHByb3RvY29sOiBlbGJ2Mi5Qcm90b2NvbC5UQ1AsXG4gICAgICAgIHRhcmdldFR5cGU6IGVsYnYyLlRhcmdldFR5cGUuSVAsXG4gICAgICAgIHBvcnQ6IDgwODAsXG4gICAgICAgIHZwYzogcHJvcHMudnBjLFxuICAgICAgICBoZWFsdGhDaGVjazoge1xuICAgICAgICAgIGhlYWx0aHlUaHJlc2hvbGRDb3VudDogMixcbiAgICAgICAgICB1bmhlYWx0aHlUaHJlc2hvbGRDb3VudDogMixcbiAgICAgICAgICBwcm90b2NvbDogZWxidjIuUHJvdG9jb2wuVENQLFxuICAgICAgICAgIGludGVydmFsOiBjZGsuRHVyYXRpb24uc2Vjb25kcygxMCksXG4gICAgICAgICAgdGltZW91dDogY2RrLkR1cmF0aW9uLnNlY29uZHMoMTApLFxuICAgICAgICB9LFxuICAgICAgfSxcbiAgICApO1xuXG4gICAgdGhpcy5kYk1pZ3JhdGVUYXJnZXRHcm91cCA9IG5ldyBlbGJ2Mi5OZXR3b3JrVGFyZ2V0R3JvdXAoXG4gICAgICB0aGlzLFxuICAgICAgJ2RiLW1pZ3JhdGUtdGFyZ2V0LWdyb3VwJyxcbiAgICAgIHtcbiAgICAgICAgcHJvdG9jb2w6IGVsYnYyLlByb3RvY29sLlRDUCxcbiAgICAgICAgdGFyZ2V0VHlwZTogZWxidjIuVGFyZ2V0VHlwZS5JUCxcbiAgICAgICAgcG9ydDogODA4MixcbiAgICAgICAgdnBjOiBwcm9wcy52cGMsXG4gICAgICAgIGhlYWx0aENoZWNrOiB7XG4gICAgICAgICAgaGVhbHRoeVRocmVzaG9sZENvdW50OiAyLFxuICAgICAgICAgIHVuaGVhbHRoeVRocmVzaG9sZENvdW50OiAyLFxuICAgICAgICAgIHBvcnQ6ICc4MDgwJyxcbiAgICAgICAgICBwcm90b2NvbDogZWxidjIuUHJvdG9jb2wuVENQLFxuICAgICAgICAgIGludGVydmFsOiBjZGsuRHVyYXRpb24uc2Vjb25kcygxMCksXG4gICAgICAgICAgdGltZW91dDogY2RrLkR1cmF0aW9uLnNlY29uZHMoMTApLFxuICAgICAgICB9LFxuICAgICAgfSxcbiAgICApO1xuXG4gICAgbmV3IGVsYnYyLk5ldHdvcmtMaXN0ZW5lcih0aGlzLCAnbmxiLWxpc3RlbmVyJywge1xuICAgICAgbG9hZEJhbGFuY2VyOiB0aGlzLm5sYiEsXG4gICAgICBwb3J0OiA4MCxcbiAgICAgIHByb3RvY29sOiBlbGJ2Mi5Qcm90b2NvbC5UQ1AsXG4gICAgICBkZWZhdWx0QWN0aW9uOiBlbGJ2Mi5OZXR3b3JrTGlzdGVuZXJBY3Rpb24uZm9yd2FyZChbdGhpcy5ubGJUYXJnZXRHcm91cF0pLFxuICAgIH0pO1xuXG4gICAgbmV3IGVsYnYyLk5ldHdvcmtMaXN0ZW5lcih0aGlzLCAnZGItbWlncmF0ZS1saXN0ZW5lcicsIHtcbiAgICAgIGxvYWRCYWxhbmNlcjogdGhpcy5ubGIhLFxuICAgICAgcG9ydDogODA4MixcbiAgICAgIHByb3RvY29sOiBlbGJ2Mi5Qcm90b2NvbC5UQ1AsXG4gICAgICBkZWZhdWx0QWN0aW9uOiBlbGJ2Mi5OZXR3b3JrTGlzdGVuZXJBY3Rpb24uZm9yd2FyZChbXG4gICAgICAgIHRoaXMuZGJNaWdyYXRlVGFyZ2V0R3JvdXAsXG4gICAgICBdKSxcbiAgICB9KTtcbiAgfVxufVxuIl19