import * as ec2 from '@aws-cdk/aws-ec2';
import * as rds from '@aws-cdk/aws-rds';
import * as secretsmanager from '@aws-cdk/aws-secretsmanager';
import * as cdk from '@aws-cdk/core';
/**
 * @experimental
 * @summary Metaflow Database Interface
 */
export interface IMetaflowDatabase {
    /**
     * (experimental) Database credentials in standard RDS json format.
     *
     * @experimental
     */
    readonly credentials: secretsmanager.ISecret;
    /**
     * (experimental) A database instance;
     *
     * can be extended to be a union type of Aurora Serverless or RDS Cluster.
     *
     * @experimental
     */
    readonly database: rds.IDatabaseInstance;
}
/**
 * @experimental
 */
export interface MetaflowDatabaseInstanceProps {
    /**
     * @experimental
     */
    readonly vpc: ec2.IVpc;
    /**
     * @experimental
     */
    readonly dbSubnets: ec2.SubnetSelection;
    /**
     * @experimental
     */
    readonly dbSecurityGroups: ec2.SecurityGroup[];
}
/**
 * (experimental) Provides a very basic RDS database instance.
 *
 * @experimental
 */
export declare class MetaflowDatabaseInstance extends cdk.Construct implements IMetaflowDatabase {
    /**
     * (experimental) Database credentials in standard RDS json format.
     *
     * @experimental
     */
    readonly credentials: secretsmanager.ISecret;
    /**
     * (experimental) A database instance;
     *
     * can be extended to be a union type of Aurora Serverless or RDS Cluster.
     *
     * @experimental
     */
    readonly database: rds.IDatabaseInstance;
    /**
     * @experimental
     */
    constructor(scope: cdk.Construct, id: string, props: MetaflowDatabaseInstanceProps);
}
