"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MetaflowDatabaseInstance = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const rds = require("@aws-cdk/aws-rds");
const secretsmanager = require("@aws-cdk/aws-secretsmanager");
const cdk = require("@aws-cdk/core");
const constants_1 = require("./constants");
/**
 * (experimental) Provides a very basic RDS database instance.
 *
 * @experimental
 */
class MetaflowDatabaseInstance extends cdk.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.credentials = new secretsmanager.Secret(this, 'metaflow-rds-secret', {
            secretName: 'metaflow-rds-secret',
            removalPolicy: cdk.RemovalPolicy.DESTROY,
            generateSecretString: {
                secretStringTemplate: JSON.stringify({
                    username: constants_1.ServiceInfo.DB_USER,
                }),
                excludePunctuation: true,
                includeSpace: false,
                generateStringKey: 'password',
            },
            description: 'This is a Secrets Manager secret for an RDS DB instance',
        });
        const database = new rds.DatabaseInstance(this, 'DBInstance', {
            ...constants_1.DefaultRdsConfig,
            vpc: props.vpc,
            vpcSubnets: props.dbSubnets,
            allocatedStorage: 20,
            credentials: rds.Credentials.fromSecret(this.credentials),
            securityGroups: props.dbSecurityGroups,
            databaseName: constants_1.ServiceInfo.DB_NAME,
            parameterGroup: rds.ParameterGroup.fromParameterGroupName(this, 'ParameterGroup', 'default.postgres11'),
        });
        this.database = database;
    }
}
exports.MetaflowDatabaseInstance = MetaflowDatabaseInstance;
_a = JSII_RTTI_SYMBOL_1;
MetaflowDatabaseInstance[_a] = { fqn: "cdk-metaflow.MetaflowDatabaseInstance", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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