"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MetaflowBucket = exports.DefaultBucketProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const s3 = require("@aws-cdk/aws-s3");
const core_1 = require("@aws-cdk/core");
/**
 * Default artifact bucket settings.
 */
exports.DefaultBucketProps = {
    blockPublicAccess: s3.BlockPublicAccess.BLOCK_ALL,
    removalPolicy: core_1.RemovalPolicy.DESTROY,
};
/**
 * @experimental
 * @summary Metaflow S3 Bucket
 * S3 bucket for metaflow artifacts. Creates a standard bucket for holding
 * metaflow artifacts and with iam DENY policy for REST-HEADER auth.
 */
class MetaflowBucket extends s3.Bucket {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id, { ...exports.DefaultBucketProps, ...props });
        this.addToResourcePolicy(new iam.PolicyStatement({
            principals: [new iam.AnyPrincipal()],
            effect: iam.Effect.DENY,
            actions: ['s3:*'],
            resources: [`arn:${core_1.Aws.PARTITION}:s3:::${this.bucketName}/*`],
            conditions: {
                StringNotEquals: {
                    's3:authType': 'REST-HEADER',
                },
            },
        }));
        this.resource = this.node.findChild('Resource');
    }
}
exports.MetaflowBucket = MetaflowBucket;
_a = JSII_RTTI_SYMBOL_1;
MetaflowBucket[_a] = { fqn: "cdk-metaflow.MetaflowBucket", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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