"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MetaflowVpc = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("@aws-cdk/aws-ec2");
const defaults = {
    cidr: '10.20.0.0/16',
    enableDnsSupport: true,
    enableDnsHostnames: true,
    maxAzs: 2,
    natGateways: 0,
    subnetConfiguration: [
        { cidrMask: 24, name: 'Public', subnetType: ec2.SubnetType.PUBLIC },
    ],
};
/**
 * @experimental
 * @summary Metaflow VPC
 */
class MetaflowVpc extends ec2.Vpc {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id, { ...defaults, ...props });
        this.vpc = this.node.findChild('Resource');
    }
}
exports.MetaflowVpc = MetaflowVpc;
_a = JSII_RTTI_SYMBOL_1;
MetaflowVpc[_a] = { fqn: "cdk-metaflow.MetaflowVpc", version: "0.0.12" };
//# sourceMappingURL=data:application/json;base64,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