"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegMetaflowStack = void 0;
const cdk = require("@aws-cdk/core");
const __1 = require("..");
/**
 * Integration test. This lives in the src directory so we can run it.
 * @internal
 */
class IntegMetaflowStack extends cdk.Stack {
    constructor(scope, id, props = {}) {
        super(scope, id, props);
        this.metaflow = new __1.Metaflow(this, 'metaflow');
    }
}
exports.IntegMetaflowStack = IntegMetaflowStack;
const devEnv = {
    account: process.env.CDK_DEFAULT_ACCOUNT,
    region: process.env.CDK_DEFAULT_REGION,
};
const app = new cdk.App();
new IntegMetaflowStack(app, 'integ-metaflow-stack', { env: devEnv });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWctbWV0YWZsb3ctc3RhY2suanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvaW50ZWcvaW50ZWctbWV0YWZsb3ctc3RhY2sudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEscUNBQXFDO0FBQ3JDLDBCQUE4QjtBQUM5Qjs7O0dBR0c7QUFDSCxNQUFhLGtCQUFtQixTQUFRLEdBQUcsQ0FBQyxLQUFLO0lBRS9DLFlBQVksS0FBb0IsRUFBRSxFQUFVLEVBQUUsUUFBd0IsRUFBRTtRQUN0RSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxLQUFLLENBQUMsQ0FBQztRQUN4QixJQUFJLENBQUMsUUFBUSxHQUFHLElBQUksWUFBUSxDQUFDLElBQUksRUFBRSxVQUFVLENBQUMsQ0FBQztJQUNqRCxDQUFDO0NBQ0Y7QUFORCxnREFNQztBQUVELE1BQU0sTUFBTSxHQUFHO0lBQ2IsT0FBTyxFQUFFLE9BQU8sQ0FBQyxHQUFHLENBQUMsbUJBQW1CO0lBQ3hDLE1BQU0sRUFBRSxPQUFPLENBQUMsR0FBRyxDQUFDLGtCQUFrQjtDQUN2QyxDQUFDO0FBRUYsTUFBTSxHQUFHLEdBQUcsSUFBSSxHQUFHLENBQUMsR0FBRyxFQUFFLENBQUM7QUFDMUIsSUFBSSxrQkFBa0IsQ0FBQyxHQUFHLEVBQUUsc0JBQXNCLEVBQUUsRUFBRSxHQUFHLEVBQUUsTUFBTSxFQUFFLENBQUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGNkayBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7IE1ldGFmbG93IH0gZnJvbSAnLi4nO1xuLyoqXG4gKiBJbnRlZ3JhdGlvbiB0ZXN0LiBUaGlzIGxpdmVzIGluIHRoZSBzcmMgZGlyZWN0b3J5IHNvIHdlIGNhbiBydW4gaXQuXG4gKiBAaW50ZXJuYWxcbiAqL1xuZXhwb3J0IGNsYXNzIEludGVnTWV0YWZsb3dTdGFjayBleHRlbmRzIGNkay5TdGFjayB7XG4gIHB1YmxpYyByZWFkb25seSBtZXRhZmxvdzogTWV0YWZsb3c7XG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBjZGsuQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogY2RrLlN0YWNrUHJvcHMgPSB7fSkge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwgcHJvcHMpO1xuICAgIHRoaXMubWV0YWZsb3cgPSBuZXcgTWV0YWZsb3codGhpcywgJ21ldGFmbG93Jyk7XG4gIH1cbn1cblxuY29uc3QgZGV2RW52ID0ge1xuICBhY2NvdW50OiBwcm9jZXNzLmVudi5DREtfREVGQVVMVF9BQ0NPVU5ULFxuICByZWdpb246IHByb2Nlc3MuZW52LkNES19ERUZBVUxUX1JFR0lPTixcbn07XG5cbmNvbnN0IGFwcCA9IG5ldyBjZGsuQXBwKCk7XG5uZXcgSW50ZWdNZXRhZmxvd1N0YWNrKGFwcCwgJ2ludGVnLW1ldGFmbG93LXN0YWNrJywgeyBlbnY6IGRldkVudiB9KTtcbiJdfQ==