"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BannerMessage = exports.AWS_AMPLIFY_DEFAULT_BANNER_URL = void 0;
const node_fetch_1 = __importDefault(require("node-fetch"));
const semver_1 = __importDefault(require("semver"));
const proxy_agent_1 = __importDefault(require("proxy-agent"));
const logger_1 = require("../logger");
exports.AWS_AMPLIFY_DEFAULT_BANNER_URL = 'https://aws-amplify.github.io/amplify-cli/banner-message.json';
const MAX_SUPPORTED_MESSAGE_CONFIG_VERSION = '1.0.0';
const logger = logger_1.getLogger('amplify-cli-core', 'banner-message/index.ts');
class BannerMessage {
    constructor(cliVersion) {
        this.cliVersion = cliVersion;
        this.messages = [];
        this.fetchMessages = async (url) => {
            var _a;
            try {
                logger.info(`fetch banner messages from ${url}`);
                const proxy = process.env.HTTP_PROXY || process.env.HTTPS_PROXY;
                const fetchOptions = proxy ? { agent: new proxy_agent_1.default(proxy) } : {};
                const result = await node_fetch_1.default(url, fetchOptions);
                const body = await result.json();
                if (!semver_1.default.satisfies(body.version, MAX_SUPPORTED_MESSAGE_CONFIG_VERSION)) {
                    return;
                }
                this.messages = (_a = body.messages) !== null && _a !== void 0 ? _a : [];
            }
            catch (e) {
                logger.error('fetch banner message failed', e);
            }
        };
        this.getMessages = async (messageId) => {
            var _a;
            if (!this.messages.length) {
                await this.fetchMessages((_a = process.env.AMPLIFY_CLI_BANNER_MESSAGE_URL) !== null && _a !== void 0 ? _a : exports.AWS_AMPLIFY_DEFAULT_BANNER_URL);
            }
            const matchingMessageItems = this.messages.filter(m => {
                var _a, _b;
                return m.id === messageId &&
                    ((_a = m.conditions) === null || _a === void 0 ? void 0 : _a.enabled) !== false &&
                    (((_b = m.conditions) === null || _b === void 0 ? void 0 : _b.cliVersions) ? semver_1.default.satisfies(this.cliVersion, m.conditions.cliVersions) : true);
            });
            const messageItem = matchingMessageItems.find(m => {
                var _a, _b, _c, _d;
                if (m.conditions) {
                    const currentTime = Date.now();
                    const startTime = ((_a = m.conditions) === null || _a === void 0 ? void 0 : _a.startTime) ? Date.parse((_b = m.conditions) === null || _b === void 0 ? void 0 : _b.startTime) : currentTime;
                    const endTime = ((_c = m.conditions) === null || _c === void 0 ? void 0 : _c.endTime) ? Date.parse((_d = m.conditions) === null || _d === void 0 ? void 0 : _d.endTime) : currentTime;
                    return currentTime >= startTime && currentTime <= endTime;
                }
                return true;
            });
            return messageItem === null || messageItem === void 0 ? void 0 : messageItem.message;
        };
    }
}
exports.BannerMessage = BannerMessage;
BannerMessage.initialize = (cliVersion) => {
    if (!BannerMessage.instance) {
        BannerMessage.instance = new BannerMessage(cliVersion);
    }
    return BannerMessage.instance;
};
BannerMessage.ensureInitialized = () => {
    if (!BannerMessage.instance) {
        throw new Error('BannerMessage is not initialized');
    }
};
BannerMessage.getMessage = async (messageId) => {
    BannerMessage.ensureInitialized();
    return BannerMessage.instance.getMessages(messageId);
};
BannerMessage.releaseInstance = () => {
    BannerMessage.instance = undefined;
};
//# sourceMappingURL=index.js.map