"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.removeFromDeploymentSecrets = exports.mergeDeploymentSecrets = void 0;
const lodash_1 = __importDefault(require("lodash"));
const recursiveOmit_1 = require("./utils/recursiveOmit");
const mergeDeploymentSecrets = (deploymentSecretsModifier) => {
    const { currentDeploymentSecrets, category, rootStackId, envName, resource, keyName, value } = deploymentSecretsModifier;
    const newDeploymentAppSecret = lodash_1.default.find(currentDeploymentSecrets.appSecrets, appSecret => appSecret.rootStackId === rootStackId) || {
        rootStackId,
        environments: {},
    };
    lodash_1.default.set(newDeploymentAppSecret, ['environments', envName, category, resource, keyName], value);
    return {
        appSecrets: [...currentDeploymentSecrets.appSecrets.filter(appSecret => appSecret.rootStackId !== rootStackId), newDeploymentAppSecret],
    };
};
exports.mergeDeploymentSecrets = mergeDeploymentSecrets;
const removeFromDeploymentSecrets = (deploymentSecretsModifier) => {
    const { currentDeploymentSecrets, category, rootStackId, envName, resource, keyName } = deploymentSecretsModifier;
    const secretsByAppId = lodash_1.default.find(currentDeploymentSecrets.appSecrets, secrets => secrets.rootStackId === rootStackId);
    if (secretsByAppId) {
        recursiveOmit_1.recursiveOmit(secretsByAppId.environments, [envName, category, resource, keyName]);
        if (Object.keys(secretsByAppId.environments).length === 0) {
            currentDeploymentSecrets.appSecrets = currentDeploymentSecrets.appSecrets.filter(r => r.rootStackId !== rootStackId);
        }
    }
    return currentDeploymentSecrets;
};
exports.removeFromDeploymentSecrets = removeFromDeploymentSecrets;
//# sourceMappingURL=deploymentSecretsHelper.js.map