import { ViewResourceTableParams } from './cliViewAPI';
import { ServiceSelection } from './serviceSelection';
export * from './cfnUtilities';
export * from './cliContext';
export * from './cliContextEnvironmentProvider';
export * from './cliEnvironmentProvider';
export * from './feature-flags';
export * from './permissionsBoundaryState';
export * from './jsonUtilities';
export * from './jsonValidationError';
export * from './serviceSelection';
export * from './state-manager';
export * from './tags';
export * from './errors';
export * from './exitOnNextTick';
export * from './isPackaged';
export * from './cliConstants';
export * from './deploymentSecretsHelper';
export * from './deploymentState';
export * from './utils';
export * from './banner-message';
export * from './cliGetCategories';
export * from './cliRemoveResourcePrompt';
export * from './cliViewAPI';
export * from './hooks';
export declare type $TSAny = any;
export declare type $TSContext = {
    amplify: AmplifyToolkit;
    print: IContextPrint;
    migrationInfo: $TSAny;
    projectHasMobileHubResources: boolean;
    prompt: $TSAny;
    exeInfo: $TSAny;
    input: $TSAny;
    parameters: $TSAny;
    usageData: $TSAny;
    runtime: $TSAny;
    pluginPlatform: IPluginPlatform;
    newUserInfo?: $TSAny;
    filesystem: IContextFilesystem;
    template: IContextTemplate;
};
export declare type CategoryName = string;
export declare type ResourceName = string;
export declare type IContextPrint = {
    info: (message: string) => void;
    fancy: (message?: string) => void;
    warning: (message: string) => void;
    error: (message: string) => void;
    success: (message: string) => void;
    table: (data: string[][], options?: {
        format?: 'markdown' | 'lean';
    }) => void;
    debug: (message: string) => void;
    green: (message: string) => void;
    yellow: (message: string) => void;
    red: (message: string) => void;
    blue: (message: string) => void;
};
export declare type IContextFilesystem = {
    remove: (targetPath: string) => void;
    read: (targetPath: string, encoding?: string) => $TSAny;
    write: (targetPath: string, data: unknown) => void;
    exists: (targetPath: string) => boolean;
    isFile: (targetPath: string) => boolean;
    path: (...pathParts: string[]) => string;
};
export declare type IContextTemplate = {
    generate: (opts: {
        template: string;
        target: string;
        props: object;
        directory: string;
    }) => string;
};
export declare type IPluginPlatform = {
    pluginDirectories: string[];
    pluginPrefixes: string[];
    userAddedLocations: string[];
    lastScanTime: Date;
    maxScanIntervalInSeconds: Number;
    plugins: IPluginCollection;
    excluded: IPluginCollection;
};
export declare type IPluginCollection = {
    [pluginType: string]: IPluginInfo[];
};
export declare type IPluginInfo = {
    packageName: string;
    packageVersion: string;
    packageLocation: string;
    manifest: $IPluginManifest;
};
export declare type DeploymentSecrets = {
    appSecrets: Array<{
        rootStackId: string;
        environments: {
            [env: string]: {
                [category: string]: {
                    [resourceName: string]: {
                        [key: string]: string;
                    };
                };
            };
        };
    }>;
};
export declare type GetPackageAssetPaths = () => Promise<string[]>;
export declare type $IPluginManifest = $TSAny;
export declare type $TSMeta = any;
export declare type $TSTeamProviderInfo = any;
export declare type $TSObject = Record<string, $TSAny>;
export interface ResourceTuple {
    category: string;
    resourceName: string;
}
export declare enum AmplifyFrontend {
    android = "android",
    ios = "ios",
    javascript = "javascript"
}
export interface AmplifyProjectConfig {
    projectName: string;
    version: string;
    frontend: AmplifyFrontend;
    providers: string[];
}
export declare type $TSCopyJob = any;
interface AmplifyToolkit {
    confirmPrompt: (prompt: string, defaultValue?: boolean) => Promise<boolean>;
    constants: $TSAny;
    constructExeInfo: (context: $TSContext) => $TSAny;
    copyBatch: (context: $TSContext, jobs: $TSCopyJob[], props: object, force?: boolean, writeParams?: boolean | object) => $TSAny;
    crudFlow: (role: string, permissionMap?: $TSObject, defaults?: $TSAny[]) => $TSAny;
    deleteProject: () => $TSAny;
    executeProviderUtils: (context: $TSContext, providerName: string, utilName: string, options: $TSAny) => $TSAny;
    getAllEnvs: () => string[];
    getPlugin: () => $TSAny;
    getCategoryPluginInfo: (context: $TSContext, category?: string, service?: string) => $TSAny;
    getAllCategoryPluginInfo: (context: $TSContext) => $TSAny;
    getFrontendPlugins: (context: $TSContext) => $TSAny;
    getEnvDetails: () => $TSAny;
    getEnvInfo: () => $TSAny;
    getProviderPlugins: (context: $TSContext) => $TSAny;
    getPluginInstance: (context: $TSContext, pluginName: string) => $TSAny;
    getProjectConfig: () => $TSAny;
    getProjectDetails: () => $TSAny;
    getProjectMeta: () => $TSMeta;
    getResourceStatus: (category?: $TSAny, resourceName?: $TSAny, providerName?: $TSAny, filteredResources?: $TSAny) => $TSAny;
    getResourceOutputs: () => $TSAny;
    getWhen: () => $TSAny;
    inputValidation: (input: $TSAny) => (value: $TSAny) => boolean | string;
    listCategories: () => $TSAny;
    makeId: (n?: number) => string;
    openEditor: (context: $TSContext, target: string, waitToContinue?: boolean) => Promise<void>;
    onCategoryOutputsChange: (context: $TSContext, currentAmplifyMeta: $TSMeta | undefined, amplifyMeta?: $TSMeta) => $TSAny;
    pathManager: $TSAny;
    pressEnterToContinue: () => $TSAny;
    pushResources: (context: $TSContext, category?: string, resourceName?: string, filteredResources?: {
        category: string;
        resourceName: string;
    }[]) => $TSAny;
    storeCurrentCloudBackend: () => $TSAny;
    readJsonFile: () => $TSAny;
    removeDeploymentSecrets: (context: $TSContext, category: string, resource: string) => void;
    removeResource: (context: $TSContext, category: string, resource: string, questionOptions?: $TSAny, resourceNameCallback?: (resourceName: string) => Promise<void>) => $TSAny;
    sharedQuestions: () => $TSAny;
    showAllHelp: () => $TSAny;
    showHelp: (header: string, commands: {
        name: string;
        description: string;
    }[]) => $TSAny;
    showHelpfulProviderLinks: (context: $TSContext) => $TSAny;
    showResourceTable: () => $TSAny;
    showStatusTable: (resourceTableParams: ViewResourceTableParams) => $TSAny;
    serviceSelectionPrompt: (context: $TSContext, category: string, servicesMetadata: $TSAny, customQuestion?: $TSAny, optionNameOverrides?: Record<string, string>) => Promise<ServiceSelection>;
    updateProjectConfig: () => $TSAny;
    updateamplifyMetaAfterResourceUpdate: (category: string, resourceName: string, metaResourceKey: string, metaResourceData?: $TSAny) => $TSMeta;
    updateamplifyMetaAfterResourceAdd: (category: string, resourceName: string, metaResourceData: $TSAny, backendResourceData?: $TSAny, overwriteObjectIfExists?: boolean) => void;
    updateamplifyMetaAfterResourceDelete: (category: string, resourceName: string) => void;
    updateProvideramplifyMeta: (providerName: string, options: $TSObject) => void;
    updateamplifyMetaAfterPush: (resources: $TSObject[]) => void;
    updateamplifyMetaAfterBuild: (resource: ResourceTuple, buildType?: string) => void;
    updateAmplifyMetaAfterPackage: (resource: ResourceTuple, zipFilename: string, hash?: {
        resourceKey: string;
        hashValue: string;
    }) => void;
    updateBackendConfigAfterResourceAdd: (category: string, resourceName: string, resourceData: $TSAny) => $TSAny;
    updateBackendConfigAfterResourceUpdate: () => $TSAny;
    updateBackendConfigAfterResourceRemove: () => $TSAny;
    loadEnvResourceParameters: (context: $TSContext, category: string, resourceName: string) => $TSAny;
    saveEnvResourceParameters: (context: $TSContext, category: string, resourceName: string, envSpecificParams?: $TSObject) => void;
    removeResourceParameters: (context: $TSContext, category: string, resource: string) => void;
    triggerFlow: () => $TSAny;
    addTrigger: () => $TSAny;
    updateTrigger: () => $TSAny;
    deleteTrigger: () => $TSAny;
    deleteAllTriggers: () => $TSAny;
    deleteDeselectedTriggers: () => $TSAny;
    dependsOnBlock: () => $TSAny;
    getTriggerMetadata: () => $TSAny;
    getTriggerPermissions: () => $TSAny;
    getTriggerEnvVariables: () => $TSAny;
    getTriggerEnvInputs: () => $TSAny;
    getUserPoolGroupList: () => $TSAny[];
    forceRemoveResource: () => $TSAny;
    writeObjectAsJson: () => $TSAny;
    hashDir: (dir: string, exclude: string[]) => Promise<string>;
    leaveBreadcrumbs: (category: string, resourceName: string, breadcrumbs: unknown) => void;
    readBreadcrumbs: (category: string, resourceName: string) => $TSAny;
    loadRuntimePlugin: (context: $TSContext, pluginId: string) => Promise<$TSAny>;
    getImportedAuthProperties: (context: $TSContext) => {
        imported: boolean;
        userPoolId?: string;
        authRoleArn?: string;
        authRoleName?: string;
        unauthRoleArn?: string;
        unauthRoleName?: string;
    };
    invokePluginMethod: <T>(context: $TSContext, category: string, service: string | undefined, method: string, args: any[]) => Promise<T>;
}
//# sourceMappingURL=index.d.ts.map