import { $TSAny, $TSMeta, $TSTeamProviderInfo, DeploymentSecrets, HooksConfig } from '..';
import { Tag } from '../tags';
export declare type GetOptions<T> = {
    throwIfNotExist?: boolean;
    preserveComments?: boolean;
    default?: T;
};
export declare type ResourceEntry = {
    resourceName: string;
    resource: Record<string, object>;
};
export declare class StateManager {
    metaFileExists: (projectPath?: string | undefined) => boolean;
    getMeta: (projectPath?: string | undefined, options?: GetOptions<any> | undefined) => $TSMeta;
    currentMetaFileExists: (projectPath?: string | undefined) => boolean;
    setDeploymentSecrets: (deploymentSecrets: DeploymentSecrets) => void;
    getCurrentMeta: (projectPath?: string | undefined, options?: GetOptions<any> | undefined) => $TSMeta;
    getDeploymentSecrets: () => DeploymentSecrets;
    getProjectTags: (projectPath?: string | undefined) => Tag[];
    getCurrentProjectTags: (projectPath?: string | undefined) => Tag[];
    teamProviderInfoExists: (projectPath?: string | undefined) => boolean;
    getTeamProviderInfo: (projectPath?: string | undefined, options?: GetOptions<any> | undefined) => $TSTeamProviderInfo;
    localEnvInfoExists: (projectPath?: string | undefined) => boolean;
    getLocalEnvInfo: (projectPath?: string | undefined, options?: GetOptions<any> | undefined) => $TSAny;
    localAWSInfoExists: (projectPath?: string | undefined) => boolean;
    getLocalAWSInfo: (projectPath?: string | undefined, options?: GetOptions<any> | undefined) => $TSAny;
    projectConfigExists: (projectPath?: string | undefined) => boolean;
    getProjectConfig: (projectPath?: string | undefined, options?: GetOptions<any> | undefined) => $TSAny;
    backendConfigFileExists: (projectPath?: string | undefined) => boolean;
    getBackendConfig: (projectPath?: string | undefined, options?: GetOptions<any> | undefined) => $TSAny;
    getResourceParametersJson: (projectPath: string | undefined, category: string, resourceName: string, options?: GetOptions<any> | undefined) => $TSAny;
    getCurrentResourceParametersJson: (projectPath: string | undefined, category: string, resourceName: string, options?: GetOptions<any> | undefined) => $TSAny;
    getAmplifyAdminConfigEntry: (appId: string, options?: GetOptions<any> | undefined) => any;
    removeAmplifyAdminConfigEntry: (appId: string) => void;
    setAmplifyAdminConfigEntry: (appId: string, config: $TSAny) => void;
    setLocalEnvInfo: (projectPath: string | undefined, localEnvInfo: $TSAny) => void;
    setLocalAWSInfo: (projectPath: string | undefined, localAWSInfo: $TSAny) => void;
    getHydratedTags: (projectPath?: string | undefined) => Tag[];
    isTagFilePresent: (projectPath?: string | undefined) => boolean;
    setProjectFileTags: (projectPath: string | undefined, tags: Tag[]) => void;
    setProjectConfig: (projectPath: string | undefined, projectConfig: $TSAny) => void;
    setTeamProviderInfo: (projectPath: string | undefined, teamProviderInfo: $TSTeamProviderInfo) => void;
    setBackendConfig: (projectPath: string | undefined, backendConfig: $TSAny) => void;
    setMeta: (projectPath: string | undefined, meta: $TSMeta) => void;
    setCurrentMeta: (projectPath: string | undefined, meta: $TSMeta) => void;
    getHooksConfigJson: (projectPath?: string | undefined) => HooksConfig;
    setSampleHooksDir: (projectPath: string | undefined, sourceDirPath: string) => void;
    setResourceParametersJson: (projectPath: string | undefined, category: string, resourceName: string, parameters: $TSAny) => void;
    cliJSONFileExists: (projectPath: string, env?: string | undefined) => boolean;
    getCLIJSON: (projectPath: string, env?: string | undefined, options?: GetOptions<any> | undefined) => $TSAny;
    setCLIJSON: (projectPath: string, cliJSON: any, env?: string | undefined) => void;
    getResourceFromMeta: (amplifyMeta: Record<string, any>, categoryName: string, serviceName: string, resourceName?: string | undefined, throwIfNotExist?: boolean) => ResourceEntry | null;
    private filterResourcesFromMeta;
    private doesExist;
    private getData;
}
export declare const stateManager: StateManager;
//# sourceMappingURL=stateManager.d.ts.map