"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getFolderSize = exports.convertNumBytes = void 0;
const globby_1 = __importDefault(require("globby"));
const fs = __importStar(require("fs-extra"));
const convertNumBytes = (numBytes) => ({
    toKB: () => Math.round(numBytes / 1024),
    toMB: () => Math.round(numBytes / 1024 ** 2),
});
exports.convertNumBytes = convertNumBytes;
async function getFolderSize(filePaths) {
    const paths = await globby_1.default(filePaths, { followSymbolicLinks: false });
    let totalSizeInBytes = 0;
    for (const path of paths) {
        try {
            const { size } = await fs.stat(path);
            totalSizeInBytes += size;
        }
        catch (error) {
        }
    }
    return totalSizeInBytes;
}
exports.getFolderSize = getFolderSize;
//# sourceMappingURL=fileSize.js.map