import { Validator } from './validators';
export declare const prompter: Prompter;
declare type Prompter = {
    confirmContinue: (message?: string) => Promise<boolean>;
    yesOrNo: (message: string, initial?: boolean) => Promise<boolean>;
    input: <RS extends ReturnSize = 'one', T = string>(message: string, ...options: MaybeOptionalInputOptions<RS, T>) => Promise<PromptReturn<RS, T>>;
    pick: <RS extends ReturnSize = 'one', T = string>(message: string, choices: Choices<T>, ...options: MaybeOptionalPickOptions<RS>) => Promise<PromptReturn<RS, T>>;
};
declare type MaybeAvailableHiddenInputOption<RS extends ReturnSize> = RS extends 'many' ? {} : {
    hidden?: boolean;
};
declare type InitialSelectionOption<RS extends ReturnSize> = {
    initial?: RS extends 'one' ? number : number[];
};
declare type InitialValueOption<T> = {
    initial?: T;
};
declare type ValidateValueOption = {
    validate?: Validator;
};
declare type TransformOption<T> = {
    transform: (value: string) => T | Promise<T>;
};
declare type MaybeOptionalTransformOption<T> = T extends string ? Partial<TransformOption<T>> : TransformOption<T>;
declare type ReturnSizeOption<RS extends ReturnSize> = RS extends 'many' ? {
    returnSize: 'many';
} : {
    returnSize?: 'one';
};
declare type Choices<T> = T extends string ? GenericChoice<T>[] | string[] : GenericChoice<T>[];
declare type GenericChoice<T> = {
    name: string;
    value: T;
    hint?: string;
    disabled?: boolean;
};
declare type ReturnSize = 'many' | 'one';
declare type MaybeOptionalInputOptions<RS extends ReturnSize, T> = RS extends 'many' ? [InputOptions<RS, T>] : T extends string ? [InputOptions<RS, T>?] : [InputOptions<RS, T>];
declare type MaybeOptionalPickOptions<RS extends ReturnSize> = RS extends 'many' ? [PickOptions<RS>] : [PickOptions<RS>?];
declare type PromptReturn<RS extends ReturnSize, T> = RS extends 'many' ? T[] : T;
declare type PickOptions<RS extends ReturnSize> = ReturnSizeOption<RS> & InitialSelectionOption<RS>;
declare type InputOptions<RS extends ReturnSize, T> = ReturnSizeOption<RS> & ValidateValueOption & InitialValueOption<T> & MaybeOptionalTransformOption<T> & MaybeAvailableHiddenInputOption<RS>;
export {};
//# sourceMappingURL=prompter.d.ts.map