"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.prompter = void 0;
const enquirer_1 = require("enquirer");
const actions = __importStar(require("enquirer/lib/combos"));
const flags_1 = require("./flags");
const printer_1 = require("./printer");
class AmplifyPrompter {
    constructor(prompter = enquirer_1.prompt, print = printer_1.printer) {
        this.prompter = prompter;
        this.print = print;
        this.confirmContinue = async (message = 'Do you want to continue?') => {
            if (flags_1.isYes) {
                return true;
            }
            return this.yesOrNoCommon(message, false);
        };
        this.yesOrNo = async (message, initial = true) => {
            if (flags_1.isYes) {
                return initial;
            }
            return this.yesOrNoCommon(message, initial);
        };
        this.yesOrNoCommon = async (message, initial) => {
            let submitted = false;
            const { result } = await this.prompter({
                type: 'confirm',
                name: 'result',
                message,
                format: value => (submitted ? (value ? 'yes' : 'no') : ''),
                onSubmit: () => (submitted = true),
                initial,
            });
            return result;
        };
        this.input = async (message, ...options) => {
            var _a;
            const opts = options === null || options === void 0 ? void 0 : options[0];
            if (flags_1.isYes) {
                if (opts === null || opts === void 0 ? void 0 : opts.initial) {
                    return opts.initial;
                }
                else {
                    throw new Error(`Cannot prompt for [${message}] when '--yes' flag is set`);
                }
            }
            const validator = ((opts === null || opts === void 0 ? void 0 : opts.returnSize) === 'many' ? validateEachWith(opts === null || opts === void 0 ? void 0 : opts.validate) : opts === null || opts === void 0 ? void 0 : opts.validate);
            const { result } = await this.prompter({
                type: ((_a = opts) === null || _a === void 0 ? void 0 : _a.hidden) ? 'invisible' : (opts === null || opts === void 0 ? void 0 : opts.returnSize) === 'many' ? 'list' : 'input',
                name: 'result',
                message,
                validate: validator,
                initial: opts === null || opts === void 0 ? void 0 : opts.initial,
                footer: (opts === null || opts === void 0 ? void 0 : opts.returnSize) === 'many' ? 'Enter a comma-delimited list of values' : undefined,
            });
            if (typeof (opts === null || opts === void 0 ? void 0 : opts.transform) === 'function') {
                if (Array.isArray(result)) {
                    return (await Promise.all(result.map(async (part) => opts.transform(part))));
                }
                return opts.transform(result);
            }
            else {
                return result;
            }
        };
        this.pick = async (message, choices, ...options) => {
            if ((choices === null || choices === void 0 ? void 0 : choices.length) === 0) {
                throw new Error(`No choices provided for prompt [${message}]`);
            }
            const opts = options === null || options === void 0 ? void 0 : options[0];
            const genericChoices = typeof choices[0] === 'string'
                ? choices.map(choice => ({ name: choice, value: choice }))
                : choices;
            const choiceValueMap = new Map();
            const enquirerChoices = genericChoices.map(choice => {
                choiceValueMap.set(choice.name, choice.value);
                return { name: choice.name, disabled: choice.disabled, hint: choice.hint };
            });
            actions.ctrl.a = 'a';
            let result = genericChoices[0].name;
            if ((choices === null || choices === void 0 ? void 0 : choices.length) === 1) {
                this.print.info(`Only one option for [${message}]. Selecting [${result}].`);
            }
            else if (flags_1.isYes) {
                if ((opts === null || opts === void 0 ? void 0 : opts.initial) === undefined || (Array.isArray(opts === null || opts === void 0 ? void 0 : opts.initial) && (opts === null || opts === void 0 ? void 0 : opts.initial.length) === 0)) {
                    throw new Error(`Cannot prompt for [${message}] when '--yes' flag is set`);
                }
                if (typeof (opts === null || opts === void 0 ? void 0 : opts.initial) === 'number') {
                    result = genericChoices[opts === null || opts === void 0 ? void 0 : opts.initial].name;
                }
                else {
                    result = opts === null || opts === void 0 ? void 0 : opts.initial.map(idx => genericChoices[idx].name);
                }
            }
            else {
                ({ result } = await this.prompter({
                    actions,
                    footer: (opts === null || opts === void 0 ? void 0 : opts.returnSize) === 'many' ? '(Use <space> to select, <ctrl + a> to toggle all)' : undefined,
                    type: 'autocomplete',
                    name: 'result',
                    message,
                    initial: opts === null || opts === void 0 ? void 0 : opts.initial,
                    multiple: (opts === null || opts === void 0 ? void 0 : opts.returnSize) === 'many',
                    choices: enquirerChoices,
                }));
            }
            if (Array.isArray(result)) {
                return result.map(item => choiceValueMap.get(item));
            }
            else {
                return choiceValueMap.get(result);
            }
        };
    }
}
exports.prompter = new AmplifyPrompter();
const validateEachWith = (validator) => async (input) => {
    if (!validator) {
        return true;
    }
    const validationList = await Promise.all(input.map(part => part.trim()).map(async (part) => ({ part, result: await validator(part) })));
    const firstInvalid = validationList.find(v => typeof v.result === 'string');
    if (firstInvalid) {
        return `${firstInvalid.part} did not satisfy requirement ${firstInvalid.result}`;
    }
    return true;
};
//# sourceMappingURL=prompter.js.map