"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.methodCall = exports.block = exports.newline = exports.isNullOrEmpty = exports.toJson = exports.compoundExpression = exports.comment = exports.set = exports.list = exports.obj = exports.qref = exports.ref = exports.nul = exports.bool = exports.int = exports.float = exports.quotes = exports.raw = exports.str = exports.forEach = exports.ret = exports.not = exports.notEquals = exports.equals = exports.parens = exports.or = exports.and = exports.ifElse = exports.iff = void 0;
function iff(predicate, expr, inline) {
    return {
        kind: 'If',
        predicate,
        expr,
        inline,
    };
}
exports.iff = iff;
function ifElse(predicate, ifExpr, elseExpr, inline) {
    return {
        kind: 'IfElse',
        predicate,
        ifExpr,
        elseExpr,
        inline,
    };
}
exports.ifElse = ifElse;
function and(expressions) {
    return {
        kind: 'And',
        expressions,
    };
}
exports.and = and;
function or(expressions) {
    return {
        kind: 'Or',
        expressions,
    };
}
exports.or = or;
function parens(expr) {
    return {
        kind: 'Parens',
        expr,
    };
}
exports.parens = parens;
function equals(leftExpr, rightExpr) {
    return {
        kind: 'Equals',
        leftExpr,
        rightExpr,
    };
}
exports.equals = equals;
function notEquals(leftExpr, rightExpr) {
    return {
        kind: 'NotEquals',
        leftExpr,
        rightExpr,
    };
}
exports.notEquals = notEquals;
function not(expr) {
    return {
        kind: 'Not',
        expr,
    };
}
exports.not = not;
function ret(value) {
    return {
        kind: 'Return',
        value,
    };
}
exports.ret = ret;
function forEach(key, collection, expressions) {
    return {
        kind: 'ForEach',
        key,
        collection,
        expressions,
    };
}
exports.forEach = forEach;
function str(value) {
    return {
        kind: 'String',
        value,
    };
}
exports.str = str;
function raw(value) {
    return {
        kind: 'Raw',
        value,
    };
}
exports.raw = raw;
function quotes(expr) {
    return {
        kind: 'Quotes',
        expr,
    };
}
exports.quotes = quotes;
function float(value) {
    return {
        kind: 'Float',
        value,
    };
}
exports.float = float;
function int(value) {
    return {
        kind: 'Int',
        value,
    };
}
exports.int = int;
function bool(value) {
    return {
        kind: 'Boolean',
        value,
    };
}
exports.bool = bool;
function nul() {
    return {
        kind: 'Null',
    };
}
exports.nul = nul;
function ref(value) {
    return {
        kind: 'Reference',
        value,
    };
}
exports.ref = ref;
function qref(value) {
    return {
        kind: 'QuietReference',
        value,
    };
}
exports.qref = qref;
function obj(o) {
    const attributes = Object.keys(o).map((key) => [key, o[key]]);
    return {
        kind: 'Object',
        attributes,
    };
}
exports.obj = obj;
function list(expressions) {
    return {
        kind: 'List',
        expressions,
    };
}
exports.list = list;
function set(key, value) {
    return {
        kind: 'Set',
        key,
        value,
    };
}
exports.set = set;
function comment(text) {
    return {
        kind: 'Comment',
        text,
    };
}
exports.comment = comment;
function compoundExpression(expressions, joiner = `\n`, recurseIndent = true) {
    return {
        kind: 'CompoundExpression',
        expressions,
        joiner,
        recurseIndent: recurseIndent,
    };
}
exports.compoundExpression = compoundExpression;
function toJson(expr) {
    return {
        kind: 'Util.ToJson',
        expr,
    };
}
exports.toJson = toJson;
function isNullOrEmpty(expr) {
    return {
        kind: 'Util.isNullOrEmpty',
        expr,
    };
}
exports.isNullOrEmpty = isNullOrEmpty;
function newline() {
    return {
        kind: 'NewLine',
    };
}
exports.newline = newline;
function block(name, exprs) {
    return compoundExpression([comment(`[Start] ${name}`), ...exprs, comment(`[End] ${name}`)]);
}
exports.block = block;
function methodCall(methodName, ...params) {
    return compoundExpression([methodName, parens(compoundExpression(params, ', '))], '', false);
}
exports.methodCall = methodCall;
//# sourceMappingURL=ast.js.map