"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpMappingTemplate = void 0;
const ast_1 = require("./ast");
class HttpMappingTemplate {
    static getRequest({ resourcePath, params }) {
        return ast_1.obj({
            version: ast_1.str(this.RESOLVER_VERSION_ID),
            method: ast_1.str('GET'),
            resourcePath: ast_1.str(resourcePath),
            params,
        });
    }
    static postRequest({ resourcePath, params }) {
        return ast_1.obj({
            version: ast_1.str(this.RESOLVER_VERSION_ID),
            method: ast_1.str('POST'),
            resourcePath: ast_1.str(resourcePath),
            params,
        });
    }
    static putRequest({ resourcePath, params }) {
        return ast_1.obj({
            version: ast_1.str(this.RESOLVER_VERSION_ID),
            method: ast_1.str('PUT'),
            resourcePath: ast_1.str(resourcePath),
            params,
        });
    }
    static deleteRequest({ resourcePath, params }) {
        return ast_1.obj({
            version: ast_1.str(this.RESOLVER_VERSION_ID),
            method: ast_1.str('DELETE'),
            resourcePath: ast_1.str(resourcePath),
            params,
        });
    }
    static patchRequest({ resourcePath, params }) {
        return ast_1.obj({
            version: ast_1.str(this.RESOLVER_VERSION_ID),
            method: ast_1.str('PATCH'),
            resourcePath: ast_1.str(resourcePath),
            params,
        });
    }
}
exports.HttpMappingTemplate = HttpMappingTemplate;
HttpMappingTemplate.RESOLVER_VERSION_ID = '2018-05-29';
//# sourceMappingURL=http.js.map