import { DocumentNode } from 'graphql';
import { TemplateContext } from './RelationalDBSchemaTransformer';
export declare class RelationalDBResolverGenerator {
    document: DocumentNode;
    typePrimaryKeyMap: Map<string, string>;
    stringFieldMap: Map<string, string[]>;
    intFieldMap: Map<string, string[]>;
    resolverFilePath: string;
    typePrimaryKeyTypeMap: Map<string, string>;
    constructor(context: TemplateContext);
    createRelationalResolvers(resolverFilePath: string, improvePluralization: boolean): {};
    private makeCreateRelationalResolver;
    private makeGetRelationalResolver;
    private makeUpdateRelationalResolver;
    private makeDeleteRelationalResolver;
    private makeListRelationalResolver;
    private getTableName;
    private getFieldName;
    private getTablePrimaryKey;
    private isPrimaryKeyAStringType;
    private generateSelectStatement;
    private generateSelectByPrimaryKeyStatement;
    private generateInsertStatement;
    private generateUpdateStatement;
    private generateDeleteStatement;
}
//# sourceMappingURL=RelationalDBResolverGenerator.d.ts.map