import { ObjectTypeDefinitionNode, SchemaDefinitionNode, InputObjectTypeDefinitionNode, DocumentNode } from 'graphql';
import { IRelationalDBReader } from './IRelationalDBReader';
export declare class TableContext {
    tableTypeDefinition: ObjectTypeDefinitionNode;
    createTypeDefinition: InputObjectTypeDefinitionNode;
    updateTypeDefinition: InputObjectTypeDefinitionNode;
    tableKeyField: string;
    tableKeyFieldType: string;
    stringFieldList: string[];
    intFieldList: string[];
    constructor(typeDefinition: ObjectTypeDefinitionNode, createDefinition: InputObjectTypeDefinitionNode, updateDefinition: InputObjectTypeDefinitionNode, primaryKeyField: string, primaryKeyType: string, stringFieldList: string[], intFieldList: string[]);
}
export declare class TemplateContext {
    schemaDoc: DocumentNode;
    typePrimaryKeyMap: Map<string, string>;
    typePrimaryKeyTypeMap: Map<string, string>;
    stringFieldMap: Map<string, string[]>;
    intFieldMap: Map<string, string[]>;
    secretStoreArn: string;
    rdsClusterIdentifier: string;
    databaseName: string;
    databaseSchema: string;
    region: string;
    constructor(schemaDoc: DocumentNode, typePrimaryKeyMap: Map<string, string>, stringFieldMap: Map<string, string[]>, intFieldMap: Map<string, string[]>, typePrimaryKeyTypeMap?: Map<string, string>);
}
export declare class RelationalDBSchemaTransformer {
    dbReader: IRelationalDBReader;
    database: string;
    constructor(dbReader: IRelationalDBReader, database: string);
    introspectDatabaseSchema: () => Promise<TemplateContext>;
    getSchemaType(): SchemaDefinitionNode;
    private getMutations;
    private getSubscriptions;
    private getQueries;
    getConnectionType(tableName: string): ObjectTypeDefinitionNode;
}
//# sourceMappingURL=RelationalDBSchemaTransformer.d.ts.map