"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.collectEnumValueDirectives = exports.collectEnumDirectives = exports.collectInputObjectDirectives = exports.collectScalarDirectives = exports.collectUnionDirectives = exports.collectArgumentDirectives = exports.collectFieldDirectives = exports.collectInterfaceDirectives = exports.collectObjectDirectives = exports.collectDirectivesByType = exports.collectDirectivesByTypeNames = exports.collectDirectives = exports.collectDirectiveNames = void 0;
const graphql_1 = require("graphql");
function collectDirectiveNames(sdl) {
    const dirs = collectDirectives(sdl);
    return dirs.map(d => d.name.value);
}
exports.collectDirectiveNames = collectDirectiveNames;
function collectDirectives(sdl) {
    const doc = graphql_1.parse(sdl);
    let directives = [];
    for (const def of doc.definitions) {
        switch (def.kind) {
            case graphql_1.Kind.OBJECT_TYPE_DEFINITION:
                directives = directives.concat(collectObjectDirectives(def));
                break;
            case graphql_1.Kind.INTERFACE_TYPE_DEFINITION:
                directives = directives.concat(collectInterfaceDirectives(def));
                break;
            case graphql_1.Kind.UNION_TYPE_DEFINITION:
                directives = directives.concat(collectUnionDirectives(def));
                break;
            case graphql_1.Kind.INPUT_OBJECT_TYPE_DEFINITION:
                directives = directives.concat(collectInputObjectDirectives(def));
                break;
            case graphql_1.Kind.ENUM_TYPE_DEFINITION:
                directives = directives.concat(collectEnumDirectives(def));
                break;
            case graphql_1.Kind.SCALAR_TYPE_DEFINITION:
                directives = directives.concat(collectScalarDirectives(def));
                break;
        }
    }
    return directives;
}
exports.collectDirectives = collectDirectives;
function collectDirectivesByTypeNames(sdl) {
    let types = collectDirectivesByType(sdl);
    const directives = new Set();
    Object.keys(types).forEach(dir => {
        let set = new Set();
        types[dir].forEach((d) => {
            set.add(d.name.value);
            directives.add(d.name.value);
        });
        types[dir] = Array.from(set);
    });
    return { types, directives: Array.from(directives) };
}
exports.collectDirectivesByTypeNames = collectDirectivesByTypeNames;
function collectDirectivesByType(sdl) {
    const doc = graphql_1.parse(sdl);
    let types = {};
    for (const def of doc.definitions) {
        switch (def.kind) {
            case graphql_1.Kind.OBJECT_TYPE_DEFINITION:
                types[def.name.value] = [...(types[def.name.value] || []), ...collectObjectDirectives(def)];
                break;
            case graphql_1.Kind.INTERFACE_TYPE_DEFINITION:
                types[def.name.value] = [...(types[def.name.value] || []), ...collectInterfaceDirectives(def)];
                break;
            case graphql_1.Kind.UNION_TYPE_DEFINITION:
                types[def.name.value] = [...(types[def.name.value] || []), ...collectUnionDirectives(def)];
                break;
            case graphql_1.Kind.INPUT_OBJECT_TYPE_DEFINITION:
                types[def.name.value] = [...(types[def.name.value] || []), ...collectInputObjectDirectives(def)];
                break;
            case graphql_1.Kind.ENUM_TYPE_DEFINITION:
                types[def.name.value] = [...(types[def.name.value] || []), ...collectEnumDirectives(def)];
                break;
            case graphql_1.Kind.SCALAR_TYPE_DEFINITION:
                types[def.name.value] = [...(types[def.name.value] || []), ...collectScalarDirectives(def)];
                break;
        }
    }
    return types;
}
exports.collectDirectivesByType = collectDirectivesByType;
function collectObjectDirectives(node) {
    let dirs = [];
    for (const field of node.fields) {
        const fieldDirs = collectFieldDirectives(field);
        dirs = dirs.concat(fieldDirs);
    }
    return dirs.concat(node.directives);
}
exports.collectObjectDirectives = collectObjectDirectives;
function collectInterfaceDirectives(node) {
    let dirs = [];
    for (const field of node.fields) {
        const fieldDirs = collectFieldDirectives(field);
        dirs = dirs.concat(fieldDirs);
    }
    return dirs.concat(node.directives);
}
exports.collectInterfaceDirectives = collectInterfaceDirectives;
function collectFieldDirectives(node) {
    let dirs = [];
    for (const arg of node.arguments) {
        const argDirs = collectArgumentDirectives(arg);
        dirs = dirs.concat(argDirs);
    }
    return dirs.concat(node.directives);
}
exports.collectFieldDirectives = collectFieldDirectives;
function collectArgumentDirectives(node) {
    return [...(node.directives || [])];
}
exports.collectArgumentDirectives = collectArgumentDirectives;
function collectUnionDirectives(node) {
    return [...(node.directives || [])];
}
exports.collectUnionDirectives = collectUnionDirectives;
function collectScalarDirectives(node) {
    return [...(node.directives || [])];
}
exports.collectScalarDirectives = collectScalarDirectives;
function collectInputObjectDirectives(node) {
    let dirs = [];
    for (const field of node.fields) {
        const fieldDirs = collectArgumentDirectives(field);
        dirs = dirs.concat(fieldDirs);
    }
    return dirs.concat(node.directives);
}
exports.collectInputObjectDirectives = collectInputObjectDirectives;
function collectEnumDirectives(node) {
    let dirs = [];
    for (const val of node.values) {
        const valDirs = collectEnumValueDirectives(val);
        dirs = dirs.concat(valDirs);
    }
    return dirs.concat(node.directives);
}
exports.collectEnumDirectives = collectEnumDirectives;
function collectEnumValueDirectives(node) {
    return [...(node.directives || [])];
}
exports.collectEnumValueDirectives = collectEnumValueDirectives;
//# sourceMappingURL=collectDirectives.js.map