"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SchemaResourceUtil = void 0;
const appSync_1 = __importDefault(require("cloudform-types/types/appSync"));
const cloudform_types_1 = require("cloudform-types");
const graphql_transformer_common_1 = require("graphql-transformer-common");
const RESOLVERS_DIRECTORY_NAME = 'resolvers';
const STACKS_DIRECTORY_NAME = 'stacks';
class SchemaResourceUtil {
    makeResolverS3RootParams() {
        return {
            Parameters: {
                [graphql_transformer_common_1.ResourceConstants.PARAMETERS.Env]: new cloudform_types_1.StringParameter({
                    Description: `The environment name. e.g. Dev, Test, or Production`,
                    Default: graphql_transformer_common_1.ResourceConstants.NONE,
                }),
                [graphql_transformer_common_1.ResourceConstants.PARAMETERS.S3DeploymentBucket]: new cloudform_types_1.StringParameter({
                    Description: 'The S3 bucket containing all deployment assets for the project.',
                }),
                [graphql_transformer_common_1.ResourceConstants.PARAMETERS.S3DeploymentRootKey]: new cloudform_types_1.StringParameter({
                    Description: 'An S3 key relative to the S3DeploymentBucket that points to the root of the deployment directory.',
                }),
            },
        };
    }
    makeEnvironmentConditions() {
        return {
            [graphql_transformer_common_1.ResourceConstants.CONDITIONS.HasEnvironmentParameter]: cloudform_types_1.Fn.Not(cloudform_types_1.Fn.Equals(cloudform_types_1.Fn.Ref(graphql_transformer_common_1.ResourceConstants.PARAMETERS.Env), graphql_transformer_common_1.ResourceConstants.NONE)),
        };
    }
    updateResolverResource(resource) {
        resource.Properties.RequestMappingTemplateS3Location = cloudform_types_1.Fn.Sub('s3://${S3DeploymentBucket}/${S3DeploymentRootKey}/resolvers/${ResolverFileName}', {
            S3DeploymentBucket: cloudform_types_1.Fn.Ref(graphql_transformer_common_1.ResourceConstants.PARAMETERS.S3DeploymentBucket),
            S3DeploymentRootKey: cloudform_types_1.Fn.Ref(graphql_transformer_common_1.ResourceConstants.PARAMETERS.S3DeploymentRootKey),
            ResolverFileName: cloudform_types_1.Fn.Join('.', [resource.Properties.TypeName, resource.Properties.FieldName, 'req', 'vtl']),
        });
        resource.Properties.ResponseMappingTemplateS3Location = cloudform_types_1.Fn.Sub('s3://${S3DeploymentBucket}/${S3DeploymentRootKey}/resolvers/${ResolverFileName}', {
            S3DeploymentBucket: cloudform_types_1.Fn.Ref(graphql_transformer_common_1.ResourceConstants.PARAMETERS.S3DeploymentBucket),
            S3DeploymentRootKey: cloudform_types_1.Fn.Ref(graphql_transformer_common_1.ResourceConstants.PARAMETERS.S3DeploymentRootKey),
            ResolverFileName: cloudform_types_1.Fn.Join('.', [resource.Properties.TypeName, resource.Properties.FieldName, 'res', 'vtl']),
        });
        delete resource.Properties.RequestMappingTemplate;
        delete resource.Properties.ResponseMappingTemplate;
        return resource;
    }
    updateFunctionConfigurationResource(resource) {
        resource.Properties.RequestMappingTemplateS3Location = cloudform_types_1.Fn.Sub('s3://${S3DeploymentBucket}/${S3DeploymentRootKey}/pipelineFunctions/${ResolverFileName}', {
            S3DeploymentBucket: cloudform_types_1.Fn.Ref(graphql_transformer_common_1.ResourceConstants.PARAMETERS.S3DeploymentBucket),
            S3DeploymentRootKey: cloudform_types_1.Fn.Ref(graphql_transformer_common_1.ResourceConstants.PARAMETERS.S3DeploymentRootKey),
            ResolverFileName: cloudform_types_1.Fn.Join('.', [resource.Properties.Name, 'req', 'vtl']),
        });
        resource.Properties.ResponseMappingTemplateS3Location = cloudform_types_1.Fn.Sub('s3://${S3DeploymentBucket}/${S3DeploymentRootKey}/pipelineFunctions/${ResolverFileName}', {
            S3DeploymentBucket: cloudform_types_1.Fn.Ref(graphql_transformer_common_1.ResourceConstants.PARAMETERS.S3DeploymentBucket),
            S3DeploymentRootKey: cloudform_types_1.Fn.Ref(graphql_transformer_common_1.ResourceConstants.PARAMETERS.S3DeploymentRootKey),
            ResolverFileName: cloudform_types_1.Fn.Join('.', [resource.Properties.Name, 'res', 'vtl']),
        });
        delete resource.Properties.RequestMappingTemplate;
        delete resource.Properties.ResponseMappingTemplate;
        return resource;
    }
    makeAppSyncSchema(schema) {
        if (schema) {
            return new appSync_1.default.GraphQLSchema({
                ApiId: cloudform_types_1.Fn.GetAtt(graphql_transformer_common_1.ResourceConstants.RESOURCES.GraphQLAPILogicalID, 'ApiId'),
                Definition: schema,
            });
        }
        return new appSync_1.default.GraphQLSchema({
            ApiId: cloudform_types_1.Fn.GetAtt(graphql_transformer_common_1.ResourceConstants.RESOURCES.GraphQLAPILogicalID, 'ApiId'),
            DefinitionS3Location: cloudform_types_1.Fn.Sub('s3://${S3DeploymentBucket}/${S3DeploymentRootKey}/schema.graphql', {
                S3DeploymentBucket: cloudform_types_1.Fn.Ref(graphql_transformer_common_1.ResourceConstants.PARAMETERS.S3DeploymentBucket),
                S3DeploymentRootKey: cloudform_types_1.Fn.Ref(graphql_transformer_common_1.ResourceConstants.PARAMETERS.S3DeploymentRootKey),
            }),
        });
    }
}
exports.SchemaResourceUtil = SchemaResourceUtil;
//# sourceMappingURL=SchemaResourceUtil.js.map