"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TtlTransformer = void 0;
const graphql_transformer_core_1 = require("graphql-transformer-core");
const graphql_transformer_common_1 = require("graphql-transformer-common");
class TtlTransformer extends graphql_transformer_core_1.Transformer {
    constructor() {
        super("TtlTransformer", graphql_transformer_core_1.gql `
        directive @ttl on FIELD_DEFINITION
      `);
        this.field = (parent, definition, directive, acc) => {
            if (!["AWSTimestamp", "Int"].includes(graphql_transformer_common_1.getBaseType(definition.type))) {
                throw new graphql_transformer_core_1.InvalidDirectiveError('Directive "ttl" must be used only on AWSTimestamp or Int type fields.');
            }
            let numberOfTtlDirectivesInsideParentType = 0;
            if (parent.fields) {
                parent.fields.forEach((field) => {
                    if (field.directives) {
                        numberOfTtlDirectivesInsideParentType += field.directives.filter((directive) => directive.name.value === "ttl").length;
                    }
                });
            }
            if (numberOfTtlDirectivesInsideParentType > 1) {
                throw new graphql_transformer_core_1.InvalidDirectiveError('Directive "ttl" must be used only once in the same type.');
            }
            const tableName = graphql_transformer_common_1.ModelResourceIDs.ModelTableResourceID(parent.name.value);
            const table = acc.getResource(tableName);
            const fieldName = definition.name.value;
            table.Properties = {
                ...table.Properties,
                TimeToLiveSpecification: {
                    AttributeName: fieldName,
                    Enabled: true,
                },
            };
        };
    }
}
exports.TtlTransformer = TtlTransformer;
//# sourceMappingURL=ttl-transformer.js.map