# Generated by Django 3.2.16 on 2022-11-18 09:51

from django.db import migrations, models


class Migration(migrations.Migration):
    """
    Increase max URL length for linkchecker
    """

    dependencies = [
        ("linkcheck", "0003_redirect_to_as_textfield"),
        ("cms", "0049_poi_opening_hours"),
    ]

    operations = [
        migrations.AlterField(
            model_name="url",
            name="url",
            field=models.CharField(max_length=1024, unique=True),
        ),
    ]

    def mutate_state(self, project_state, preserve=True):
        """
        This is a workaround that allows to store ``linkcheck``
        migration outside the directory it should be stored.

        :param project_state: The state of the project
        :type project_state: ~django.db.migrations.state.ProjectState

        :param preserve: Whether to preserve the original object state or return a mutated state from a copy.
        :type preserve: bool

        :returns: The new project state with the migration's operations applied to it.
        :rtype: ~django.db.migrations.state.ProjectState
        """
        self.app_label = "linkcheck"
        state = super().mutate_state(project_state, preserve)
        self.app_label = "cms"
        return state

    def apply(self, project_state, schema_editor, collect_sql=False):
        """
        Same workaround as described in ``mutate_state`` method.

        :param project_state: The state of the project
        :type project_state: ~django.db.migrations.state.ProjectState

        :param schema_editor: The database abstraction layer that creates actual SQL code
        :type schema_editor: ~django.db.backends.base.schema.BaseDatabaseSchemaEditor

        :param collect_sql: Whether the operation should be represented as SQL
        :type collect_sql: bool

        :returns: The new project state with the migration's operations applied to it.
        :rtype: ~django.db.migrations.state.ProjectState
        """
        self.app_label = "linkcheck"
        state = super().apply(project_state, schema_editor, collect_sql)
        self.app_label = "cms"
        return state
