"""Fear of the Unknown anti-pattern detector class"""
import re
from sqleyes.detector.antipatterns.abstract_base_class import AbstractDetector
from sqleyes.definitions.definitions import DEFINITIONS
from sqleyes.detector.detector_output import DetectorOutput


class FearOfTheUnknownDetector(AbstractDetector):

    filename = DEFINITIONS["anti_patterns"]["fear_of_the_unknown"]["filename"]
    type = DEFINITIONS["anti_patterns"]["fear_of_the_unknown"]["type"]
    title = DEFINITIONS["anti_patterns"]["fear_of_the_unknown"]["title"]

    def __init__(self, query):
        super().__init__(query)

    def check(self):
        patterns = [re.compile(r'<>\s*NULL', re.IGNORECASE),
                    re.compile(r'!=\s*NULL', re.IGNORECASE),
                    re.compile(r'=\s*NULL', re.IGNORECASE)]
        for pattern in patterns:
            if pattern.search(self.query):
                return DetectorOutput(certainty="high",
                                      description=super().get_description(),
                                      detector_type=self.detector_type,
                                      title=self.title,
                                      type=self.type)

        return None
