# Generated by Django 4.1.7 on 2023-05-25 19:07

import uuid

import django.core.validators
import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("environment", "0006_delete_billingsetup"),
    ]

    operations = [
        migrations.CreateModel(
            name="BillingAccountSharingInvite",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("user_contact_email", models.EmailField(max_length=254)),
                (
                    "billing_account_id",
                    models.CharField(
                        max_length=32,
                        validators=[
                            django.core.validators.RegexValidator(
                                "\\A[A-Z0-9]{6}-[A-Z0-9]{6}-[A-Z0-9]{6}\\Z",
                                message='Invalid ID format. Enter an ID in the format "XXXXXX-XXXXXX-XXXXXX".',
                            )
                        ],
                    ),
                ),
                (
                    "token",
                    models.UUIDField(default=uuid.uuid4, editable=False, unique=True),
                ),
                ("is_consumed", models.BooleanField(default=False)),
                (
                    "owner",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="owner_billingaccountsharinginvite_set",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="user_billingaccountsharinginvite_set",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
    ]
