# Generated by Django 4.2.11 on 2024-06-24 23:55

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):
    dependencies = [
        ("environment", "0014_googlegroup_cloudidentity_user_groups"),
    ]

    operations = [
        migrations.CreateModel(
            name="GCPRegion",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("region", models.CharField(max_length=32)),
            ],
        ),
        migrations.CreateModel(
            name="InstanceType",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "family",
                    models.CharField(
                        choices=[
                            ("general", "General Purpose"),
                            ("compute", "Compute Optimized"),
                            ("memory", "Memory Optimized"),
                            ("storage", "Storage Optimized"),
                            ("accelerator", "Accelerator Optimized"),
                        ],
                        max_length=32,
                    ),
                ),
                ("value", models.CharField(max_length=32)),
            ],
            options={
                "unique_together": {("family", "value")},
            },
        ),
        migrations.CreateModel(
            name="VMInstance",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "machine_type",
                    models.CharField(
                        choices=[
                            ("standard", "Standard"),
                            ("highmem", "High Memory"),
                            ("ultramem", "Ultra Memory"),
                            ("megamem", "Mega Memory"),
                            ("hypermem", "High Memory"),
                            ("highcpu", "High CPU"),
                            ("highgpu", "High GPU"),
                            ("megagpu", "Mega GPU"),
                            ("ultragpu", "Ultra GPU"),
                        ],
                        max_length=32,
                    ),
                ),
                ("cpu", models.IntegerField()),
                ("memory", models.FloatField()),
                ("price", models.FloatField()),
                ("gpu_attachable", models.BooleanField(default=False)),
                (
                    "instance_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="environment.instancetype",
                    ),
                ),
                (
                    "region",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="environment.gcpregion",
                    ),
                ),
            ],
            options={
                "unique_together": {("instance_type", "machine_type", "region", "cpu")},
            },
        ),
    ]
