from django.urls import path

from environment import views
from environment import react_views

urlpatterns = [
    path("", views.research_environments, name="research_environments"),
    path(
        "billing/manage/<billing_account_id>",
        views.manage_billing_account,
        name="manage_billing_account",
    ),
    path(
        "billing/confirm",
        views.confirm_billing_account_sharing,
        name="confirm_billing_account_sharing",
    ),
    path(
        "environments-card/",
        views.research_environments_partial,
        name="research_environments_partial",
    ),
    path(
        "identity-provisioning/",
        views.identity_provisioning,
        name="identity_provisioning",
    ),
    path(
        "environment/stop",
        views.stop_running_environment,
        name="stop_running_environment",
    ),
    path(
        "environment/start",
        views.start_stopped_environment,
        name="start_stopped_environment",
    ),
    path(
        "environment/update",
        views.change_environment_machine_type,
        name="change_environment_machine_type",
    ),
    path("environment/delete", views.delete_environment, name="delete_environment"),
    path(
        "environment/create/<workspace_id>",
        views.create_research_environment,
        name="create_research_environment",
    ),
    path(
        "environment/leave",
        views.leave_shared_environment,
        name="leave_shared_environment",
    ),
    path(
        "environment/manage/<workspace_project_id>/<environment_name>/<workbench_owner_username>/<service_account_name>",
        views.manage_collaborative_environment,
        name="manage_collaborative_environment",
    ),
    path(
        "execution/check-status",
        views.check_execution_status,
        name="check_execution_status",
    ),
    path("workspace/create", views.create_workspace, name="create_workspace"),
    path("workspace/delete", views.delete_workspace, name="delete_workspace"),
    path(
        "workspace/quotas/<workspace_region>/<workspace_project_id>",
        views.get_quotas,
        name="get_quotas",
    ),
    path(
        "sharing/workspace/create",
        views.create_shared_workspace,
        name="create_shared_workspace",
    ),
    path(
        "sharing/workspace/delete",
        views.delete_shared_workspace,
        name="delete_shared_workspace",
    ),
    path(
        "sharing/bucket/create/<workspace_id>",
        views.create_shared_bucket,
        name="create_shared_bucket",
    ),
    path(
        "sharing/bucket/delete", views.delete_shared_bucket, name="delete_shared_bucket"
    ),
    path(
        "sharing/manage/<shared_workspace_name>/<shared_bucket_name>",
        views.manage_shared_bucket,
        name="manage_shared_bucket",
    ),
    path(
        "sharing/manage/<shared_workspace_name>/<shared_bucket_name>/files",
        views.manage_shared_bucket_files,
        name="manage_shared_bucket_files",
    ),
    path(
        "sharing/confirm",
        views.confirm_bucket_sharing,
        name="confirm_bucket_sharing",
    ),
    path(
        "sharing/generate_signed_url/<bucket_name>",
        views.generate_signed_url,
        name="generate_bucket_signed_url",
    ),
    path(
        "sharing/<bucket_name>",
        views.get_shared_bucket_content,
        name="get_shared_bucket_content",
    ),
    path(
        "sharing/<bucket_name>/content/create",
        views.create_shared_bucket_directory,
        name="create_shared_bucket_directory",
    ),
    path(
        "sharing/<bucket_name>/content/delete",
        views.delete_shared_bucket_content,
        name="delete_shared_bucket_content",
    ),
    path("console/group/create", views.create_cloud_group, name="create_cloud_group"),
    path("console/group/delete", views.delete_cloud_group, name="delete_cloud_group"),
    path(
        "console/group/add/<user_id>",
        views.add_user_to_cloud_group,
        name="add_user_to_cloud_group",
    ),
    path(
        "console/group/remove/<user_id>",
        views.remove_user_from_cloud_group,
        name="remove_user_from_cloud_group",
    ),
    path("console/group", views.cloud_groups, name="cloud_groups"),
    path(
        "console/group/management",
        views.cloud_groups_management,
        name="cloud_groups_management",
    ),
    path(
        "console/group/management-table",
        views.cloud_groups_management_partial,
        name="cloud_groups_management_partial",
    ),
    path(
        "console/group/<cloud_group_id>/roles/add",
        views.add_roles_to_cloud_group,
        name="add_roles_to_cloud_group",
    ),
    path(
        "console/group/<cloud_group_id>/roles/remove",
        views.remove_roles_from_cloud_group,
        name="remove_roles_from_cloud_group",
    ),
    path(
        "console/monitoring/datasets",
        views.get_datasets_monitoring_data,
        name="get_datasets_monitoring_data",
    ),
    path(
        "workspace/<workspace_project_id>/update_billing/<current_billing_account_id>/",
        views.update_workspace_billing_account,
        name="update_workspace_billing_account",
    ),
    path(
        "gpu-accelerators/",
        views.get_available_gpu_accelerators_partial,
        name="get_available_gpu_accelerators_partial",
    ),
    path(
        "api/workspaces",
        react_views.get_workspaces_list,
        name="react_views.get_workspaces_list",
    ),
    path(
        "api/shared-workspaces",
        react_views.get_shared_workspaces_list,
        name="react_views.get_shared_workspaces_list",
    ),
    path(
        "api/billing",
        react_views.get_billing_accounts_list,
        name="react_views.get_billing_accounts_list",
    ),
    path(
        "api/user",
        react_views.get_user,
        name="react_views.get_user",
    ),
    path(
        "api/sharing/workspace/create",
        react_views.create_shared_workspace,
        name="react_views.create_shared_workspace",
    ),
    path(
        "api/sharing/workspace/delete",
        react_views.delete_shared_workspace,
        name="react_views.delete_shared_workspace",
    ),
    path(
        "api/workspace/create",
        react_views.create_workspace,
        name="react_views.create_workspace",
    ),
    path(
        "api/workspace/delete",
        react_views.delete_workspace,
        name="react_views.delete_workspace",
    ),
    path(
        "api/available-projects",
        react_views.get_available_projects,
        name="react_views.get_available_projects",
    ),
    path(
        "api/available-resources",
        react_views.get_environment_resource_options,
        name="react_views.get_environment_resource_options",
    ),
    path(
        "api/environment/create/<workspace_project_id>",
        react_views.create_research_environment,
        name="react_views.create_research_environment",
    ),
    path(
        "api/environment/delete",
        react_views.delete_research_environment,
        name="react_views.delete_research_environment",
    ),
    path(
        "api/environment/stop",
        react_views.stop_running_environment,
        name="react_views.stop_running_environment",
    ),
    path(
        "api/environment/start",
        react_views.start_stopped_environment,
        name="react_views.start_stopped_environment",
    ),
    path(
        "api/environment/update",
        react_views.change_environment_machine_type,
        name="react_views.change_environment_machine_type",
    ),
    path(
        "api/sharing/bucket/create/<workspace_id>",
        react_views.create_shared_bucket,
        name="react_views.create_shared_bucket",
    ),
    path(
        "api/sharing/bucket/delete",
        react_views.delete_shared_bucket,
        name="react_views.delete_shared_bucket",
    ),
    path(
        "api/sharing/share/<shared_workspace_name>/<shared_bucket_name>",
        react_views.share_bucket,
        name="react_views.share_bucket",
    ),
    path(
        "api/sharing/confirm",
        react_views.confirm_bucket_sharing,
        name="react_views.confirm_bucket_sharing",
    ),
    path(
        "api/sharing/revoke/<shared_bucket_name>",
        react_views.revoke_shared_bucket_access,
        name="react_views.revoke_shared_bucket_access",
    ),
    path(
        "api/sharing",
        react_views.get_bucket_sharing_invitation,
        name="react_views.get_bucket_sharing_invitation",
    ),
    path(
        "api/sharing/<shared_bucket_name>/shares",
        react_views.get_bucket_shares,
        name="react_views.get_bucket_shares",
    ),
    path(
        "api/billing/share/<billing_account_id>",
        react_views.share_billing_account,
        name="react_views.share_billing_account",
    ),
    path(
        "api/billing/confirm",
        react_views.confirm_bucket_sharing,
        name="react_views.confirm_bucket_sharing",
    ),
    path(
        "api/billing/revoke/<billing_account_id>",
        react_views.revoke_billing_account_access,
        name="react_views.revoke_billing_account_access",
    ),
    path(
        "api/billing/<billing_account_id>/shares",
        react_views.get_billing_shares,
        name="react_views.get_billing_shares",
    ),
    path(
        "api/sharing/generate_signed_url/<bucket_name>",
        react_views.generate_signed_url,
        name="react_views.generate_signed_url",
    ),
    path(
        "api/sharing/<bucket_name>",
        react_views.get_shared_bucket_content,
        name="react_views.get_shared_bucket_content",
    ),
    path(
        "api/sharing/<bucket_name>/content/create",
        react_views.create_shared_bucket_directory,
        name="react_views.create_shared_bucket_directory",
    ),
    path(
        "api/sharing/<bucket_name>/content/delete",
        react_views.delete_shared_bucket_content,
        name="react_views.delete_shared_bucket_content",
    ),
    path(
        "api/workspace/update_billing",
        react_views.update_workspace_billing_account,
        name="react_views.update_workspace_billing_account",
    ),
    path(
        "api/workspace/quotas/<workspace_region>/<workspace_project_id>",
        react_views.get_quotas,
        name="react_views.get_quotas",
    ),
    path(
        "api/identity-provisioning/",
        react_views.identity_provisioning,
        name="react_views.identity_provisioning",
    ),
]
